/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.pushdown;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.query.pushdown.JdbcPushDownConnectionManager;
import org.apache.kylin.source.adhocquery.IPushDownRunner;

public class PushDownRunnerJdbcImpl
implements IPushDownRunner {
    private JdbcPushDownConnectionManager manager = null;

    public void init(KylinConfig config, String project) {
        try {
            this.manager = JdbcPushDownConnectionManager.getConnectionManager(config, project);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void init(KylinConfig config) {
        this.init(config, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String query, List<List<String>> results, List<SelectedColumnMeta> columnMetas, String project) throws SQLException {
        Statement statement = null;
        Connection connection = this.manager.getConnection();
        ResultSet resultSet = null;
        ResultSetMetaData metaData = null;
        int columnCount = 0;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(query);
            this.extractResults(resultSet, results);
            metaData = resultSet.getMetaData();
            columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                columnMetas.add(new SelectedColumnMeta(metaData.isAutoIncrement(i), metaData.isCaseSensitive(i), false, metaData.isCurrency(i), metaData.isNullable(i), false, metaData.getColumnDisplaySize(i), metaData.getColumnLabel(i), metaData.getColumnName(i), null, null, null, metaData.getPrecision(i), metaData.getScale(i), metaData.getColumnType(i), metaData.getColumnTypeName(i), metaData.isReadOnly(i), false, false));
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeQuietly(resultSet);
            DBUtils.closeQuietly((Statement)statement);
            this.manager.close(connection);
            throw throwable;
        }
        DBUtils.closeQuietly((ResultSet)resultSet);
        DBUtils.closeQuietly((Statement)statement);
        this.manager.close(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String sql, String project) throws SQLException {
        Statement statement = null;
        Connection connection = this.manager.getConnection();
        try {
            statement = connection.createStatement();
            statement.execute(sql);
        }
        finally {
            DBUtils.closeQuietly((Statement)statement);
            this.manager.close(connection);
        }
    }

    private void extractResults(ResultSet resultSet, List<List<String>> results) throws SQLException {
        LinkedList<String> oneRow = new LinkedList<String>();
        while (resultSet.next()) {
            for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                oneRow.add(resultSet.getString(i + 1));
            }
            results.add(new LinkedList(oneRow));
            oneRow.clear();
        }
    }

    public String getName() {
        return "RDBMS";
    }
}

