/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.ZookeeperAutoConfiguration;
import org.springframework.cloud.zookeeper.ZookeeperHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnZookeeperEnabled
@ConditionalOnClass(value={Endpoint.class})
@AutoConfigureAfter(value={ZookeeperAutoConfiguration.class})
public class ZookeeperHealthAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ZookeeperHealthIndicator.class})
    @ConditionalOnBean(value={CuratorFramework.class})
    @ConditionalOnEnabledHealthIndicator(value="zookeeper")
    public ZookeeperHealthIndicator zookeeperHealthIndicator(CuratorFramework curator) {
        return new ZookeeperHealthIndicator(curator);
    }
}

