/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config.initialize;

import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModelUpdateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModelUpdateListener.class);

    @Subscribe
    public void onModelRename(NDataModel.ModelRenameEvent event) {
        String project = event.getProject();
        String modelId = event.getSubject();
        String newName = event.getNewName();
        String buildId = String.format(Locale.ROOT, "%s_%s", modelId, "build");
        String mergeId = String.format(Locale.ROOT, "%s_%s", modelId, "merge");
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            StreamingJobManager streamingJobManager = StreamingJobManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            streamingJobManager.updateStreamingJob(buildId, copyForWrite -> copyForWrite.setModelName(newName));
            streamingJobManager.updateStreamingJob(mergeId, copyForWrite -> copyForWrite.setModelName(newName));
            return null;
        }, (String)project);
    }
}

