/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.statistic;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.materialize.SqlStatisticProvider;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.cache.Cache;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.util.concurrent.UncheckedExecutionException;

public class CachingSqlStatisticProvider
implements SqlStatisticProvider {
    private final SqlStatisticProvider provider;
    private final Cache<List, Object> cache;

    public CachingSqlStatisticProvider(SqlStatisticProvider provider, Cache<List, Object> cache) {
        this.provider = provider;
        this.cache = cache;
    }

    @Override
    public double tableCardinality(RelOptTable table) {
        try {
            ImmutableList key = ImmutableList.of((Object)"tableCardinality", table.getQualifiedName());
            return (Double)this.cache.get((Object)key, () -> this.provider.tableCardinality(table));
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw Util.throwAsRuntime(Util.causeOrSelf(e));
        }
    }

    @Override
    public boolean isForeignKey(RelOptTable fromTable, List<Integer> fromColumns, RelOptTable toTable, List<Integer> toColumns) {
        try {
            ImmutableList key = ImmutableList.of((Object)"isForeignKey", fromTable.getQualifiedName(), (Object)ImmutableIntList.copyOf(fromColumns), toTable.getQualifiedName(), (Object)ImmutableIntList.copyOf(toColumns));
            return (Boolean)this.cache.get((Object)key, () -> this.provider.isForeignKey(fromTable, fromColumns, toTable, toColumns));
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw Util.throwAsRuntime(Util.causeOrSelf(e));
        }
    }

    @Override
    public boolean isKey(RelOptTable table, List<Integer> columns) {
        try {
            ImmutableList key = ImmutableList.of((Object)"isKey", table.getQualifiedName(), (Object)ImmutableIntList.copyOf(columns));
            return (Boolean)this.cache.get((Object)key, () -> this.provider.isKey(table, columns));
        }
        catch (ExecutionException | UncheckedExecutionException e) {
            throw Util.throwAsRuntime(Util.causeOrSelf(e));
        }
    }
}

