/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.rules.ImmutableOLAPJoinPushThroughJoinRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.immutables.value.Value;

@Value.Enclosing
public class OLAPJoinPushThroughJoinRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = Config.DEFAULT.toRule();

    protected OLAPJoinPushThroughJoinRule(Config config) {
        super(config);
    }

    @Deprecated
    public OLAPJoinPushThroughJoinRule(String description, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withDescription(description).withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(joinClass));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        this.onMatchRight(call);
    }

    private void onMatchRight(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        Object relC = call.rel(4);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        RelOptCluster cluster = topJoin.getCluster();
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet bBitSet = ImmutableBitSet.range(aCount, aCount + bCount);
        if (topJoin.getJoinType() == JoinRelType.RIGHT && bottomJoin.getJoinType() == JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> intersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> nonIntersecting = new ArrayList<RexNode>();
        OLAPJoinPushThroughJoinRule.split(topJoin.getCondition(), bBitSet, intersecting, nonIntersecting);
        if (nonIntersecting.isEmpty()) {
            return;
        }
        ArrayList<RexNode> bottomIntersecting = new ArrayList<RexNode>();
        ArrayList<RexNode> bottomNonIntersecting = new ArrayList<RexNode>();
        OLAPJoinPushThroughJoinRule.split(bottomJoin.getCondition(), bBitSet, bottomIntersecting, bottomNonIntersecting);
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList newBottomList = new ArrayList();
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(nonIntersecting, newBottomList);
        new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relA, relC}).visitList(bottomNonIntersecting, newBottomList);
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList, false);
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relA, (RelNode)relC, topJoin.getJoinType(), bottomJoin.isSemiJoinDone());
        Mappings.TargetMapping topMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, 0, aCount, aCount + cCount, aCount, bCount, aCount, aCount + bCount, cCount);
        ArrayList newTopList = new ArrayList();
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(intersecting, newTopList);
        new RexPermuteInputsShuttle(topMapping, newBottomJoin, relB).visitList(bottomIntersecting, newTopList);
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, newTopList, false);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, newBottomJoin, relB, bottomJoin.getJoinType(), topJoin.isSemiJoinDone());
        assert (!Mappings.isIdentity(topMapping));
        RelBuilder relBuilder = call.builder();
        relBuilder.push(newTopJoin);
        relBuilder.project((Iterable<? extends RexNode>)relBuilder.fields(topMapping));
        call.transformTo(relBuilder.build());
    }

    static void split(RexNode condition, ImmutableBitSet bitSet, List<RexNode> intersecting, List<RexNode> nonIntersecting) {
        for (RexNode node : RelOptUtil.conjunctions(condition)) {
            ImmutableBitSet inputBitSet = RelOptUtil.InputFinder.bits(node);
            if (bitSet.intersects(inputBitSet)) {
                intersecting.add(node);
                continue;
            }
            nonIntersecting.add(node);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOLAPJoinPushThroughJoinRule.Config.of().withDescription("OLAPJoinPushThroughJoinRule").withOperandFor(LogicalJoin.class);

        @Override
        default public OLAPJoinPushThroughJoinRule toRule() {
            return new OLAPJoinPushThroughJoinRule(this);
        }

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(joinClass).inputs(b11 -> b11.operand(RelNode.class).anyInputs(), b12 -> b12.operand(RelNode.class).predicate(relNode -> !(relNode instanceof TableScan)).anyInputs()), b2 -> b2.operand(TableScan.class).anyInputs())).as(Config.class);
        }
    }
}

