/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.convert;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConverterRule", generator="Immutables")
final class ImmutableConverterRule {
    private ImmutableConverterRule() {
    }

    @CheckReturnValue
    @Generated(from="ConverterRule.Config", generator="Immutables")
    @Immutable
    static final class Config
    implements ConverterRule.Config {
        private final RelBuilderFactory relBuilderFactory;
        @Nullable
        private final @org.checkerframework.checker.nullness.qual.Nullable String description;
        private final RelRule.OperandTransform operandSupplier;
        private final RelTrait inTrait;
        private final RelTrait outTrait;
        private final Function<ConverterRule.Config, ConverterRule> ruleFactory;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Config(Builder builder) {
            this.description = builder.description;
            this.inTrait = builder.inTrait;
            this.outTrait = builder.outTrait;
            this.ruleFactory = builder.ruleFactory;
            if (builder.relBuilderFactory != null) {
                this.initShim.withRelBuilderFactory(builder.relBuilderFactory);
            }
            if (builder.operandSupplier != null) {
                this.initShim.withOperandSupplier(builder.operandSupplier);
            }
            this.relBuilderFactory = this.initShim.relBuilderFactory();
            this.operandSupplier = this.initShim.operandSupplier();
            this.initShim = null;
        }

        private Config(RelBuilderFactory relBuilderFactory, @Nullable @org.checkerframework.checker.nullness.qual.Nullable String description, RelRule.OperandTransform operandSupplier, RelTrait inTrait, RelTrait outTrait, Function<ConverterRule.Config, ConverterRule> ruleFactory) {
            this.relBuilderFactory = relBuilderFactory;
            this.description = description;
            this.operandSupplier = operandSupplier;
            this.inTrait = inTrait;
            this.outTrait = outTrait;
            this.ruleFactory = ruleFactory;
            this.initShim = null;
        }

        private RelBuilderFactory relBuilderFactoryInitialize() {
            return ConverterRule.Config.super.relBuilderFactory();
        }

        private RelRule.OperandTransform operandSupplierInitialize() {
            return ConverterRule.Config.super.operandSupplier();
        }

        @Override
        public RelBuilderFactory relBuilderFactory() {
            InitShim shim = this.initShim;
            return shim != null ? shim.relBuilderFactory() : this.relBuilderFactory;
        }

        @Override
        @Nullable
        public @org.checkerframework.checker.nullness.qual.Nullable String description() {
            return this.description;
        }

        @Override
        public RelRule.OperandTransform operandSupplier() {
            InitShim shim = this.initShim;
            return shim != null ? shim.operandSupplier() : this.operandSupplier;
        }

        @Override
        public RelTrait inTrait() {
            return this.inTrait;
        }

        @Override
        public RelTrait outTrait() {
            return this.outTrait;
        }

        @Override
        public Function<ConverterRule.Config, ConverterRule> ruleFactory() {
            return this.ruleFactory;
        }

        @Override
        public final Config withRelBuilderFactory(RelBuilderFactory value) {
            if (this.relBuilderFactory == value) {
                return this;
            }
            RelBuilderFactory newValue = Objects.requireNonNull(value, "relBuilderFactory");
            return new Config(newValue, this.description, this.operandSupplier, this.inTrait, this.outTrait, this.ruleFactory);
        }

        @Override
        public final Config withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String value) {
            if (Objects.equals(this.description, value)) {
                return this;
            }
            return new Config(this.relBuilderFactory, value, this.operandSupplier, this.inTrait, this.outTrait, this.ruleFactory);
        }

        @Override
        public final Config withOperandSupplier(RelRule.OperandTransform value) {
            if (this.operandSupplier == value) {
                return this;
            }
            RelRule.OperandTransform newValue = Objects.requireNonNull(value, "operandSupplier");
            return new Config(this.relBuilderFactory, this.description, newValue, this.inTrait, this.outTrait, this.ruleFactory);
        }

        @Override
        public final Config withInTrait(RelTrait value) {
            if (this.inTrait == value) {
                return this;
            }
            RelTrait newValue = Objects.requireNonNull(value, "inTrait");
            return new Config(this.relBuilderFactory, this.description, this.operandSupplier, newValue, this.outTrait, this.ruleFactory);
        }

        @Override
        public final Config withOutTrait(RelTrait value) {
            if (this.outTrait == value) {
                return this;
            }
            RelTrait newValue = Objects.requireNonNull(value, "outTrait");
            return new Config(this.relBuilderFactory, this.description, this.operandSupplier, this.inTrait, newValue, this.ruleFactory);
        }

        @Override
        public final Config withRuleFactory(Function<ConverterRule.Config, ConverterRule> value) {
            if (this.ruleFactory == value) {
                return this;
            }
            Function<ConverterRule.Config, ConverterRule> newValue = Objects.requireNonNull(value, "ruleFactory");
            return new Config(this.relBuilderFactory, this.description, this.operandSupplier, this.inTrait, this.outTrait, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Config && this.equalTo((Config)another);
        }

        private boolean equalTo(Config another) {
            return this.relBuilderFactory.equals(another.relBuilderFactory) && Objects.equals(this.description, another.description) && this.operandSupplier.equals(another.operandSupplier) && this.inTrait.equals(another.inTrait) && this.outTrait.equals(another.outTrait) && this.ruleFactory.equals(another.ruleFactory);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.relBuilderFactory.hashCode();
            h += (h << 5) + Objects.hashCode(this.description);
            h += (h << 5) + this.operandSupplier.hashCode();
            h += (h << 5) + this.inTrait.hashCode();
            h += (h << 5) + this.outTrait.hashCode();
            h += (h << 5) + this.ruleFactory.hashCode();
            return h;
        }

        public String toString() {
            return com.google.common.base.Objects.toStringHelper((String)"Config").omitNullValues().add("relBuilderFactory", (Object)this.relBuilderFactory).add("description", (Object)this.description).add("operandSupplier", (Object)this.operandSupplier).add("inTrait", (Object)this.inTrait).add("outTrait", (Object)this.outTrait).add("ruleFactory", this.ruleFactory).toString();
        }

        public static Config copyOf(ConverterRule.Config instance) {
            if (instance instanceof Config) {
                return (Config)instance;
            }
            return Config.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="ConverterRule.Config", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_IN_TRAIT = 1L;
            private static final long INIT_BIT_OUT_TRAIT = 2L;
            private static final long INIT_BIT_RULE_FACTORY = 4L;
            private long initBits = 7L;
            @Nullable
            private RelBuilderFactory relBuilderFactory;
            @Nullable
            private @org.checkerframework.checker.nullness.qual.Nullable String description;
            @Nullable
            private RelRule.OperandTransform operandSupplier;
            @Nullable
            private RelTrait inTrait;
            @Nullable
            private RelTrait outTrait;
            @Nullable
            private Function<ConverterRule.Config, ConverterRule> ruleFactory;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(RelRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(ConverterRule.Config instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                RelRule.Config instance;
                if (object instanceof RelRule.Config) {
                    instance = (RelRule.Config)object;
                    this.withRelBuilderFactory(instance.relBuilderFactory());
                    this.withOperandSupplier(instance.operandSupplier());
                    @org.checkerframework.checker.nullness.qual.Nullable String descriptionValue = instance.description();
                    if (descriptionValue != null) {
                        this.withDescription(descriptionValue);
                    }
                }
                if (object instanceof ConverterRule.Config) {
                    instance = (ConverterRule.Config)object;
                    this.withInTrait(instance.inTrait());
                    this.withOutTrait(instance.outTrait());
                    this.withRuleFactory(instance.ruleFactory());
                }
            }

            @CanIgnoreReturnValue
            public final Builder withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = Objects.requireNonNull(relBuilderFactory, "relBuilderFactory");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withDescription(@Nullable @org.checkerframework.checker.nullness.qual.Nullable String description) {
                this.description = description;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = Objects.requireNonNull(operandSupplier, "operandSupplier");
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withInTrait(RelTrait inTrait) {
                this.inTrait = Objects.requireNonNull(inTrait, "inTrait");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withOutTrait(RelTrait outTrait) {
                this.outTrait = Objects.requireNonNull(outTrait, "outTrait");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder withRuleFactory(Function<ConverterRule.Config, ConverterRule> ruleFactory) {
                this.ruleFactory = Objects.requireNonNull(ruleFactory, "ruleFactory");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            public Config build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Config(this);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("inTrait");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("outTrait");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("ruleFactory");
                }
                return "Cannot build Config, some of required attributes are not set " + attributes;
            }
        }

        @Generated(from="ConverterRule.Config", generator="Immutables")
        private final class InitShim {
            private byte relBuilderFactoryBuildStage = 0;
            private RelBuilderFactory relBuilderFactory;
            private byte operandSupplierBuildStage = 0;
            private RelRule.OperandTransform operandSupplier;

            private InitShim() {
            }

            RelBuilderFactory relBuilderFactory() {
                if (this.relBuilderFactoryBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.relBuilderFactoryBuildStage == 0) {
                    this.relBuilderFactoryBuildStage = (byte)-1;
                    this.relBuilderFactory = Objects.requireNonNull(Config.this.relBuilderFactoryInitialize(), "relBuilderFactory");
                    this.relBuilderFactoryBuildStage = 1;
                }
                return this.relBuilderFactory;
            }

            void withRelBuilderFactory(RelBuilderFactory relBuilderFactory) {
                this.relBuilderFactory = relBuilderFactory;
                this.relBuilderFactoryBuildStage = 1;
            }

            RelRule.OperandTransform operandSupplier() {
                if (this.operandSupplierBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.operandSupplierBuildStage == 0) {
                    this.operandSupplierBuildStage = (byte)-1;
                    this.operandSupplier = Objects.requireNonNull(Config.this.operandSupplierInitialize(), "operandSupplier");
                    this.operandSupplierBuildStage = 1;
                }
                return this.operandSupplier;
            }

            void withOperandSupplier(RelRule.OperandTransform operandSupplier) {
                this.operandSupplier = operandSupplier;
                this.operandSupplierBuildStage = 1;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.relBuilderFactoryBuildStage == -1) {
                    attributes.add("relBuilderFactory");
                }
                if (this.operandSupplierBuildStage == -1) {
                    attributes.add("operandSupplier");
                }
                return "Cannot build Config, attribute initializers form cycle " + attributes;
            }
        }
    }
}

