/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.annotations.Incubating;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.wrapper.NameValueExpression;
import springfox.documentation.spring.wrapper.PatternsRequestCondition;
import springfox.documentation.spring.wrapper.RequestMappingInfo;

public interface RequestHandler
extends Comparable<RequestHandler> {
    @Deprecated
    public Class<?> declaringClass();

    public boolean isAnnotatedWith(Class<? extends Annotation> var1);

    public PatternsRequestCondition getPatternsCondition();

    public String groupName();

    public String getName();

    public Set<RequestMethod> supportedMethods();

    public Set<MediaType> produces();

    public Set<MediaType> consumes();

    public Set<NameValueExpression<String>> headers();

    public Set<NameValueExpression<String>> params();

    public <T extends Annotation> Optional<T> findAnnotation(Class<T> var1);

    public RequestHandlerKey key();

    public List<ResolvedMethodParameter> getParameters();

    public ResolvedType getReturnType();

    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> var1);

    @Deprecated
    public RequestMappingInfo<?> getRequestMapping();

    @Deprecated
    public HandlerMethod getHandlerMethod();

    @Incubating
    public RequestHandler combine(RequestHandler var1);

    @Override
    default public int compareTo(RequestHandler other) {
        return RequestHandler.byPatternsCondition().thenComparing(RequestHandler.byOperationName()).compare(this, other);
    }

    public static String sortedPaths(PatternsRequestCondition patternsCondition) {
        TreeSet<String> paths = new TreeSet<String>(patternsCondition.getPatterns());
        return paths.stream().filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    public static Comparator<RequestHandler> byPatternsCondition() {
        return Comparator.comparing(requestHandler -> RequestHandler.sortedPaths(requestHandler.getPatternsCondition()));
    }

    public static Comparator<RequestHandler> byOperationName() {
        return Comparator.comparing(RequestHandler::getName);
    }
}

