/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.util.List;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.source.hive.HiveTableMeta;

public class HiveTableMetaBuilder {
    private String tableName;
    private String sdLocation;
    private String sdInputFormat;
    private String sdOutputFormat;
    private String owner;
    private String tableType;
    private int lastAccessTime;
    private long fileSize;
    private long fileNum;
    private int skipHeaderLineCount;
    private boolean isNative = true;
    private List<HiveTableMeta.HiveTableColumnMeta> allColumns = Lists.newArrayList();
    private List<HiveTableMeta.HiveTableColumnMeta> partitionColumns = Lists.newArrayList();

    public HiveTableMetaBuilder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public HiveTableMetaBuilder setSdLocation(String sdLocation) {
        this.sdLocation = sdLocation;
        return this;
    }

    public HiveTableMetaBuilder setSdInputFormat(String sdInputFormat) {
        this.sdInputFormat = sdInputFormat;
        return this;
    }

    public HiveTableMetaBuilder setSdOutputFormat(String sdOutputFormat) {
        this.sdOutputFormat = sdOutputFormat;
        return this;
    }

    public HiveTableMetaBuilder setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public HiveTableMetaBuilder setTableType(String tableType) {
        this.tableType = tableType;
        return this;
    }

    public HiveTableMetaBuilder setLastAccessTime(int lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
        return this;
    }

    public HiveTableMetaBuilder setFileSize(long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public HiveTableMetaBuilder setFileNum(long fileNum) {
        this.fileNum = fileNum;
        return this;
    }

    public HiveTableMetaBuilder setSkipHeaderLineCount(String skipHeaderLineCount) {
        this.skipHeaderLineCount = null == skipHeaderLineCount ? 0 : Integer.parseInt(skipHeaderLineCount);
        return this;
    }

    public HiveTableMetaBuilder setIsNative(boolean isNative) {
        this.isNative = isNative;
        return this;
    }

    public HiveTableMetaBuilder setAllColumns(List<HiveTableMeta.HiveTableColumnMeta> allColumns) {
        this.allColumns = allColumns;
        return this;
    }

    public HiveTableMetaBuilder setPartitionColumns(List<HiveTableMeta.HiveTableColumnMeta> partitionColumns) {
        this.partitionColumns = partitionColumns;
        return this;
    }

    public HiveTableMeta createHiveTableMeta() {
        return new HiveTableMeta(this.tableName, this.sdLocation, this.sdInputFormat, this.sdOutputFormat, this.owner, this.tableType, this.lastAccessTime, this.fileSize, this.fileNum, this.skipHeaderLineCount, this.isNative, this.allColumns, this.partitionColumns);
    }
}

