/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.config.core.processor;

import io.kyligence.config.core.conf.ExternalConfigProperties;
import io.kyligence.config.core.loader.IExternalConfigLoader;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

public class ExternalConfigCustomEnvironmentProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(ExternalConfigCustomEnvironmentProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            ExternalConfigProperties externalConfigProperties = (ExternalConfigProperties)Binder.get((Environment)environment).bind("kylin.external.config", ExternalConfigProperties.class).get();
            for (ExternalConfigProperties.ExternalConfigInfo info : externalConfigProperties.getInfos()) {
                IExternalConfigLoader externalConfig = null;
                String targetClass = info.getTarget();
                Map<String, String> properties = info.getProperties();
                if (!properties.containsKey("activateConfig")) {
                    properties.put("activateConfig", "true");
                }
                if (info.getType().equals("custom")) {
                    Class<?> serviceClass = Class.forName(info.getConfigLoaderClass());
                    externalConfig = (IExternalConfigLoader)serviceClass.getDeclaredConstructor(Map.class).newInstance(properties);
                }
                if (externalConfig == null) continue;
                this.setField(targetClass, externalConfig);
            }
        }
        catch (Exception e) {
            logger.warn("parse failed ", (Throwable)e);
        }
    }

    public int getOrder() {
        return -2147483538;
    }

    private void setField(String clazz, IExternalConfigLoader configLoader) throws ClassNotFoundException {
        Field configLoaderField = ReflectionUtils.findField(Class.forName(clazz), (String)"configLoader");
        configLoaderField.setAccessible(true);
        ReflectionUtils.setField((Field)configLoaderField, null, (Object)configLoader);
    }
}

