/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.planner;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import org.apache.kylin.engine.spark.planner.HLLCountCounter;
import org.apache.kylin.measure.hllc.HLLCounter;

public class TupleCountCounter {
    private final BitSet cuboid;
    private final List<Integer> indexList;
    private final HLLCounter hll;
    private long plainCount;

    public TupleCountCounter(BitSet cuboid, List<Integer> indexList, HLLCounter hll) {
        this.cuboid = cuboid;
        this.indexList = indexList;
        this.hll = hll;
    }

    public BitSet getCuboid() {
        return this.cuboid;
    }

    public List<Integer> indexList() {
        return this.indexList;
    }

    public void accumulate(long hash) {
        this.hll.addHashDirectly(hash);
        ++this.plainCount;
    }

    public byte[] countBytes() throws IOException {
        if (this.indexList == null || this.indexList.isEmpty() || this.cuboid.nextSetBit(0) < 0) {
            return HLLCountCounter.plainBytes(this.plainCount);
        }
        return HLLCountCounter.hllBytes(this.hll);
    }
}

