/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.planner;

import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.apache.kylin.engine.spark.planner.HLLCountCounter;
import org.apache.kylin.engine.spark.planner.HLLCountFlatMapFunc;
import org.apache.kylin.engine.spark.planner.HLLCountReduceFunc2;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class HLLCountEstimator {
    private final Map<BitSet, Long> countMap;

    public HLLCountEstimator(Dataset<Row> flatTable, Map<BitSet, List<Integer>> indexMap) throws IOException {
        this.countMap = this.calculate(flatTable, indexMap);
    }

    public Map<BitSet, Long> countMap() {
        return this.countMap;
    }

    private Map<BitSet, Long> calculate(Dataset<Row> flatTable, Map<BitSet, List<Integer>> indexMap) throws IOException {
        int precision = 14;
        Map bytesMap = flatTable.javaRDD().mapPartitionsToPair((PairFlatMapFunction)new HLLCountFlatMapFunc(14, indexMap)).reduceByKey((Function2)new HLLCountReduceFunc2(14)).collectAsMap();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : bytesMap.entrySet()) {
            builder.put(entry.getKey(), (Object)HLLCountCounter.readCount((byte[])entry.getValue(), 14));
        }
        return builder.build();
    }
}

