/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Objects;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.step.ParamPropagation;
import org.apache.kylin.engine.spark.job.step.ResourceWaitStage;
import org.apache.kylin.engine.spark.job.step.StageExec;
import org.apache.kylin.engine.spark.job.step.build.BuildDict;
import org.apache.kylin.engine.spark.job.step.build.BuildFlatTableStats;
import org.apache.kylin.engine.spark.job.step.build.BuildLayer;
import org.apache.kylin.engine.spark.job.step.build.CostBasedPlanner;
import org.apache.kylin.engine.spark.job.step.build.MaterializeFactView;
import org.apache.kylin.engine.spark.job.step.build.MaterializeFlatTable;
import org.apache.kylin.engine.spark.job.step.build.RefreshColumnBytes;
import org.apache.kylin.engine.spark.job.step.build.RefreshSnapshot;
import org.apache.kylin.engine.spark.job.step.build.partition.PartitionBuildDict;
import org.apache.kylin.engine.spark.job.step.build.partition.PartitionBuildLayer;
import org.apache.kylin.engine.spark.job.step.build.partition.PartitionCostBasedPlanner;
import org.apache.kylin.engine.spark.job.step.build.partition.PartitionGatherFlatTableStats;
import org.apache.kylin.engine.spark.job.step.build.partition.PartitionMaterializeFactView;
import org.apache.kylin.engine.spark.job.step.build.partition.PartitionMaterializeFlatTable;
import org.apache.kylin.engine.spark.job.step.build.partition.PartitionRefreshColumnBytes;
import org.apache.kylin.engine.spark.job.step.merge.MergeColumnBytes;
import org.apache.kylin.engine.spark.job.step.merge.MergeFlatTable;
import org.apache.kylin.engine.spark.job.step.merge.MergeIndices;
import org.apache.kylin.engine.spark.job.step.merge.partition.PartitionMergeColumnBytes;
import org.apache.kylin.engine.spark.job.step.merge.partition.PartitionMergeFlatTable;
import org.apache.kylin.engine.spark.job.step.merge.partition.PartitionMergeIndices;
import org.apache.kylin.job.execution.StageExecutable;
import org.apache.kylin.metadata.cube.model.NDataSegment;

public enum StageEnum {
    WAIT_FOR_RESOURCE{

        @Override
        public StageExec createExec(SparkApplication app) {
            return new ResourceWaitStage(Objects.requireNonNull(app));
        }

        @Override
        public StageExec createExec(SegmentJob job) {
            return new ResourceWaitStage(Objects.requireNonNull(job));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Waiting for yarn resources");
        }
    }
    ,
    REFRESH_SNAPSHOT{

        @Override
        public StageExec createExec(SegmentJob job) {
            return new RefreshSnapshot(Objects.requireNonNull(job));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Build or refresh snapshot");
        }
    }
    ,
    MATERIALIZE_FACT_VIEW{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment, ParamPropagation params) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionMaterializeFactView(job, Objects.requireNonNull(segment), Objects.requireNonNull(params)) : new MaterializeFactView(job, Objects.requireNonNull(segment), Objects.requireNonNull(params));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Materialize fact table view");
        }
    }
    ,
    BUILD_GLOBAL_DICT{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment, ParamPropagation params) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionBuildDict(job, Objects.requireNonNull(segment), Objects.requireNonNull(params)) : new BuildDict(job, Objects.requireNonNull(segment), Objects.requireNonNull(params));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Generate global dictionary");
        }
    }
    ,
    MATERIALIZE_FLAT_TABLE{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment, ParamPropagation params) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionMaterializeFlatTable(job, Objects.requireNonNull(segment), Objects.requireNonNull(params)) : new MaterializeFlatTable(job, Objects.requireNonNull(segment), Objects.requireNonNull(params));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Generate flat table");
        }
    }
    ,
    COST_BASED_PLANNER{

        @Override
        public StageExec createExec(SegmentJob jobContext, NDataSegment dataSegment, ParamPropagation buildParam) {
            if (jobContext.isPartitioned()) {
                return new PartitionCostBasedPlanner(jobContext, dataSegment, buildParam);
            }
            return new CostBasedPlanner(jobContext, dataSegment, buildParam);
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Cost based planner");
        }
    }
    ,
    BUILD_FLAT_TABLE_STATS{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment, ParamPropagation params) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionGatherFlatTableStats(job, Objects.requireNonNull(segment), Objects.requireNonNull(params)) : new BuildFlatTableStats(job, Objects.requireNonNull(segment), Objects.requireNonNull(params));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Get flat table statistics");
        }
    }
    ,
    BUILD_LAYER{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment, ParamPropagation params) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionBuildLayer(job, Objects.requireNonNull(segment), Objects.requireNonNull(params)) : new BuildLayer(job, Objects.requireNonNull(segment), Objects.requireNonNull(params));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Build indexes by layer");
        }
    }
    ,
    REFRESH_COLUMN_BYTES{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment, ParamPropagation params) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionRefreshColumnBytes(job, Objects.requireNonNull(segment), Objects.requireNonNull(params)) : new RefreshColumnBytes(job, Objects.requireNonNull(segment), Objects.requireNonNull(params));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Update flat table statistics");
        }
    }
    ,
    MERGE_FLAT_TABLE{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionMergeFlatTable(job, Objects.requireNonNull(segment)) : new MergeFlatTable(job, Objects.requireNonNull(segment));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Merge flat table");
        }
    }
    ,
    MERGE_INDICES{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionMergeIndices(job, Objects.requireNonNull(segment)) : new MergeIndices(job, Objects.requireNonNull(segment));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Merge indexes");
        }
    }
    ,
    MERGE_COLUMN_BYTES{

        @Override
        public StageExec createExec(SegmentJob job, NDataSegment segment) {
            return Objects.requireNonNull(job).isPartitioned() ? new PartitionMergeColumnBytes(job, Objects.requireNonNull(segment)) : new MergeColumnBytes(job, Objects.requireNonNull(segment));
        }

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Merge flat table statistics");
        }
    }
    ,
    TABLE_SAMPLING{

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Sample Table Data");
        }
    }
    ,
    BUILD_SNAPSHOT{

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Build Snapshot");
        }
    }
    ,
    DELETE_USELESS_LAYOUT_DATA{

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("delete useless layout data");
        }
    }
    ,
    OPTIMIZE_LAYOUT_DATA_BY_REPARTITION{

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Optimize layout data by repartition");
        }
    }
    ,
    OPTIMIZE_LAYOUT_DATA_BY_ZORDER{

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Optimize layout data by zorder");
        }
    }
    ,
    OPTIMIZE_LAYOUT_DATA_BY_COMPACTION{

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Optimize layout data by compaction");
        }
    }
    ,
    INTERNAL_TABLE_LOAD{

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Load Internal Table");
        }
    }
    ,
    OPTIMIZE_INDEX_PLAN{

        @Override
        public StageExecutable createExecutable() {
            return new StageExecutable("Optimize index plan");
        }
    };


    public StageExec createExec(SparkApplication app) {
        throw new UnsupportedOperationException();
    }

    public StageExec createExec(SegmentJob job) {
        throw new UnsupportedOperationException();
    }

    public StageExec createExec(SegmentJob job, NDataSegment segment) {
        throw new UnsupportedOperationException();
    }

    public StageExec createExec(SegmentJob job, NDataSegment segment, ParamPropagation params) {
        throw new UnsupportedOperationException();
    }

    public void createThenExecute(SegmentJob job) {
        this.createExec(job).doExecute();
    }

    public abstract StageExecutable createExecutable();
}

