/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.engine.spark.job.ExecutableAddCuboidHandler;
import org.apache.kylin.engine.spark.job.ExecutableAddSegmentHandler;
import org.apache.kylin.engine.spark.job.ExecutableMergeOrRefreshHandler;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableHandler;

public class ExecutableHandlerFactory {
    public static ExecutableHandler createExecutableHandler(DefaultExecutableOnModel job) {
        List segmentIds = job.getTargetSegments();
        switch (job.getJobType()) {
            case INDEX_BUILD: 
            case SUB_PARTITION_BUILD: {
                return new ExecutableAddCuboidHandler(job);
            }
            case INC_BUILD: {
                Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)segmentIds));
                return new ExecutableAddSegmentHandler(job.getProject(), job.getTargetSubject(), job.getSubmitter(), (String)segmentIds.get(0), job.getId());
            }
            case INDEX_MERGE: 
            case INDEX_REFRESH: 
            case SUB_PARTITION_REFRESH: {
                Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)segmentIds));
                return new ExecutableMergeOrRefreshHandler(job.getProject(), job.getTargetSubject(), job.getSubmitter(), (String)segmentIds.get(0), job.getId());
            }
        }
        throw new IllegalArgumentException("illegal job type");
    }
}

