/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder.v3dict;

import io.delta.exceptions.DeltaConcurrentModificationException;
import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTable$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Paths;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.builder.ZKHelper$;
import org.apache.kylin.engine.spark.builder.v3dict.DictBuildMode$;
import org.apache.kylin.engine.spark.builder.v3dict.DictionaryContext;
import org.apache.kylin.engine.spark.builder.v3dict.GlobalDictionaryPlaceHolder;
import org.apache.kylin.engine.spark.builder.v3dict.PreCountDistinctTransformer;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.dict.NBucketDictionary;
import org.apache.spark.dict.NGlobalDictMetaInfo;
import org.apache.spark.dict.NGlobalDictionaryV2;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkInternalAgent$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import util.retry.blocking.Failure;
import util.retry.blocking.Retry;
import util.retry.blocking.Retry$;
import util.retry.blocking.RetryStrategy;
import util.retry.blocking.RetryStrategy$;
import util.retry.blocking.Success;

public final class DictionaryBuilder$
implements Logging {
    public static DictionaryBuilder$ MODULE$;
    private final Function0<RetryStrategy> retryStrategy;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DictionaryBuilder$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function0<RetryStrategy> retryStrategy() {
        return this.retryStrategy;
    }

    public LogicalPlan buildGlobalDict(String project, SparkSession spark, LogicalPlan plan) {
        return (LogicalPlan)this.transformCountDistinct(spark, plan).transform((PartialFunction)new scala.Serializable(spark, project){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final String project$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof GlobalDictionaryPlaceHolder) {
                    GlobalDictionaryPlaceHolder globalDictionaryPlaceHolder = (GlobalDictionaryPlaceHolder)A1;
                    String expr = globalDictionaryPlaceHolder.exprName();
                    LogicalPlan child = globalDictionaryPlaceHolder.child();
                    String dbName = globalDictionaryPlaceHolder.dbName();
                    if (expr != null) {
                        String string = expr;
                        if (child != null) {
                            LogicalPlan logicalPlan = child;
                            if (dbName != null) {
                                String string2 = dbName;
                                this.spark$1.sparkContext().setJobDescription(new StringBuilder(14).append("Build v3 dict ").append(string).toString());
                                String[] catalog = string.split("_0_DOT_0_");
                                String tableName = catalog[0];
                                String columnName = catalog[1];
                                DictionaryContext context = new DictionaryContext(this.project$1, string2, tableName, columnName, string);
                                Retry retry = Retry$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DictionaryBuilder$.MODULE$.org$apache$kylin$engine$spark$builder$v3dict$DictionaryBuilder$$incrementBuildDict($this.spark$1, logicalPlan, context), DictionaryBuilder$.MODULE$.retryStrategy());
                                if (retry instanceof Success) {
                                    DictionaryBuilder$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Incremental persist global dictionary for: ").append(string).append(" success.").toString());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    this.spark$1.sparkContext().setJobDescription(null);
                                    String dictPath = DictionaryBuilder$.MODULE$.getDictionaryPathAndCheck(context);
                                    LogicalPlan dictPlan = SparkInternalAgent$.MODULE$.getLogicalPlan(this.spark$1.read().format("delta").load(dictPath));
                                    Tuple2 tuple2 = new Tuple2(dictPlan.output().head(), dictPlan.output().apply(1));
                                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                                    Attribute key = (Attribute)tuple2._1();
                                    Attribute value = (Attribute)tuple2._2();
                                    Tuple2 tuple22 = new Tuple2((Object)key, (Object)value);
                                    Tuple2 tuple23 = tuple22;
                                    Attribute key2 = (Attribute)tuple23._1();
                                    Attribute value2 = (Attribute)tuple23._2();
                                    Tuple2 tuple24 = new Tuple2(logicalPlan.output().head(), logicalPlan.output().apply(1));
                                    if (tuple24 == null) throw new MatchError((Object)tuple24);
                                    Attribute existKey = (Attribute)tuple24._1();
                                    Attribute existValue = (Attribute)tuple24._2();
                                    Tuple2 tuple25 = new Tuple2((Object)existKey, (Object)existValue);
                                    Tuple2 tuple26 = tuple25;
                                    Attribute existKey2 = (Attribute)tuple26._1();
                                    Attribute existValue2 = (Attribute)tuple26._2();
                                    Attribute x$1 = key2;
                                    String x$2 = existKey2.name();
                                    ExprId x$3 = existKey2.exprId();
                                    Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                                    Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                                    Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                                    Alias keyAlias = new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
                                    Attribute x$7 = value2;
                                    String x$8 = existValue2.name();
                                    ExprId x$9 = existValue2.exprId();
                                    Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$7, x$8);
                                    Option x$11 = Alias$.MODULE$.apply$default$5((Expression)x$7, x$8);
                                    Seq x$12 = Alias$.MODULE$.apply$default$6((Expression)x$7, x$8);
                                    Alias valueAlias = new Alias((Expression)x$7, x$8, x$9, x$10, x$11, x$12);
                                    object = new Project((Seq)new .colon.colon((Object)keyAlias, (List)new .colon.colon((Object)valueAlias, (List)Nil$.MODULE$)), dictPlan);
                                    return (B1)object;
                                }
                                if (!(retry instanceof Failure)) throw new MatchError((Object)retry);
                                Failure failure = (Failure)retry;
                                Throwable e = failure.exception();
                                throw new KylinRuntimeException(new StringBuilder(52).append("Incremental persist global dictionary for: ").append(string).append(" failure.").toString(), e);
                            }
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (!(logicalPlan instanceof GlobalDictionaryPlaceHolder)) return false;
                GlobalDictionaryPlaceHolder globalDictionaryPlaceHolder = (GlobalDictionaryPlaceHolder)logicalPlan;
                String expr = globalDictionaryPlaceHolder.exprName();
                LogicalPlan child = globalDictionaryPlaceHolder.child();
                String dbName = globalDictionaryPlaceHolder.dbName();
                if (expr == null) return false;
                if (child == null) return false;
                if (dbName == null) return false;
                return true;
            }
            {
                this.spark$1 = spark$1;
                this.project$1 = project$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.kylin.engine.spark.builder.v3dict.DictionaryBuilder$$anonfun$buildGlobalDict$1 org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.kylin.engine.spark.builder.v3dict.DictionaryContext ), $anonfun$applyOrElse$2(java.lang.String )}, serializedLambda);
            }
        });
    }

    private LogicalPlan transformerDictPlan(SparkSession spark, DictionaryContext context, LogicalPlan plan) {
        LogicalPlan logicalPlan;
        Project project;
        LogicalPlan logicalPlan2;
        Project project2;
        LogicalPlan logicalPlan3;
        String dictPath = this.getDictionaryPathAndCheck(context);
        DeltaTable dictTable = DeltaTable$.MODULE$.forPath(dictPath);
        long maxOffset = dictTable.toDF().count();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Dict ").append(dictPath).append(" item count ").append(maxOffset).toString());
        LogicalPlan logicalPlan4 = plan;
        if (logicalPlan4 instanceof Project && (logicalPlan3 = (project2 = (Project)logicalPlan4).child()) instanceof Project && (logicalPlan2 = (project = (Project)logicalPlan3).child()) instanceof Window) {
            Window window = (Window)logicalPlan2;
            LogicalPlan windowChild = window.child();
            String column = context.expr();
            WindowSpec windowSpec = Window$.MODULE$.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(column)}));
            Column joinCondition = SparkInternalAgent$.MODULE$.createColumn((Expression)new EqualTo(functions$.MODULE$.col(column).cast((DataType)StringType$.MODULE$).expr(), (Expression)SparkInternalAgent$.MODULE$.getLogicalPlan(dictTable.toDF()).output().head()));
            String filterKey = ((NamedExpression)SparkInternalAgent$.MODULE$.getLogicalPlan(dictTable.toDF()).output().head()).name();
            Dataset antiJoinDF = SparkInternalAgent$.MODULE$.getDataFrame(spark, windowChild).filter(functions$.MODULE$.col(filterKey).isNotNull()).join(dictTable.toDF(), joinCondition, "left_anti").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(column).cast((DataType)StringType$.MODULE$).as("dict_key"), functions$.MODULE$.row_number().over(windowSpec).$plus((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)maxOffset))).cast((DataType)LongType$.MODULE$).as("dict_value")}));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Dict logical plan : ").append(antiJoinDF.queryExecution().logical().treeString()).toString());
            logicalPlan = SparkInternalAgent$.MODULE$.getLogicalPlan(antiJoinDF);
        } else {
            logicalPlan = plan;
        }
        return logicalPlan;
    }

    private Enumeration.Value chooseDictBuildMode(DictionaryContext context) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return this.isExistsV3Dict(context) ? DictBuildMode$.MODULE$.V3APPEND() : (this.isExistsOriginalV3Dict(context) ? DictBuildMode$.MODULE$.V3UPGRADE() : (config.isConvertV3DictEnable() && this.isExistsV2Dict(context) ? DictBuildMode$.MODULE$.V2UPGRADE() : DictBuildMode$.MODULE$.V3INIT()));
    }

    public void org$apache$kylin$engine$spark$builder$v3dict$DictionaryBuilder$$incrementBuildDict(SparkSession spark, LogicalPlan plan, DictionaryContext context) {
        Enumeration.Value dictMode = this.chooseDictBuildMode(context);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("V3 Dict build mode is ").append(dictMode).toString());
        Enumeration.Value value = dictMode;
        Enumeration.Value value2 = DictBuildMode$.MODULE$.V3INIT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            Dataset dictDF = SparkInternalAgent$.MODULE$.getDataFrame(spark, plan);
            this.initAndSaveDict((Dataset<Row>)dictDF, context);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DictBuildMode$.MODULE$.V3APPEND();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                this.mergeIncrementDict(spark, context, plan);
                this.optimizeDictTable(spark, context);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = DictBuildMode$.MODULE$.V3UPGRADE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    Dataset<Row> v3OrigDict = this.upgradeFromOriginalV3(spark, context);
                    this.initAndSaveDict(v3OrigDict, context);
                    this.mergeIncrementDict(spark, context, plan);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value8 = DictBuildMode$.MODULE$.V2UPGRADE();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        Dataset<Row> v2Dict = this.upgradeFromV2(spark, context);
                        this.initAndSaveDict(v2Dict, context);
                        this.mergeIncrementDict(spark, context, plan);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
        }
        String dictPath = this.getDictionaryPathAndCheck(context);
        DeltaLog dictDeltaLog = DeltaLog$.MODULE$.forTable(spark, dictPath);
        long version = dictDeltaLog.snapshot().version();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Completed the construction of dictionary version ").append(version).append(" for dict ").append(dictPath).toString());
    }

    public void initAndSaveDict(Dataset<Row> dictDF, DictionaryContext context) {
        String dictPath = this.getDictionaryPath(context);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Save dict values into path ").append(dictPath).append(".").toString());
        try {
            dictDF.write().mode(SaveMode.ErrorIfExists).format("delta").save(dictPath);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof DeltaConcurrentModificationException) {
                DeltaConcurrentModificationException deltaConcurrentModificationException = (DeltaConcurrentModificationException)throwable2;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Concurrent modifications occurred: ").append(dictPath).toString(), (Throwable)deltaConcurrentModificationException);
                throw deltaConcurrentModificationException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Object object;
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "A NoFatal exception occurs when initializing the dictionary, and will be retried", e);
                if (!DeltaTable$.MODULE$.isDeltaTable(dictPath)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Try to delete v3dict: ").append(dictPath).toString(), e);
                    object = BoxesRunTime.boxToBoolean((boolean)HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)new Path(dictPath)));
                } else {
                    object = BoxedUnit.UNIT;
                }
                throw e;
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw throwable3;
            }
            throw throwable;
        }
    }

    private void mergeIncrementDict(SparkSession spark, DictionaryContext context, LogicalPlan plan) {
        ZKHelper$.MODULE$.tryZKJaasConfiguration(spark);
        Lock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().getLockForCurrentThread(this.getDictionaryLockPath(context));
        lock.lock();
        try {
            LogicalPlan dictPlan = this.transformerDictPlan(spark, context, plan);
            Dataset incrementDictDF = SparkInternalAgent$.MODULE$.getDataFrame(spark, dictPlan);
            String dictPath = this.getDictionaryPathAndCheck(context);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Increment build global dict ").append(dictPath).toString());
            DeltaTable dictTable = DeltaTable$.MODULE$.forPath(dictPath);
            dictTable.alias("dict").merge(incrementDictDF.alias("incre_dict"), "1 != 1").whenNotMatched().insertAll().execute();
        }
        finally {
            lock.unlock();
        }
    }

    private void optimizeDictTable(SparkSession spark, DictionaryContext context) {
        KylinConfig config;
        long v3DictFileNumLimit;
        String dictPath = this.getDictionaryPathAndCheck(context);
        DeltaLog deltaLog = DeltaLog$.MODULE$.forTable(spark, dictPath);
        long numFile = deltaLog.snapshot().numOfFiles();
        if (numFile > (v3DictFileNumLimit = (config = KylinConfig.getInstanceFromEnv()).getV3DictFileNumLimit())) {
            long optimizeStartTime = System.nanoTime();
            DeltaTable dictTable = DeltaTable$.MODULE$.forPath(dictPath);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(83).append("Optimize the storage of dict ").append(dictPath).append(", ").append("dict file num: ").append(numFile).append(", ").append("spark.build.v3dict-file-num-limit: ").append(v3DictFileNumLimit).toString());
            dictTable.optimize().executeCompaction();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Clean up dict ").append(dictPath).append(" files via delta vacuum").toString());
            long v3DictRetention = config.getV3DictFileRetentionHours();
            dictTable.vacuum((double)v3DictRetention);
            long optimizeTaken = (System.nanoTime() - optimizeStartTime) / 1000L / 1000L;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("It took ").append(optimizeTaken).append("ms to optimize dict ").append(dictPath).toString());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("No need to optimize dict: ").append(dictPath).append(", dict file num: ").append(numFile).toString());
        }
    }

    private boolean isExistsV2Dict(DictionaryContext context) {
        boolean bl;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NGlobalDictionaryV2 globalDict = new NGlobalDictionaryV2(context.project(), new StringBuilder(1).append(context.dbName()).append(".").append(context.tableName()).toString(), context.columnName(), config.getHdfsWorkingDirectory());
        NGlobalDictMetaInfo dictV2Meta = globalDict.getMetaInfo();
        if (dictV2Meta != null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Exists V2 dict ").append(globalDict.getResourceDir()).toString());
            bl = true;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Not exists V2 dict ").append(globalDict.getResourceDir()).toString());
            bl = false;
        }
        return bl;
    }

    private boolean isExistsV3Dict(DictionaryContext context) {
        String dictPath = this.getDictionaryPath(context);
        return DeltaTable$.MODULE$.isDeltaTable(dictPath);
    }

    private boolean isExistsOriginalV3Dict(DictionaryContext context) {
        String dictPath = this.getOriginalDictionaryPath(context);
        return DeltaTable$.MODULE$.isDeltaTable(dictPath);
    }

    private Dataset<Row> fetchExistsOriginalV3Dict(DictionaryContext context) {
        String originalV3DictPath = this.getOriginalDictionaryPath(context);
        DeltaTable v3dictTable = DeltaTable$.MODULE$.forPath(originalV3DictPath);
        return v3dictTable.toDF();
    }

    private LogicalPlan transformCountDistinct(SparkSession session, LogicalPlan plan) {
        PreCountDistinctTransformer transformer = new PreCountDistinctTransformer(session);
        return transformer.apply(plan);
    }

    private Dataset<Row> upgradeFromV2(SparkSession spark, DictionaryContext context) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NGlobalDictionaryV2 globalDict = new NGlobalDictionaryV2(context.project(), new StringBuilder(1).append(context.dbName()).append(".").append(context.tableName()).toString(), context.columnName(), config.getHdfsWorkingDirectory());
        NGlobalDictMetaInfo dictV2Meta = globalDict.getMetaInfo();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Exists V2 dict ").append(globalDict.getResourceDir()).append(" num ").append(dictV2Meta.getDictCount()).toString());
        Broadcast broadcastDict = spark.sparkContext().broadcast((Object)globalDict, ClassTag$.MODULE$.apply(NGlobalDictionaryV2.class));
        StructType dictSchema = new StructType((StructField[])((Object[])new StructField[]{new StructField("dict_key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dict_value", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        return dictV2Meta != null ? spark.createDataset((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), dictV2Meta.getBucketSize()), spark.implicits().newIntEncoder()).flatMap((Function1 & Serializable & scala.Serializable)bucketId -> DictionaryBuilder$.$anonfun$upgradeFromV2$2(broadcastDict, BoxesRunTime.unboxToInt((Object)bucketId)), (Encoder)RowEncoder$.MODULE$.apply(dictSchema)) : spark.emptyDataset((Encoder)RowEncoder$.MODULE$.apply(dictSchema));
    }

    private Dataset<Row> upgradeFromOriginalV3(SparkSession spark, DictionaryContext context) {
        return this.isExistsOriginalV3Dict(context) ? this.fetchExistsOriginalV3Dict(context) : spark.emptyDataFrame();
    }

    private String getOriginalDictionaryPath(DictionaryContext context) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String workingDir = config.getHdfsWorkingDirectory();
        Path dictDir = new Path(context.project(), new Path("/dict/global_dict_v3", new Path(new Path(context.tableName()), context.columnName())));
        return new StringBuilder(0).append(workingDir).append(dictDir).toString();
    }

    public String getDictionaryPath(DictionaryContext context) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String workingDir = config.getHdfsWorkingDirectory();
        java.nio.file.Path dictDir = Paths.get(context.project(), "/dict/global_dict_v3", context.dbName(), context.tableName(), context.columnName());
        return new StringBuilder(0).append(workingDir).append(dictDir).toString();
    }

    /*
     * WARNING - void declaration
     */
    public String getDictionaryPathAndCheck(DictionaryContext context) {
        void var2_2;
        String v3ditPath = this.getDictionaryPath(context);
        if (!DeltaTable$.MODULE$.isDeltaTable(v3ditPath)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("This v3dict path: {").append(v3ditPath).append("} is not a delta table.").toString());
            throw new KylinRuntimeException(new StringBuilder(42).append("This v3dict path: {").append(v3ditPath).append("} is not a delta table.").toString());
        }
        return var2_2;
    }

    public String getDictionaryLockPath(DictionaryContext context) {
        java.nio.file.Path dictPath = Paths.get(context.project(), "/dict/global_dict_v3", context.dbName(), context.tableName(), context.columnName());
        return ((Object)dictPath).toString();
    }

    public String wrapCol(TblColRef ref) {
        return NSparkCubingUtil.convertFromDot((String)ref.getBackTickIdentity());
    }

    public static final /* synthetic */ Iterator $anonfun$upgradeFromV2$2(Broadcast broadcastDict$1, int bucketId) {
        NGlobalDictionaryV2 gDict = (NGlobalDictionaryV2)broadcastDict$1.value();
        NBucketDictionary bucketDict = gDict.loadBucketDictionary(bucketId);
        ListBuffer tupleList = new ListBuffer();
        bucketDict.getAbsoluteDictMap().object2LongEntrySet().forEach(dictTuple -> tupleList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.fromTuple((Product)new Tuple2(dictTuple.getKey(), (Object)BoxesRunTime.boxToLong((long)dictTuple.getLongValue())))})));
        return tupleList.iterator();
    }

    private DictionaryBuilder$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.retryStrategy = RetryStrategy$.MODULE$.randomBackOff(new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds(), new package.DurationInt(package$.MODULE$.DurationInt(15)).seconds(), 20);
    }
}

