/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import io.delta.tables.ClickhouseTable$;
import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTable$;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.utils.SparkDataSource$;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTablePartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameWriter;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.catalog.ClickHouseTableV2;
import org.apache.spark.sql.delta.catalog.ClickHouseTableV2$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u000e\u001d\u0001%BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004F\u0001\u0001\u0006I!\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u0001=\u0011\u00199\u0005\u0001)A\u0005{!9\u0001\n\u0001b\u0001\n\u0003a\u0004BB%\u0001A\u0003%Q\bC\u0004K\u0001\t\u0007I\u0011\u0001\u001f\t\r-\u0003\u0001\u0015!\u0003>\u0011\u001da\u0005A1A\u0005\u0002qBa!\u0014\u0001!\u0002\u0013i\u0004b\u0002(\u0001\u0005\u0004%\t\u0001\u0010\u0005\u0007\u001f\u0002\u0001\u000b\u0011B\u001f\t\u000fA\u0003!\u0019!C\u0001y!1\u0011\u000b\u0001Q\u0001\nuBaA\u0015\u0001!B\u0013\u0019\u0006\"\u0002,\u0001\t\u00139\u0006\"\u0002,\u0001\t\u0003A\u0006\"\u00020\u0001\t\u0003y\u0006bBA,\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003o\u0002A\u0011AA=\u0011%\ty\tAI\u0001\n\u0003\t\t\nC\u0004\u0002(\u0002!\t!!+\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\"9\u00111\u001a\u0001\u0005\n\u00055\u0007\"CAt\u0001E\u0005I\u0011BAu\u0005MIe\u000e^3s]\u0006dG+\u00192mK2{\u0017\rZ3s\u0015\tib$A\u0004ck&dG-\u001a:\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011#\u0003\u0019)gnZ5oK*\u00111\u0005J\u0001\u0006Wfd\u0017N\u001c\u0006\u0003K\u0019\na!\u00199bG\",'\"A\u0014\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0003cUj\u0011A\r\u0006\u0003gQ\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003?\u0011J!A\u000e\u001a\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011\u0001H\u0001\u000e\u0005V\u001b5*\u0012+`\u0007>cU+\u0014(\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\t1\fgn\u001a\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uH\u0001\u0004TiJLgnZ\u0001\u000f\u0005V\u001b5*\u0012+`\u0007>cU+\u0014(!\u0003)\u0011UkQ&F)~sU+T\u0001\f\u0005V\u001b5*\u0012+`\u001dVk\u0005%A\u0006Q%&k\u0015IU-`\u0017\u0016K\u0016\u0001\u0004)S\u00136\u000b%+W0L\u000bf\u0003\u0013\u0001D(S\t\u0016\u0013vLQ-`\u0017\u0016K\u0016!D(S\t\u0016\u0013vLQ-`\u0017\u0016K\u0006%\u0001\bT)>\u0013\u0016iR#`!>c\u0015jQ-\u0002\u001fM#vJU!H\u000b~\u0003v\nT%D3\u0002\n\u0011b\u0014,F%^\u0013\u0016\nV#\u0002\u0015=3VIU,S\u0013R+\u0005%\u0001\u0004B!B+e\nR\u0001\b\u0003B\u0003VI\u0014#!\u0003=yvN\u001c7z\u0019>\fGmU2iK6\f\u0007CA\u0016U\u0013\t)FFA\u0004C_>dW-\u00198\u0002\u001d=tG.\u001f'pC\u0012\u001c6\r[3nCV\t1\u000b\u0006\u0002Z9B\u00111FW\u0005\u000372\u0012A!\u00168ji\")QL\u0005a\u0001'\u0006)a/\u00197vK\u0006\tBn\\1e\u0013:$XM\u001d8bYR\u000b'\r\\3\u0015\u0015e\u0003\u0007.]A\u0001\u0003\u000b\tI\u0001C\u0003b'\u0001\u0007!-\u0001\u0002tgB\u00111MZ\u0007\u0002I*\u0011Q\rN\u0001\u0004gFd\u0017BA4e\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u0015I7\u00031\u0001k\u0003\u0015!\u0018M\u00197f!\tYw.D\u0001m\u0015\tIWN\u0003\u0002oE\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002qY\n\t\u0012J\u001c;fe:\fG\u000eV1cY\u0016$Um]2\t\u000bI\u001c\u0002\u0019A:\u0002\u000bI\fgnZ3\u0011\u0007-\"h/\u0003\u0002vY\t)\u0011I\u001d:bsB\u0011qO \b\u0003qr\u0004\"!\u001f\u0017\u000e\u0003iT!a\u001f\u0015\u0002\rq\u0012xn\u001c;?\u0013\tiH&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t~T!! \u0017\t\r\u0005\r1\u00031\u0001t\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0005\u0007\u0003\u000f\u0019\u0002\u0019\u0001<\u0002\u001bM$xN]1hKB{G.[2z\u0011\u0019\tYa\u0005a\u0001'\u0006Y\u0011N\\2sK6,g\u000e^1mQ\u0015\u0019\u0012qBA\u0011!\u0015Y\u0013\u0011CA\u000b\u0013\r\t\u0019\u0002\f\u0002\u0007i\"\u0014xn^:\u0011\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007B\u0003\tIw.\u0003\u0003\u0002 \u0005e!aC%P\u000bb\u001cW\r\u001d;j_:\fdA\b<\u0002$\u0005U\u0013'C\u0012\u0002&\u00055\u00121JA\u0018+\u0011\t9#!\u000b\u0016\u0003Y$q!a\u000b)\u0005\u0004\t)DA\u0001U\u0013\u0011\ty#!\r\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\r\t\u0019\u0004L\u0001\u0007i\"\u0014xn^:\u0012\t\u0005]\u0012Q\b\t\u0004W\u0005e\u0012bAA\u001eY\t9aj\u001c;iS:<\u0007\u0003BA \u0003\u000br1aKA!\u0013\r\t\u0019\u0005L\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9%!\u0013\u0003\u0013QC'o\\<bE2,'bAA\"YEJ1%!\u0014\u0002P\u0005E\u00131\u0007\b\u0004W\u0005=\u0013bAA\u001aYE*!e\u000b\u0017\u0002T\t)1oY1mCF\u001aa%!\u0006\u0002\u001b\u001d,GoU8ve\u000e,G)\u0019;b)9\tY&a\u001a\u0002j\u0005-\u0014qNA:\u0003k\u0002RaYA/\u0003CJ1!a\u0018e\u0005\u001d!\u0015\r^1tKR\u00042aYA2\u0013\r\t)\u0007\u001a\u0002\u0004%><\b\"B1\u0015\u0001\u0004\u0011\u0007\"B5\u0015\u0001\u0004Q\u0007BBA7)\u0001\u0007a/A\u0005ti\u0006\u0014H\u000fR1uK\"1\u0011\u0011\u000f\u000bA\u0002Y\fq!\u001a8e\t\u0006$X\r\u0003\u0004\u0002\u0004Q\u0001\ra\u001d\u0005\u0007\u0003\u0017!\u0002\u0019A*\u00021Q\u0014XO\\2bi\u0016$\u0015\r^1J]\u001aKG.Z*zgR,W\u000eF\u0003Z\u0003w\nY\tC\u0004\u0002~U\u0001\r!a \u0002\u00131|7-\u0019;j_:\u001c\b#BAA\u0003\u000f3XBAAB\u0015\r\t))Q\u0001\u0005kRLG.\u0003\u0003\u0002\n\u0006\r%!C!se\u0006LH*[:u\u0011!\ti)\u0006I\u0001\u0002\u0004\u0019\u0016aF5t\u0013:$XM\u001d8bYR\u000b'\r\\3S_>$\b+\u0019;i\u0003\t\"(/\u001e8dCR,G)\u0019;b\u0013:4\u0015\u000e\\3TsN$X-\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0013\u0016\u0004'\u0006U5FAAL!\u0011\tI*a)\u000e\u0005\u0005m%\u0002BAO\u0003?\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005F&\u0001\u0006b]:|G/\u0019;j_:LA!!*\u0002\u001c\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002#\u001d,G\u000fU1si&$\u0018n\u001c8J]\u001a|7\u000f\u0006\u0004\u0002,\u00065\u0016q\u0016\t\u0005WQ\f\t\u0007C\u0003b/\u0001\u0007!\r\u0003\u0004\u00022^\u0001\rA[\u0001\u000eS:$XM\u001d8bYR\u000b'\r\\3\u0002\u001d\u0011\u0014x\u000e\u001d)beRLG/[8ogR9\u0011,a.\u0002:\u0006m\u0006\"B1\u0019\u0001\u0004\u0011\u0007BBAY1\u0001\u0007!\u000e\u0003\u0004\u0002>b\u0001\rA^\u0001\u0010a\u0006\u0014H/\u001b;j_:4\u0016\r\\;fg\"*\u0001$a\u0004\u0002BF2aD^Ab\u0003\u0013\f\u0014bIA\u0013\u0003[\t)-a\f2\u0013\r\ni%a\u0014\u0002H\u0006M\u0012'\u0002\u0012,Y\u0005M\u0013g\u0001\u0014\u0002\u0016\u0005\u0019B-\u001a7fi\u0016$U\r\u001c;b\u001b\u0016$\u0018\rR1uCR)\u0011,a4\u0002d\"1\u0011.\u0007a\u0001\u0003#\u0004B!a5\u0002`6\u0011\u0011Q\u001b\u0006\u0005\u0003/\fI.\u0001\u0004uC\ndWm\u001d\u0006\u0005\u00037\fi.A\u0003eK2$\u0018M\u0003\u0002\u0002\u001c%!\u0011\u0011]Ak\u0005)!U\r\u001c;b)\u0006\u0014G.\u001a\u0005\t\u0003KL\u0002\u0013!a\u0001m\u0006I\u0001/\u0019:uSRLwN\\\u0001\u001eI\u0016dW\r^3EK2$\u0018-T3uC\u0012\u000bG/\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u001e\u0016\u0004m\u0006U\u0005")
public class InternalTableLoader
implements Logging {
    private final String BUCKET_COLUMN;
    private final String BUCKET_NUM;
    private final String PRIMARY_KEY;
    private final String ORDER_BY_KEY;
    private final String STORAGE_POLICY;
    private final String OVERWRITE;
    private final String APPEND;
    private boolean _onlyLoadSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String BUCKET_COLUMN() {
        return this.BUCKET_COLUMN;
    }

    public String BUCKET_NUM() {
        return this.BUCKET_NUM;
    }

    public String PRIMARY_KEY() {
        return this.PRIMARY_KEY;
    }

    public String ORDER_BY_KEY() {
        return this.ORDER_BY_KEY;
    }

    public String STORAGE_POLICY() {
        return this.STORAGE_POLICY;
    }

    public String OVERWRITE() {
        return this.OVERWRITE;
    }

    public String APPEND() {
        return this.APPEND;
    }

    private boolean onlyLoadSchema() {
        return this._onlyLoadSchema;
    }

    public void onlyLoadSchema(boolean value) {
        this._onlyLoadSchema = value;
    }

    public void loadInternalTable(SparkSession ss, InternalTableDesc table, String[] range, String[] partitions, String storagePolicy, boolean incremental) throws IOException {
        String startDate = range[0];
        String endDate = range[1];
        String location = table.generateInternalTableLocation();
        Dataset sourceData = this.getSourceData(ss, table, startDate, endDate, partitions, incremental);
        InternalTablePartition tablePartition = table.getTablePartition();
        String bucketColumn = table.getBucketColumn();
        int bucketNum = table.getBucketNumber();
        String primaryKey = (String)table.getTblProperties().get("primaryKey");
        String orderByKey = (String)table.getTblProperties().get("orderByKey");
        String outPutMode = this.OVERWRITE();
        if (tablePartition != null && table.isSortByPartitionEnabled()) {
            String[] partitionColumn = tablePartition.getPartitionColumns();
            sourceData = sourceData.sort(partitionColumn[0], (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionColumn)).slice(1, partitionColumn.length)));
        }
        DataFrameWriter writer = sourceData.write().option(this.STORAGE_POLICY(), storagePolicy);
        if (tablePartition != null) {
            String[] partitionColumn = tablePartition.getPartitionColumns();
            writer = writer.partitionBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])partitionColumn));
        }
        if (bucketColumn != null) {
            if (bucketNum <= 0) {
                throw new KylinException((ErrorCodeSupplier)CommonErrorCode.INTERNAL_TABLE_INVALID_BUCKET_NUMBER, "Invalid bucket number");
            }
            writer = writer.option(this.BUCKET_COLUMN(), bucketColumn).option(this.BUCKET_NUM(), (long)bucketNum);
        }
        if (primaryKey != null) {
            writer = writer.option(this.PRIMARY_KEY(), primaryKey).option(this.ORDER_BY_KEY(), orderByKey);
        } else if (orderByKey != null) {
            writer = writer.option(this.ORDER_BY_KEY(), orderByKey);
        }
        String format = table.getStorageType().getFormat();
        if (incremental) {
            String dateFormat = table.getTablePartition().getDatePartitionFormat();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                String arg$macro$1 = DateFormat.formatToDateStr((long)new StringOps(Predef$.MODULE$.augmentString(startDate)).toLong(), (String)dateFormat);
                String arg$macro$2 = DateFormat.formatToDateStr((long)new StringOps(Predef$.MODULE$.augmentString(endDate)).toLong(), (String)dateFormat);
                return new java.lang.StringBuilder(0).append(new StringOps("Refresh dynamic partitions [%s,").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}))).append(new StringOps(" %s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2}))).toString();
            });
            ss.conf().set("spark.sql.sources.partitionOverwriteMode", "dynamic");
        }
        writer.format(format).mode(outPutMode).save(location);
    }

    public Dataset<Row> getSourceData(SparkSession ss, InternalTableDesc table, String startDate, String endDate, String[] partitions, boolean incremental) {
        Dataset dataset;
        Dataset tableDS;
        Dataset dataset2 = tableDS = this.onlyLoadSchema() ? SparkDataSource$.MODULE$.SparkSource(ss).table(table.getTableDesc()).limit(0) : SparkDataSource$.MODULE$.SparkSource(ss).table(table.getTableDesc());
        if (partitions != null && partitions.length > 0) {
            dataset = tableDS.filter(tableDS.col(table.getTablePartition().getPartitionColumns()[0]).isin((Seq)Predef$.MODULE$.genericWrapArray((Object)partitions)));
        } else if (incremental) {
            String partitionColumn = table.getTablePartition().getPartitionColumns()[0];
            String dateFormat = table.getTablePartition().getDatePartitionFormat();
            String condition = InternalTablePartition.DefaultPartitionConditionBuilder.buildDateRangeCondition((String)partitionColumn, (String)dateFormat, (String)startDate, (String)endDate);
            dataset = tableDS.where(condition);
        } else {
            dataset = tableDS;
        }
        return dataset;
    }

    public void truncateDataInFileSystem(ArrayList<String> locations, boolean isInternalTableRootPath) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        locations.forEach(location -> {
            block5: {
                try {
                    Path filePath = new Path(location);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(17).append("Trying to delete ").append(filePath).toString());
                    if (fs.exists(filePath)) {
                        if (!isInternalTableRootPath) {
                            fs.delete(filePath, true);
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(9).append("Deleted: ").append(filePath).toString());
                        } else {
                            FileStatus[] statuses = fs.listStatus(filePath);
                            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).foreach((Function1 & Serializable & scala.Serializable)status -> {
                                InternalTableLoader.$anonfun$truncateDataInFileSystem$4(this, fs, status);
                                return BoxedUnit.UNIT;
                            });
                        }
                        break block5;
                    }
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(24).append(filePath).append(" does not exist, skip it").toString());
                }
                catch (IOException e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> {
                        String arg$macro$1 = location;
                        return new StringOps("Failed to delete internal table on %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}));
                    }, e);
                }
            }
        });
    }

    public boolean truncateDataInFileSystem$default$2() {
        return true;
    }

    public Row[] getPartitionInfos(SparkSession ss, InternalTableDesc internalTable) {
        InternalTableDesc.StorageType storageType = internalTable.getStorageType();
        Dataset dataset = InternalTableDesc.StorageType.GLUTEN.equals(storageType) ? new ClickHouseTableV2(ss, new Path(internalTable.getLocation()), ClickHouseTableV2$.MODULE$.$lessinit$greater$default$3(), ClickHouseTableV2$.MODULE$.$lessinit$greater$default$4(), ClickHouseTableV2$.MODULE$.$lessinit$greater$default$5(), ClickHouseTableV2$.MODULE$.$lessinit$greater$default$6(), ClickHouseTableV2$.MODULE$.$lessinit$greater$default$7(), ClickHouseTableV2$.MODULE$.$lessinit$greater$default$8()).snapshot().allFiles() : (InternalTableDesc.StorageType.DELTALAKE.equals(storageType) ? DeltaLog$.MODULE$.forTable(ss, internalTable.getLocation()).unsafeVolatileSnapshot().allFiles() : null);
        Dataset addFiles = dataset;
        if (addFiles == null) {
            return (Row[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Row.class));
        }
        String partitionCol = internalTable.getTablePartition().getPartitionColumns()[0].toUpperCase(Locale.ROOT);
        Dataset partitionInfos = addFiles.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)InternalTableLoader.$anonfun$getPartitionInfos$1(partitionCol, x$1))).map((Function1 & Serializable & scala.Serializable)addFile -> new Tuple2(addFile.partitionValues().apply((Object)partitionCol), (Object)BoxesRunTime.boxToLong((long)addFile.size())), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringLongEncoder());
        Dataset groupedPartitionInfo = partitionInfos.groupBy("_1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.sum("_2").alias("totalSize"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count("_2").alias("fileCount")}));
        return (Row[])groupedPartitionInfo.collect();
    }

    public void dropPartitions(SparkSession ss, InternalTableDesc internalTable, String partitionValues) throws IOException {
        block2: {
            DeltaTable sparkTable;
            block1: {
                InternalTableDesc.StorageType storageType = internalTable.getStorageType();
                Object object = InternalTableDesc.StorageType.GLUTEN.equals(storageType) ? ClickhouseTable$.MODULE$.forPath(ss, internalTable.generateInternalTableLocation()) : (InternalTableDesc.StorageType.DELTALAKE.equals(storageType) ? DeltaTable$.MODULE$.forPath(ss, internalTable.generateInternalTableLocation()) : null);
                sparkTable = object;
                if (!StringUtils.isEmpty((CharSequence)partitionValues)) break block1;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(35).append("Dropping all partitions for table: ").append(internalTable).toString());
                this.deleteDeltaMetaData(sparkTable, this.deleteDeltaMetaData$default$2());
                ArrayList<String> locations = new ArrayList<String>();
                locations.add(internalTable.getLocation());
                this.truncateDataInFileSystem(locations, this.truncateDataInFileSystem$default$2());
                break block2;
            }
            String partitionCol = internalTable.getTablePartition().getPartitionColumns()[0];
            ArrayList<String> toDeletedPaths = new ArrayList<String>();
            String[] values = partitionValues.split(",");
            StringBuilder deleteStatementBuilder = package$.MODULE$.StringBuilder().newBuilder();
            ArrayList toDeletedPartitionValues = new ArrayList();
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])values)).foreach((Function1 & Serializable & scala.Serializable)partitionValue -> BoxesRunTime.boxToBoolean((boolean)InternalTableLoader.$anonfun$dropPartitions$2(deleteStatementBuilder, partitionCol, internalTable, toDeletedPaths, toDeletedPartitionValues, partitionValue)));
            if (!toDeletedPartitionValues.isEmpty()) {
                String partitionCondition = StringUtils.join(toDeletedPartitionValues, (String)" or ");
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(54).append("Dropping partitions for table: ").append(internalTable).append(", partition condition: ").append(partitionCondition).toString());
                this.deleteDeltaMetaData(sparkTable, partitionCondition);
            }
            if (toDeletedPaths.isEmpty()) break block2;
            this.truncateDataInFileSystem(toDeletedPaths, false);
        }
    }

    private void deleteDeltaMetaData(DeltaTable table, String partition) {
        block2: {
            if (table == null) break block2;
            if (partition != null) {
                table.delete(partition);
            } else {
                table.delete();
            }
        }
    }

    private String deleteDeltaMetaData$default$2() {
        return null;
    }

    public static final /* synthetic */ void $anonfun$truncateDataInFileSystem$4(InternalTableLoader $this, FileSystem fs$1, FileStatus status) {
        block0: {
            if (status.getPath().getName().equals("_delta_log") && status.getPath().getName().startsWith("_")) break block0;
            fs$1.delete(status.getPath(), true);
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(9).append("Deleted: ").append(status.getPath()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionInfos$1(String partitionCol$1, AddFile x$1) {
        return x$1.partitionValues().contains((Object)partitionCol$1);
    }

    public static final /* synthetic */ boolean $anonfun$dropPartitions$2(StringBuilder deleteStatementBuilder$1, String partitionCol$2, InternalTableDesc internalTable$1, ArrayList toDeletedPaths$1, ArrayList toDeletedPartitionValues$1, String partitionValue) {
        deleteStatementBuilder$1.clear();
        deleteStatementBuilder$1.append(partitionCol$2).append(" = ").append(new java.lang.StringBuilder(2).append("'").append(partitionValue).append("'").toString());
        String subPath = new java.lang.StringBuilder(1).append(partitionCol$2.toUpperCase(Locale.ROOT)).append("=").append(partitionValue).toString();
        String pathName = new Path(internalTable$1.getLocation(), subPath).toString();
        toDeletedPaths$1.add(pathName);
        return toDeletedPartitionValues$1.add(deleteStatementBuilder$1.toString());
    }

    public InternalTableLoader() {
        Logging.$init$((Logging)this);
        this.BUCKET_COLUMN = "clickhouse.bucketColumnNames";
        this.BUCKET_NUM = "clickhouse.numBuckets";
        this.PRIMARY_KEY = "clickhouse.primaryKey";
        this.ORDER_BY_KEY = "clickhouse.orderByKey";
        this.STORAGE_POLICY = "clickhouse.storage_policy";
        this.OVERWRITE = "overwrite";
        this.APPEND = "append";
        this._onlyLoadSchema = false;
    }
}

