/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.gluten.substrait.expression.ExpressionNode;

public class SelectionNode
implements ExpressionNode,
Serializable {
    private final Integer fieldIndex;
    private final List<Integer> nestedChildIndices = new ArrayList<Integer>();

    SelectionNode(Integer fieldIndex) {
        this.fieldIndex = fieldIndex;
    }

    SelectionNode(Integer fieldIndex, Integer childIndex) {
        this.fieldIndex = fieldIndex;
        this.nestedChildIndices.add(childIndex);
    }

    public SelectionNode addNestedChildIdx(Integer childIndex) {
        this.nestedChildIndices.add(childIndex);
        return this;
    }

    public Expression.ReferenceSegment createRef(Integer childIdx, Expression.ReferenceSegment childRef) {
        Expression.ReferenceSegment.StructField.Builder structBuilder = Expression.ReferenceSegment.StructField.newBuilder();
        structBuilder.setField(childIdx);
        if (childRef != null) {
            structBuilder.setChild(childRef);
        }
        Expression.ReferenceSegment.Builder refBuilder = Expression.ReferenceSegment.newBuilder();
        refBuilder.setStructField(structBuilder.build());
        return refBuilder.build();
    }

    @Override
    public Expression toProtobuf() {
        Expression.ReferenceSegment.StructField.Builder structBuilder = Expression.ReferenceSegment.StructField.newBuilder();
        structBuilder.setField(this.fieldIndex);
        if (!this.nestedChildIndices.isEmpty()) {
            Expression.ReferenceSegment childRef = null;
            for (int i = this.nestedChildIndices.size() - 1; i >= 0; --i) {
                childRef = this.createRef(this.nestedChildIndices.get(i), childRef);
            }
            structBuilder.setChild(childRef);
        }
        Expression.ReferenceSegment.Builder refBuilder = Expression.ReferenceSegment.newBuilder();
        refBuilder.setStructField(structBuilder.build());
        Expression.FieldReference.Builder fieldBuilder = Expression.FieldReference.newBuilder();
        fieldBuilder.setDirectReference(refBuilder.build());
        Expression.Builder builder = Expression.newBuilder();
        builder.setSelection(fieldBuilder.build());
        return builder.build();
    }
}

