/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.expression;

import io.substrait.proto.Expression;
import io.substrait.proto.Type;
import org.apache.gluten.substrait.expression.ExpressionBuilder;
import org.apache.gluten.substrait.expression.LiteralNode;
import org.apache.gluten.substrait.expression.LiteralNodeWithValue;
import org.apache.gluten.substrait.type.MapNode;
import org.apache.gluten.substrait.type.TypeNode;
import org.apache.spark.sql.catalyst.util.MapData;

public class MapLiteralNode
extends LiteralNodeWithValue<MapData> {
    public MapLiteralNode(MapData map, TypeNode typeNode) {
        super(map, typeNode);
    }

    @Override
    protected void updateLiteralBuilder(Expression.Literal.Builder literalBuilder, MapData map) {
        Object[] keys = map.keyArray().array();
        Object[] values = map.valueArray().array();
        TypeNode mapType = ((MapNode)this.getTypeNode()).getKeyType();
        TypeNode valueType = ((MapNode)this.getTypeNode()).getValueType();
        if (keys.length > 0) {
            Expression.Literal.Map.Builder mapBuilder = Expression.Literal.Map.newBuilder();
            for (int i = 0; i < keys.length; ++i) {
                LiteralNode keyNode = ExpressionBuilder.makeLiteral(keys[i], mapType);
                LiteralNode valueNode = ExpressionBuilder.makeLiteral(values[i], valueType);
                Expression.Literal.Map.KeyValue.Builder kvBuilder = Expression.Literal.Map.KeyValue.newBuilder();
                kvBuilder.setKey(keyNode.getLiteral());
                kvBuilder.setValue(valueNode.getLiteral());
                mapBuilder.addKeyValues(kvBuilder.build());
            }
            literalBuilder.setMap(mapBuilder.build());
        } else {
            Type.Map.Builder mapTypeBuilder = Type.Map.newBuilder();
            mapTypeBuilder.setKey(mapType.toProtobuf());
            mapTypeBuilder.setValue(valueType.toProtobuf());
            literalBuilder.setEmptyMap(mapTypeBuilder.build());
        }
    }
}

