/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.Random;
import org.apache.kylin.common.util.StringBuilderHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringBuilderHelperTest {
    @Test
    public void testHead() {
        StringBuilderHelper helper = StringBuilderHelper.head((int)4);
        helper.append((CharSequence)"abc");
        Assertions.assertEquals((Object)"abc", (Object)helper.toString());
        helper.append('d');
        Assertions.assertEquals((Object)"abcd", (Object)helper.toString());
        helper = StringBuilderHelper.head((int)4);
        helper.append((CharSequence)"abcd");
        Assertions.assertEquals((Object)"abcd", (Object)helper.toString());
        helper.append('e');
        Assertions.assertEquals((Object)"abcd", (Object)helper.toString());
        helper.append((CharSequence)"fg");
        Assertions.assertEquals((Object)"abcd", (Object)helper.toString());
    }

    @Test
    public void testTail() {
        StringBuilderHelper helper = StringBuilderHelper.tail((int)4);
        helper.append((CharSequence)"abc");
        Assertions.assertEquals((Object)"abc", (Object)helper.toString());
        helper.append('d');
        Assertions.assertEquals((Object)"abcd", (Object)helper.toString());
        helper.append('e');
        Assertions.assertEquals((Object)"bcde", (Object)helper.toString());
        helper.append((CharSequence)"fg");
        Assertions.assertEquals((Object)"defg", (Object)helper.toString());
    }

    @Test
    public void testHeadAndTail() {
        StringBuilderHelper helper1 = StringBuilderHelper.headTail((int)3, (int)2);
        helper1.append((CharSequence)"abc");
        Assertions.assertEquals((Object)"abc", (Object)helper1.toString());
        helper1.append('d');
        Assertions.assertEquals((Object)"abcd", (Object)helper1.toString());
        helper1.append('e');
        Assertions.assertEquals((Object)"abcde", (Object)helper1.toString());
        helper1.append((CharSequence)"fg");
        Assertions.assertEquals((Object)"abcfg", (Object)helper1.toString());
        helper1.append('h');
        Assertions.assertEquals((Object)"abcgh", (Object)helper1.toString());
    }

    @Test
    public void testHeadAndTailWithLargeSize() {
        this.testWithLength(3000, 3000, 10000, 0, 1, "TEST HEAD", "TEST TAIL");
        this.testWithLength(3000, 3000, 10000, 10, 100, "TEST HEAD", "TEST TAIL");
        this.testWithLength(3000, 3000, 10000, 10, 1034, "TEST HEAD", "TEST TAIL");
        this.testWithLength(3000, 3000, 10000, 1024, 1034, "TEST HEAD", "TEST TAIL");
        this.testWithLength(3000, 3000, 1500, 0, 1, "TEST HEAD", "TEST TAIL");
        this.testWithLength(3000, 3000, 1500, 10, 100, "TEST HEAD", "TEST TAIL");
        this.testWithLength(3000, 3000, 1500, 10, 1034, "TEST HEAD", "TEST TAIL");
        this.testWithLength(3000, 3000, 1500, 1024, 1034, "TEST HEAD", "TEST TAIL");
    }

    private void testWithLength(int headSize, int tailSize, int appendTotal, int strMinLengthExclusive, int strMaxLength, String head, String tail) {
        String str;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilderHelper helper1 = StringBuilderHelper.headTail((int)headSize, (int)tailSize);
        helper1.append((CharSequence)head);
        stringBuilder.append(head);
        Assertions.assertEquals((Object)head, (Object)helper1.toString());
        int totalSize = headSize + tailSize;
        Random random = new Random();
        for (int appended = 0; appended < appendTotal; appended += str.length()) {
            int length = Math.min(random.nextInt(strMaxLength - strMinLengthExclusive + 1) + strMinLengthExclusive, appendTotal - appended);
            str = random.ints(97, 123).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            if (str.length() == 1) {
                helper1.append(str.charAt(0));
            } else {
                helper1.append((CharSequence)str);
            }
            stringBuilder.append(str);
        }
        helper1.append((CharSequence)tail);
        stringBuilder.append(tail);
        String string = stringBuilder.toString();
        if (string.length() > totalSize) {
            string = string.substring(0, headSize) + string.substring(string.length() - tailSize);
        }
        Assertions.assertEquals((Object)string, (Object)helper1.toString());
    }
}

