/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RandomUtilTest {
    @Test
    void testRandomUUID() {
        Assertions.assertEquals((int)RandomUtil.randomUUID().toString().length(), (int)UUID.randomUUID().toString().length());
        Assertions.assertNotEquals((Object)RandomUtil.randomUUID().toString(), (Object)RandomUtil.randomUUID().toString());
    }

    @Test
    void testRandomUUIDStr() {
        Assertions.assertEquals((int)RandomUtil.randomUUIDStr().length(), (int)UUID.randomUUID().toString().length());
        Assertions.assertNotEquals((Object)RandomUtil.randomUUIDStr(), (Object)RandomUtil.randomUUIDStr());
    }

    @Test
    void nextInt() {
        this.testNextInt(0, 999);
        this.testNextInt(0, 99);
        this.testNextInt(0, 9);
        this.testNextInt(0, 0);
        this.testNextInt(9, 9);
        this.testNextInt(99, 99);
        this.testNextInt(99, 999);
    }

    private void testNextInt(int startInclusive, int endExclusive) {
        for (int i = 0; i < 100; ++i) {
            int randomInt = RandomUtil.nextInt((int)startInclusive, (int)endExclusive);
            Assertions.assertTrue((randomInt >= startInclusive ? 1 : 0) != 0);
            if (startInclusive == endExclusive) {
                Assertions.assertEquals((int)startInclusive, (int)randomInt);
                continue;
            }
            Assertions.assertTrue((randomInt < endExclusive ? 1 : 0) != 0);
        }
    }

    @Test
    void nextIntMultithreading() throws Exception {
        RandomUtilTest.concurrentTest(10L, 30);
    }

    public static void concurrentTest(long concurrentThreads, int times) throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool((int)concurrentThreads);
        ArrayList results = Lists.newArrayList();
        int i = 1;
        while (i < times) {
            int finalI = i++;
            Callable<Integer> callable1 = () -> RandomUtil.nextInt((int)(100 * finalI), (int)(200 * finalI));
            Callable<Integer> callable2 = () -> RandomUtil.nextInt((int)(200000 * finalI), (int)(300000 * finalI));
            results.add(executor.submit(callable1));
            results.add(executor.submit(callable2));
        }
        executor.shutdown();
        for (i = 0; i < times - 1; ++i) {
            Integer result1 = (Integer)((Future)results.get(2 * i)).get();
            Assertions.assertTrue((result1 < 200 * (i + 1) ? 1 : 0) != 0);
            Assertions.assertTrue((result1 >= 100 * (i + 1) ? 1 : 0) != 0);
            Integer result2 = (Integer)((Future)results.get(2 * i + 1)).get();
            Assertions.assertTrue((result2 < 300000 * (i + 1) ? 1 : 0) != 0);
            Assertions.assertTrue((result2 >= 200000 * (i + 1) ? 1 : 0) != 0);
        }
    }
}

