/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTool {
    private static String[] includes = null;
    private static String[] excludes = null;
    private static final Logger logger = LoggerFactory.getLogger(ResourceTool.class);
    private static final Set<String> IMMUTABLE_PREFIX = Sets.newHashSet((Object[])new String[]{ResourceStore.METASTORE_UUID_TAG});

    public static String[] getIncludes() {
        return includes;
    }

    public static void addIncludes(String[] arg) {
        if (arg != null) {
            if (includes != null) {
                String[] nIncludes = new String[includes.length + arg.length];
                System.arraycopy(includes, 0, nIncludes, 0, includes.length);
                System.arraycopy(arg, 0, nIncludes, includes.length, arg.length);
                includes = nIncludes;
            } else {
                includes = arg;
            }
        }
    }

    public static String[] getExcludes() {
        return excludes;
    }

    public static void addExcludes(String[] arg) {
        if (arg != null) {
            if (excludes != null) {
                String[] nExcludes = new String[excludes.length + arg.length];
                System.arraycopy(excludes, 0, nExcludes, 0, excludes.length);
                System.arraycopy(arg, 0, nExcludes, excludes.length, arg.length);
                excludes = nExcludes;
            } else {
                excludes = arg;
            }
        }
    }

    public static String cat(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)config);
        RawResource resource = store.getResource(path);
        StringBuilder sb = new StringBuilder();
        try (InputStream is = resource.getByteSource().openStream();
             BufferedReader br = new BufferedReader(new InputStreamReader(is, Charset.defaultCharset()));){
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    public static NavigableSet<String> list(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)config);
        NavigableSet result = store.listResources(path);
        System.out.println("" + result);
        return result;
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, String type) throws IOException {
        ResourceTool.copy(srcConfig, dstConfig, type, false);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, String type, boolean copyImmutableResource) throws IOException {
        ResourceStore src = ResourceStore.getKylinMetaStore((KylinConfig)srcConfig);
        ResourceStore dst = ResourceStore.getKylinMetaStore((KylinConfig)dstConfig);
        logger.info("Copy from {} to {}", (Object)src, (Object)dst);
        ResourceTool.copyR(src, dst, type, copyImmutableResource);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, List<String> paths) throws IOException {
        ResourceTool.copy(srcConfig, dstConfig, paths, false);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, List<String> paths, boolean copyImmutableResource) throws IOException {
        ResourceStore src = ResourceStore.getKylinMetaStore((KylinConfig)srcConfig);
        ResourceStore dst = ResourceStore.getKylinMetaStore((KylinConfig)dstConfig);
        logger.info("Copy from {} to {}", (Object)src, (Object)dst);
        for (String path : paths) {
            ResourceTool.copyR(src, dst, path, copyImmutableResource);
        }
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig) throws IOException {
        ResourceTool.copy(srcConfig, dstConfig, false);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, boolean copyImmutableResource) throws IOException {
        ResourceTool.copy(srcConfig, dstConfig, MetadataType.ALL.name(), copyImmutableResource);
    }

    public static void copyR(ResourceStore src, ResourceStore dst, String path, boolean copyImmutableResource) {
        block6: {
            block5: {
                if (!copyImmutableResource && IMMUTABLE_PREFIX.contains(path)) {
                    return;
                }
                if (!MetadataType.ALL_TYPE_STR.contains(path)) break block5;
                NavigableSet children = src.listResources(path);
                for (String child : children) {
                    ResourceTool.copyR(src, dst, child, copyImmutableResource);
                }
                break block6;
            }
            if (!ResourceTool.matchFilter(path)) break block6;
            try {
                RawResource res = src.getResource(path);
                if (res != null) {
                    dst.getMetadataStore().save(res.getMetaType(), res);
                }
                System.out.println("Resource not exist for " + path);
            }
            catch (Exception ex) {
                System.err.println("Failed to open " + path);
                logger.error(ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }

    private static boolean matchFilter(String path) {
        if (includes != null) {
            boolean in = false;
            String[] stringArray = includes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String include = stringArray[i];
                in = in || path.startsWith(include);
            }
            if (!in) {
                return false;
            }
        }
        if (excludes != null) {
            for (String exclude : excludes) {
                if (!path.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    public static void reset(KylinConfig config) {
        ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)config);
        ResourceTool.resetR(store, MetadataType.ALL.name());
    }

    public static void resetR(ResourceStore store, String type) {
        NavigableSet children = store.listResourcesRecursively(type);
        for (String child : children) {
            if (!ResourceTool.matchFilter(child)) continue;
            store.deleteResource(child);
        }
    }

    private static void remove(KylinConfig config, String path) {
        ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)config);
        ResourceTool.resetR(store, path);
    }
}

