/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.fallback;

import io.github.resilience4j.fallback.FallbackDecorator;
import io.github.resilience4j.fallback.FallbackMethod;
import io.github.resilience4j.utils.AspectUtil;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.Set;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorFallbackDecorator
implements FallbackDecorator {
    private static final Set<Class<?>> REACTORS_SUPPORTED_TYPES = AspectUtil.newHashSet(Mono.class, Flux.class);

    @Override
    public boolean supports(Class<?> target) {
        return REACTORS_SUPPORTED_TYPES.stream().anyMatch(it -> it.isAssignableFrom(target));
    }

    @Override
    public CheckedFunction0<Object> decorate(FallbackMethod fallbackMethod, CheckedFunction0<Object> supplier) {
        return supplier.andThen((CheckedFunction1 & Serializable)returnValue -> {
            if (Flux.class.isAssignableFrom(returnValue.getClass())) {
                Flux fluxReturnValue = (Flux)returnValue;
                return fluxReturnValue.onErrorResume(this.reactorOnErrorResume(fallbackMethod, Flux::error));
            }
            if (Mono.class.isAssignableFrom(returnValue.getClass())) {
                Mono monoReturnValue = (Mono)returnValue;
                return monoReturnValue.onErrorResume(this.reactorOnErrorResume(fallbackMethod, Mono::error));
            }
            return returnValue;
        });
    }

    private <T> Function<? super Throwable, ? extends Publisher<? extends T>> reactorOnErrorResume(FallbackMethod fallbackMethod, Function<? super Throwable, ? extends Publisher<? extends T>> errorFunction) {
        return throwable -> {
            try {
                return (Publisher)fallbackMethod.fallback((Throwable)throwable);
            }
            catch (Throwable fallbackThrowable) {
                return (Publisher)errorFunction.apply(fallbackThrowable);
            }
        };
    }
}

