/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.schema;

import java.util.Optional;
import javax.validation.constraints.NotBlank;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
@Order(value=-2147483148)
public class NotBlankAnnotationPlugin
implements ModelPropertyBuilderPlugin {
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    public void apply(ModelPropertyContext context) {
        Optional<NotBlank> notBlank = this.extractAnnotation(context);
        if (notBlank.isPresent()) {
            context.getBuilder().required(Boolean.valueOf(true));
            context.getSpecificationBuilder().required(Boolean.valueOf(true));
        }
    }

    private Optional<NotBlank> extractAnnotation(ModelPropertyContext context) {
        return Validators.annotationFromBean(context, NotBlank.class).map(Optional::of).orElse(Validators.annotationFromField(context, NotBlank.class));
    }
}

