/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.kylin.engine.spark.utils.Repartitioner;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RepartitionerTest {
    @Test
    public void testNeedRepartitionForFileSize() {
        ContentSummary sc = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)sc.getFileCount()).thenReturn((Object)2L);
        Mockito.when((Object)sc.getLength()).thenReturn((Object)0x100000L);
        Repartitioner helper = new Repartitioner(2, 1, false, 0x8000000L, 10000L, 1000L, 1000L, sc, null, null, true);
        Assert.assertTrue((boolean)helper.needRepartitionForFileSize());
        Assert.assertFalse((boolean)helper.needRepartitionForShardByColumns());
        Assert.assertTrue((boolean)helper.needRepartition());
    }

    @Test
    public void testNeedRepartitionForFileSize_only1File() {
        ContentSummary sc = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)sc.getFileCount()).thenReturn((Object)1L);
        Mockito.when((Object)sc.getLength()).thenReturn((Object)524288L);
        Repartitioner helper = new Repartitioner(2, 1, false, 0x8000000L, 10000L, 1000L, 1000L, sc, null, null, true);
        Assert.assertFalse((boolean)helper.needRepartitionForFileSize());
        Assert.assertFalse((boolean)helper.needRepartitionForShardByColumns());
        Assert.assertFalse((boolean)helper.needRepartition());
    }

    @Test
    public void testNeedRepartitionForShardByColumns() {
        ArrayList shardByColumns = Lists.newArrayList((Object[])new Integer[]{1});
        ContentSummary sc = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)sc.getFileCount()).thenReturn((Object)2L);
        Mockito.when((Object)sc.getLength()).thenReturn((Object)0x300000L);
        Repartitioner helper = new Repartitioner(2, 1, false, 0x8000000L, 10000L, 1000L, 1000L, sc, (List)shardByColumns, null, true);
        Assert.assertTrue((boolean)helper.needRepartitionForShardByColumns());
        Assert.assertFalse((boolean)helper.needRepartitionForFileSize());
        Assert.assertTrue((boolean)helper.needRepartition());
    }

    @Test
    public void testGetRepartitionNum() {
        ContentSummary sc = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)sc.getFileCount()).thenReturn((Object)6L);
        Mockito.when((Object)sc.getLength()).thenReturn((Object)0x400000L);
        Repartitioner helper = new Repartitioner(2, 1, false, 0x8000000L, 10000L, 1000L, 1000L, sc, null, null, true);
        Assert.assertEquals((long)2L, (long)helper.getRepartitionNumByStorage());
    }

    @Test
    public void testRowCountNum() {
        ContentSummary sc = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)sc.getFileCount()).thenReturn((Object)6L);
        Mockito.when((Object)sc.getLength()).thenReturn((Object)0x400000L);
        Repartitioner helper = new Repartitioner(2, 1, false, 0x8000000L, 10000L, 2000L, 500L, sc, null, null, true);
        Assert.assertEquals((long)3L, (long)helper.getRepartitionNumByStorage());
    }

    @Test
    public void testRepartitionNumEqualsCurrentPartitionNum() {
        ContentSummary sc = (ContentSummary)Mockito.mock(ContentSummary.class);
        Mockito.when((Object)sc.getFileCount()).thenReturn((Object)3L);
        Mockito.when((Object)sc.getLength()).thenReturn((Object)0x400000L);
        Repartitioner helper = new Repartitioner(2, 2, false, 0x8000000L, 10000L, 1500L, 500L, sc, null, null, true);
        Assert.assertFalse((boolean)helper.needRepartition());
    }
}

