/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.base.Strings;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.request.DDLRequest;
import org.apache.kylin.rest.response.DDLResponse;
import org.apache.kylin.rest.response.ExportTablesResponse;
import org.apache.kylin.rest.response.TableNameResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.DDLDesc;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.DdlOperation;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.delta.DeltaTableUtils;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.List;

@Service
public class SparkSourceService
extends BasicService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparkSourceService.class);
    private static final String CHAR_VARCHAR_TYPE_STRING = "__CHAR_VARCHAR_TYPE_STRING";
    private static final String HIVE_COMMENT = "comment";
    private static final String TABLE_LINEORDER = "ssb.lineorder";
    private static final String VIEW_P_LINEORDER = "ssb.p_lineorder";
    private static final String CREATE_VIEW_P_LINEORDER = "create view if not exists SSB.P_LINEORDER as\n        select LO_ORDERKEY,\n        LO_LINENUMBER,\n        LO_CUSTKEY,\n        LO_PARTKEY,\n        LO_SUPPKEY,\n        LO_ORDERDATE,\n        LO_ORDERPRIOTITY,\n        LO_SHIPPRIOTITY,\n        LO_QUANTITY,\n        LO_EXTENDEDPRICE,\n        LO_ORDTOTALPRICE,\n        LO_DISCOUNT,\n        LO_REVENUE,\n        LO_SUPPLYCOST,\n        LO_TAX,\n        LO_COMMITDATE,\n        LO_SHIPMODE,\n        LO_EXTENDEDPRICE*LO_DISCOUNT as V_REVENUE\n        from SSB.LINEORDER";

    public DDLResponse executeSQL(DDLRequest request) {
        java.util.List<String> sqlList = Arrays.asList(request.getSql().split(";"));
        if (!Strings.isNullOrEmpty((String)request.getDatabase())) {
            this.executeSQL("use " + request.getDatabase());
        }
        DDLResponse ddlResponse = new DDLResponse();
        HashMap succeed = Maps.newHashMap();
        HashMap failed = Maps.newHashMap();
        sqlList.forEach(s -> {
            if (!Strings.isNullOrEmpty((String)s)) {
                try {
                    DDLDesc ddlDesc = this.executeSQL((String)s);
                    succeed.put(s, ddlDesc);
                }
                catch (Exception e) {
                    log.error("Failed to execute sql[{}]", s, (Object)e);
                    failed.put(s, e.getMessage());
                }
            }
        });
        ddlResponse.setSucceed((Map)succeed);
        ddlResponse.setFailed((Map)failed);
        return ddlResponse;
    }

    public DDLDesc executeSQL(String sql) {
        return DdlOperation.executeSQL((String)sql);
    }

    public void dropTable(String database, String table) throws AnalysisException {
        SparkSession ss = SparderEnv.getSparkSession();
        if (ss.catalog().tableExists(database, table)) {
            Table t = ss.catalog().getTable(database, table);
            if ("view".equalsIgnoreCase(t.tableType())) {
                ss.sql(String.format(Locale.ROOT, "drop view %s.%s", database, table));
            } else {
                ss.sql(String.format(Locale.ROOT, "drop table %s.%s", database, table));
            }
        }
    }

    public java.util.List<String> listDatabase() {
        SparkSession sparkSession = SparderEnv.getSparkSession();
        Dataset databaseSet = sparkSession.catalog().listDatabases();
        java.util.List databases = databaseSet.collectAsList();
        return databases.stream().map(database -> database.name().toUpperCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public java.util.List<TableNameResponse> listTables(String db, String project) throws Exception {
        if (Strings.isNullOrEmpty((String)project)) {
            SparkSession sparkSession = SparderEnv.getSparkSession();
            Dataset tableDataset = sparkSession.catalog().listTables(db);
            java.util.List sparkTables = tableDataset.collectAsList();
            return sparkTables.stream().map(table -> new TableNameResponse(table.name().toUpperCase(Locale.ROOT), false)).collect(Collectors.toList());
        }
        ISourceMetadataExplorer explr = SourceFactory.getSource((ISourceAware)((NProjectManager)this.getManager(NProjectManager.class)).getProject(project)).getSourceMetadataExplorer();
        java.util.List<String> tables = explr.listTables(db).stream().map(str -> str.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
        ArrayList tableNameResponses = Lists.newArrayList();
        tables.forEach(table -> {
            TableNameResponse response = new TableNameResponse();
            response.setLoaded(((NTableMetadataManager)this.getManager(NTableMetadataManager.class, project)).getTableDesc(db + "." + table) != null);
            response.setTableName(table);
            tableNameResponses.add(response);
        });
        return tableNameResponses;
    }

    public java.util.List<ColumnModel> listColumns(String db, String table) {
        SparkSession sparkSession = SparderEnv.getSparkSession();
        CatalogTable catalogTable = sparkSession.sessionState().catalog().getTempViewOrPermanentTableMetadata(new TableIdentifier(table, Option.apply((Object)db)));
        List structFieldList = catalogTable.schema().toList();
        if (DeltaTableUtils.isDeltaTable((CatalogTable)catalogTable)) {
            structFieldList = sparkSession.table(catalogTable.identifier()).schema().toList();
        }
        Iterator structFieldIterator = structFieldList.iterator();
        ArrayList columnModels = Lists.newArrayList();
        while (structFieldIterator.hasNext()) {
            StructField structField = (StructField)structFieldIterator.next();
            String name = structField.name();
            String datatype = structField.dataType().simpleString();
            Metadata metadata = structField.metadata();
            ColumnModel columnModel = new ColumnModel();
            if (catalogTable.partitionColumnNames().contains((Object)name)) {
                columnModel.setPartition(true);
            }
            columnModel.setName(name);
            columnModel.setDescription(metadata.contains(HIVE_COMMENT) ? metadata.getString(HIVE_COMMENT) : "");
            columnModel.setDataType(metadata.contains(CHAR_VARCHAR_TYPE_STRING) ? metadata.getString(CHAR_VARCHAR_TYPE_STRING) : datatype);
            columnModels.add(columnModel);
        }
        return columnModels;
    }

    public String getTableDesc(String database, String table) {
        return DdlOperation.getTableDesc((String)database, (String)table);
    }

    public ExportTablesResponse exportTables(String database, String[] tables) {
        if (database == null || database.equals("")) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getEmptyDatabase());
        }
        if (tables.length == 0) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getEmptyTableList());
        }
        if (!this.databaseExists(database)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getDatabaseNotExist(), database));
        }
        ExportTablesResponse tableResponse = new ExportTablesResponse();
        HashMap tableDesc = Maps.newHashMap();
        for (String table : tables) {
            if (table.equals("")) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getEmptyTableList());
            }
            if (!this.tableExists(database, table)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getTableNotFound(), table));
            }
            tableDesc.put(table, DdlOperation.getTableDesc((String)database, (String)table).replaceAll("\t|\r|\n", " "));
        }
        tableResponse.setDatabase(database);
        tableResponse.setTables((Map)tableDesc);
        return tableResponse;
    }

    public boolean databaseExists(String database) {
        SparkSession sparkSession = SparderEnv.getSparkSession();
        return sparkSession.catalog().databaseExists(database);
    }

    public boolean tableExists(String database, String table) {
        SparkSession sparkSession = SparderEnv.getSparkSession();
        return sparkSession.catalog().tableExists(database, table);
    }

    public boolean hasPartition(String database, String table) {
        return DdlOperation.hasPartition((String)database, (String)table);
    }

    public java.util.List<String> msck(String database, String table) {
        return DdlOperation.msck((String)database, (String)table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.util.List<String> loadSamples(SparkSession ss, SaveMode mode) throws IOException, InterruptedException {
        Lock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().getLockForCurrentThread("samples");
        java.util.List<File> fileList = this.listSampleFiles();
        ArrayList createdTables = Lists.newArrayList();
        lock.tryLock(60L, TimeUnit.SECONDS);
        try {
            for (File file : fileList) {
                String fileName;
                String table;
                if (!file.isDirectory()) continue;
                String tableName = table = (fileName = file.getName());
                String db = "DEFAULT";
                if (fileName.contains(".")) {
                    String[] splits = fileName.split("\\.");
                    db = splits[0];
                    tableName = splits[1];
                    if (!ss.catalog().databaseExists(db)) {
                        ss.sql("create database if not exists " + db);
                    }
                } else {
                    table = String.format(Locale.ROOT, "%s.%s", db, table);
                }
                if (!ss.catalog().tableExists(table)) {
                    this.loadSamples(ss, mode, table, tableName, db, file, fileName);
                }
                createdTables.add(table);
            }
            if (ss.catalog().tableExists(TABLE_LINEORDER)) {
                ss.sql(CREATE_VIEW_P_LINEORDER);
                createdTables.add(VIEW_P_LINEORDER);
            }
            log.info("Load samples {} successfully", (Object)StringHelper.join((Iterable)createdTables, (String)","));
        }
        finally {
            lock.unlock();
        }
        return createdTables;
    }

    private void loadSamples(SparkSession ss, SaveMode mode, String table, String tableName, String db, File file, String fileName) throws IOException {
        String filePath = file.getAbsolutePath();
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        String hdfsPath = String.format(Locale.ROOT, "/tmp/%s", fileName);
        try {
            Path path;
            log.debug("Copy from {} to {}", (Object)filePath, (Object)hdfsPath);
            File[] parquetFiles = file.listFiles();
            if (parquetFiles != null) {
                for (File parquetFile : parquetFiles) {
                    fileSystem.copyFromLocalFile(new Path(parquetFile.getAbsolutePath()), new Path(hdfsPath));
                }
            }
            String tbLocation = String.format(Locale.ROOT, "%s/%s", ss.catalog().getDatabase(db).locationUri(), tableName);
            FileSystem fs = FileSystem.get((Configuration)ss.sparkContext().hadoopConfiguration());
            if (fs.exists(path = new Path(tbLocation))) {
                log.debug("Delete existed table location {}", (Object)path.toString());
                fs.delete(path, true);
            }
            ss.read().parquet(hdfsPath).write().mode(mode).saveAsTable(table);
        }
        catch (Exception e) {
            log.error("Load sample {} failed.", (Object)fileName, (Object)e);
            throw new IllegalStateException(String.format(Locale.ROOT, "Load sample %s failed", fileName), e);
        }
        finally {
            fileSystem.delete(new Path(hdfsPath), false);
        }
    }

    public java.util.List<String> loadSamples() throws IOException, InterruptedException {
        log.info("Start to load samples");
        SparkSession ss = SparderEnv.getSparkSession();
        return this.loadSamples(ss, SaveMode.Overwrite);
    }

    private java.util.List<File> listSampleFiles() {
        String sampleDir = "../samples";
        if (KylinConfig.getInstanceFromEnv().isUTEnv()) {
            sampleDir = "../../build/samples";
        }
        File file = new File(sampleDir);
        log.debug("Samples file path is {}", (Object)file.getAbsolutePath());
        File[] listFiles = file.listFiles();
        if (!file.exists() || null == listFiles) {
            throw new RuntimeException("No sample data found.");
        }
        return Arrays.asList(listFiles);
    }

    public static class ColumnModel {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="partition")
        private boolean partition;

        @Generated
        public ColumnModel() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getDataType() {
            return this.dataType;
        }

        @Generated
        public boolean isPartition() {
            return this.partition;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Generated
        public void setPartition(boolean partition) {
            this.partition = partition;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnModel)) {
                return false;
            }
            ColumnModel other = (ColumnModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$dataType = this.getDataType();
            String other$dataType = other.getDataType();
            if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
                return false;
            }
            return this.isPartition() == other.isPartition();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColumnModel;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $dataType = this.getDataType();
            result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
            result = result * 59 + (this.isPartition() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "SparkSourceService.ColumnModel(name=" + this.getName() + ", description=" + this.getDescription() + ", dataType=" + this.getDataType() + ", partition=" + this.isPartition() + ")";
        }
    }
}

