/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.clickhouse.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.StringValue;
import io.substrait.proto.NamedStruct;
import io.substrait.proto.Plan;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.gluten.backendsapi.clickhouse.CHBackendSettings$;
import org.apache.gluten.backendsapi.clickhouse.CHConf$;
import org.apache.gluten.execution.GlutenMergeTreePartition;
import org.apache.gluten.execution.MergeTreePartRange;
import org.apache.gluten.execution.MergeTreePartSplit;
import org.apache.gluten.expression.ConverterUtils$;
import org.apache.gluten.expression.ExpressionConverter$;
import org.apache.gluten.softaffinity.SoftAffinityManager$;
import org.apache.gluten.substrait.SubstraitContext;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.extensions.ExtensionBuilder;
import org.apache.gluten.substrait.rel.RelBuilder;
import org.apache.gluten.substrait.rel.RelNode;
import org.apache.gluten.substrait.type.ColumnTypeNode;
import org.apache.spark.affinity.CHAffinity$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.delta.ClickhouseSnapshot$;
import org.apache.spark.sql.delta.catalog.ClickHouseTableV2;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.execution.datasources.CHDatasourceJniWrapper;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.clickhouse.ExtensionTableBuilder;
import org.apache.spark.sql.execution.datasources.clickhouse.ExtensionTableNode;
import org.apache.spark.sql.execution.datasources.clickhouse.MergeTreePartFilterReturnedRange;
import org.apache.spark.sql.execution.datasources.mergetree.PartSerializer$;
import org.apache.spark.sql.execution.datasources.mergetree.StorageMeta$;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.metadata.AddMergeTreeParts;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.source.DeltaMergeTreeFileFormat;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SparkResourceUtil$;
import org.apache.spark.util.collection.BitSet;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class MergeTreePartsPartitionsUtil$
implements Logging {
    public static MergeTreePartsPartitionsUtil$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MergeTreePartsPartitionsUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<InputPartition> getMergeTreePartsPartitions(HadoopFsRelation relation, PartitionDirectory[] selectedPartitions, Seq<Attribute> output, boolean bucketedScan, SparkSession sparkSession, ClickHouseTableV2 table, Option<BitSet> optionalBucketSet, Option<Object> optionalNumCoalescedBuckets, boolean disableBucketedScan, Seq<Expression> filterExprs) {
        Tuple2 tuple2;
        if (!(relation.location() instanceof TahoeFileIndex) || !(relation.fileFormat() instanceof DeltaMergeTreeFileFormat)) {
            throw new IllegalStateException();
        }
        TahoeFileIndex fileIndex = (TahoeFileIndex)relation.location();
        String snapshotId = ClickhouseSnapshot$.MODULE$.genSnapshotId(table.deltaLog().update(true, table.deltaLog().update$default$2()));
        ArrayBuffer partitions = new ArrayBuffer();
        Tuple2 tuple22 = tuple2 = table.catalogTable().isDefined() ? new Tuple2(((CatalogTable)table.catalogTable().get()).identifier().database().get(), (Object)((CatalogTable)table.catalogTable().get()).identifier().table()) : new Tuple2((Object)StorageMeta$.MODULE$.DEFAULT_PATH_BASED_DATABASE(), (Object)table.deltaPath().toUri().getPath());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String database = (String)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)database, (Object)tableName);
        Tuple2 tuple24 = tuple23;
        String database2 = (String)tuple24._1();
        String tableName2 = (String)tuple24._2();
        String engine = "MergeTree";
        String relativeTablePath = fileIndex.deltaLog().dataPath().toUri().getPath().substring(1);
        String absoluteTablePath = fileIndex.deltaLog().dataPath().toUri().toString();
        if (table.bucketOption().isDefined() && bucketedScan) {
            this.genBucketedInputPartitionSeq(engine, database2, tableName2, snapshotId, relativeTablePath, absoluteTablePath, (BucketSpec)table.bucketOption().get(), optionalBucketSet, optionalNumCoalescedBuckets, selectedPartitions, table.schema(), (ArrayBuffer<InputPartition>)partitions, table, table.clickhouseTableConfigs(), output, filterExprs, sparkSession);
        } else {
            this.genInputPartitionSeq(relation, engine, database2, tableName2, snapshotId, relativeTablePath, absoluteTablePath, optionalBucketSet, selectedPartitions, table.schema(), (ArrayBuffer<InputPartition>)partitions, table, table.clickhouseTableConfigs(), output, filterExprs, sparkSession);
        }
        return partitions.toSeq();
    }

    /*
     * Unable to fully structure code
     */
    public void genInputPartitionSeq(HadoopFsRelation relation, String engine, String database, String tableName, String snapshotId, String relativeTablePath, String absoluteTablePath, Option<BitSet> optionalBucketSet, PartitionDirectory[] selectedPartitions, StructType tableSchema, ArrayBuffer<InputPartition> partitions, ClickHouseTableV2 table, scala.collection.immutable.Map<String, String> clickhouseTableConfigs, Seq<Attribute> output, Seq<Expression> filterExprs, SparkSession sparkSession) {
        bucketingEnabled = sparkSession.sessionState().conf().bucketingEnabled();
        var21_18 = optionalBucketSet;
        if (!(var21_18 instanceof Some)) ** GOTO lbl-1000
        var22_19 = (Some)var21_18;
        bucketSet = (BitSet)var22_19.value();
        if (bucketingEnabled) {
            var18_21 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$1$adapted(org.apache.spark.util.collection.BitSet java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((BitSet)bucketSet);
        } else lbl-1000:
        // 2 sources

        {
            var18_21 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$5$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)();
        }
        shouldProcess = var18_21;
        selectPartsFiles = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedPartitions)).flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$6(org.apache.spark.sql.execution.datasources.PartitionDirectory ), (Lorg/apache/spark/sql/execution/datasources/PartitionDirectory;)Lscala/collection/Seq;)(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AddMergeTreeParts.class))))).filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$8$adapted(scala.Function1 org.apache.spark.sql.execution.datasources.v2.clickhouse.metadata.AddMergeTreeParts ), (Lorg/apache/spark/sql/execution/datasources/v2/clickhouse/metadata/AddMergeTreeParts;)Ljava/lang/Object;)((Function1)shouldProcess)))).toSeq();
        if (selectPartsFiles.isEmpty()) {
            return;
        }
        selectRanges = this.getMergeTreePartRange((Seq<AddMergeTreeParts>)selectPartsFiles, snapshotId, database, tableName, relativeTablePath, absoluteTablePath, tableSchema, table, clickhouseTableConfigs, filterExprs, output, sparkSession);
        if (selectRanges.isEmpty()) {
            return;
        }
        maxSplitBytes = this.getMaxSplitBytes(sparkSession, selectRanges);
        totalCores = SparkResourceUtil$.MODULE$.getTotalCores(relation.sparkSession().sessionState().conf());
        isAllSmallFiles = selectRanges.forall((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$9$adapted(long org.apache.gluten.execution.MergeTreePartRange ), (Lorg/apache/gluten/execution/MergeTreePartRange;)Ljava/lang/Object;)((long)maxSplitBytes));
        fileCntThreshold = new StringOps(Predef$.MODULE$.augmentString(relation.sparkSession().sessionState().conf().getConfString(CHBackendSettings$.MODULE$.GLUTEN_CLICKHOUSE_FILES_PER_PARTITION_THRESHOLD(), CHBackendSettings$.MODULE$.GLUTEN_CLICKHOUSE_FILES_PER_PARTITION_THRESHOLD_DEFAULT()))).toInt();
        totalMarksThreshold = totalCores * fileCntThreshold;
        if (fileCntThreshold > 0 && isAllSmallFiles && selectRanges.size() <= totalMarksThreshold) {
            fileCnt = (int)package$.MODULE$.round((double)selectRanges.size() * 1.0 / (double)totalCores);
            if (fileCnt < 1) {
                fileCnt = 1;
            }
            splitFiles = (Seq)selectRanges.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$10(org.apache.gluten.execution.MergeTreePartRange ), (Lorg/apache/gluten/execution/MergeTreePartRange;)Lorg/apache/gluten/execution/MergeTreePartSplit;)(), Seq$.MODULE$.canBuildFrom());
            this.genInputPartitionSeqByFileCnt(engine, database, tableName, snapshotId, relativeTablePath, absoluteTablePath, tableSchema, partitions, table, clickhouseTableConfigs, (Seq<MergeTreePartSplit>)splitFiles, fileCnt);
        } else {
            openCostInBytes = sparkSession.sessionState().conf().filesOpenCostInBytes();
            totalMarks = BoxesRunTime.unboxToLong((Object)((TraversableOnce)selectRanges.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$11$adapted(org.apache.gluten.execution.MergeTreePartRange ), (Lorg/apache/gluten/execution/MergeTreePartRange;)Ljava/lang/Object;)(), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            totalBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)selectRanges.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$12$adapted(org.apache.gluten.execution.MergeTreePartRange ), (Lorg/apache/gluten/execution/MergeTreePartRange;)Ljava/lang/Object;)(), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            markCntPerPartition = maxSplitBytes * totalMarks / totalBytes + 1L;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$genInputPartitionSeq$13(long ), ()Ljava/lang/String;)((long)markCntPerPartition));
            splitFiles = (Seq)selectRanges.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$genInputPartitionSeq$14(long org.apache.gluten.execution.MergeTreePartRange ), (Lorg/apache/gluten/execution/MergeTreePartRange;)Lscala/collection/immutable/IndexedSeq;)((long)markCntPerPartition), Seq$.MODULE$.canBuildFrom());
            var44_37 = this.calculatedLocationForSoftAffinity((Seq<MergeTreePartSplit>)splitFiles, relativeTablePath);
            if (var44_37 == null) {
                throw new MatchError(var44_37);
            }
            partNameWithLocation = (HashMap)var44_37._1();
            locationDistinct = (HashSet)var44_37._2();
            var17_40 = new Tuple2((Object)partNameWithLocation, (Object)locationDistinct);
            var43_41 = var17_40;
            partNameWithLocation = (HashMap)var43_41._1();
            locationDistinct = (HashSet)var43_41._2();
            this.genInputPartitionSeqBySplitFiles(engine, database, tableName, snapshotId, relativeTablePath, absoluteTablePath, tableSchema, partitions, table, clickhouseTableConfigs, (Seq<MergeTreePartSplit>)splitFiles, openCostInBytes, maxSplitBytes, partNameWithLocation, locationDistinct);
        }
    }

    public void genInputPartitionSeqByFileCnt(String engine, String database, String tableName, String snapshotId, String relativeTablePath, String absoluteTablePath, StructType tableSchema, ArrayBuffer<InputPartition> partitions, ClickHouseTableV2 table, scala.collection.immutable.Map<String, String> clickhouseTableConfigs, Seq<MergeTreePartSplit> splitFiles, int fileCnt) {
        ArrayBuffer currentFiles = new ArrayBuffer();
        LongRef currentFileCnt = LongRef.create((long)0L);
        splitFiles.foreach((Function1 & Serializable & scala.Serializable)file -> {
            if (currentFileCnt$1.elem >= (long)fileCnt) {
                MergeTreePartsPartitionsUtil$.closePartition$1(currentFiles, partitions, engine, database, tableName, snapshotId, relativeTablePath, absoluteTablePath, table, tableSchema, clickhouseTableConfigs, currentFileCnt);
            }
            ++currentFileCnt$1.elem;
            return currentFiles.$plus$eq(file);
        });
        MergeTreePartsPartitionsUtil$.closePartition$1(currentFiles, partitions, engine, database, tableName, snapshotId, relativeTablePath, absoluteTablePath, table, tableSchema, clickhouseTableConfigs, currentFileCnt);
        partitions.toSeq();
    }

    public void genInputPartitionSeqBySplitFiles(String engine, String database, String tableName, String snapshotId, String relativeTablePath, String absoluteTablePath, StructType tableSchema, ArrayBuffer<InputPartition> partitions, ClickHouseTableV2 table, scala.collection.immutable.Map<String, String> clickhouseTableConfigs, Seq<MergeTreePartSplit> splitFiles, long openCostInBytes, long maxSplitBytes, HashMap<String, String> partNameWithLocation, HashSet<String> locationDistinct) {
        HashMap currentSizeByLocation = new HashMap();
        HashMap currentFilesByLocation = new HashMap();
        locationDistinct.forEach(location -> {
            currentSizeByLocation.put(location, BoxesRunTime.boxToLong((long)0L));
            currentFilesByLocation.put(location, new ArrayBuffer());
        });
        splitFiles.foreach((Function1 & Serializable & scala.Serializable)parts -> {
            String location = (String)partNameWithLocation.get(parts.name());
            long currentSize = BoxesRunTime.unboxToLong(currentSizeByLocation.get(location));
            ArrayBuffer currentFiles = (ArrayBuffer)currentFilesByLocation.get(location);
            if (currentSize + parts.bytesOnDisk() > maxSplitBytes) {
                MergeTreePartsPartitionsUtil$.closePartition$2(location, currentFilesByLocation, partitions, engine, database, tableName, snapshotId, relativeTablePath, absoluteTablePath, table, tableSchema, clickhouseTableConfigs, currentSizeByLocation);
                currentSize = 0L;
            }
            currentSizeByLocation.put(location, BoxesRunTime.boxToLong((long)(currentSize + parts.bytesOnDisk() + openCostInBytes)));
            return currentFiles.$plus$eq(parts);
        });
        locationDistinct.forEach(location -> MergeTreePartsPartitionsUtil$.closePartition$2(location, currentFilesByLocation, partitions, engine, database, tableName, snapshotId, relativeTablePath, absoluteTablePath, table, tableSchema, clickhouseTableConfigs, currentSizeByLocation));
    }

    public void genBucketedInputPartitionSeq(String engine, String database, String tableName, String snapshotId, String relativeTablePath, String absoluteTablePath, BucketSpec bucketSpec, Option<BitSet> optionalBucketSet, Option<Object> optionalNumCoalescedBuckets, PartitionDirectory[] selectedPartitions, StructType tableSchema, ArrayBuffer<InputPartition> partitions, ClickHouseTableV2 table, scala.collection.immutable.Map<String, String> clickhouseTableConfigs, Seq<Attribute> output, Seq<Expression> filterExprs, SparkSession sparkSession) {
        scala.collection.immutable.Map prunedFilesGroupedToBuckets;
        scala.collection.immutable.Map map;
        Seq selectPartsFiles = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectedPartitions)).flatMap((Function1 & Serializable & scala.Serializable)partition -> (Seq)partition.files().map((Function1 & Serializable & scala.Serializable)fs -> {
            void var2_2;
            String path = fs.getPath().toString();
            AddMergeTreeParts ret = (AddMergeTreeParts)((Object)((Object)((Object)ClickhouseSnapshot$.MODULE$.pathToAddMTPCache().getIfPresent((Object)path))));
            if (ret == null) {
                Set keys = ClickhouseSnapshot$.MODULE$.pathToAddMTPCache().asMap().keySet();
                String keySample = keys.isEmpty() ? "<empty>" : (String)keys.iterator().next();
                throw new IllegalStateException(new StringBuilder(206).append("Can't find AddMergeTreeParts from cache pathToAddMTPCache for key: ").append(path).append(". This happens when too many new entries are added to ").append("pathToAddMTPCache during current query. ").append("Try rerun current query. Existing KeySample: ").append(keySample).toString());
            }
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(AddMergeTreeParts.class))))).toSeq();
        if (selectPartsFiles.isEmpty()) {
            return;
        }
        Seq<MergeTreePartRange> selectRanges = this.getMergeTreePartRange((Seq<AddMergeTreeParts>)selectPartsFiles, snapshotId, database, tableName, relativeTablePath, absoluteTablePath, tableSchema, table, clickhouseTableConfigs, filterExprs, output, sparkSession);
        if (selectRanges.isEmpty()) {
            return;
        }
        scala.collection.immutable.Map bucketGroupParts = selectRanges.groupBy((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToInteger((int)MergeTreePartsPartitionsUtil$.$anonfun$genBucketedInputPartitionSeq$3(p)));
        if (optionalBucketSet.isDefined()) {
            BitSet bucketSet = (BitSet)optionalBucketSet.get();
            map = (scala.collection.immutable.Map)bucketGroupParts.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)bucketSet.get(f._1$mcI$sp())));
        } else {
            map = prunedFilesGroupedToBuckets = bucketGroupParts;
        }
        if (optionalNumCoalescedBuckets.isDefined()) {
            throw new UnsupportedOperationException("Currently CH backend can't support coalesced buckets.");
        }
        Seq$.MODULE$.tabulate(bucketSpec.numBuckets(), (Function1 & Serializable & scala.Serializable)bucketId -> MergeTreePartsPartitionsUtil$.$anonfun$genBucketedInputPartitionSeq$5(prunedFilesGroupedToBuckets, partitions, engine, database, tableName, snapshotId, relativeTablePath, absoluteTablePath, table, tableSchema, clickhouseTableConfigs, BoxesRunTime.unboxToInt((Object)bucketId)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean useDriverFilter(Seq<Expression> filterExprs, SparkSession sparkSession) {
        String enableDriverFilterKey = CHConf$.MODULE$.runtimeSettings("enabled_driver_filter_mergetree_index");
        if (!filterExprs.nonEmpty()) return false;
        String string = sparkSession.sessionState().conf().getConfString(enableDriverFilterKey, "false");
        String string2 = "true";
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (SoftAffinityManager$.MODULE$.usingSoftAffinity()) return false;
        return true;
    }

    private Seq<MergeTreePartRange> getMergeTreePartRange(Seq<AddMergeTreeParts> selectPartsFiles, String snapshotId, String database, String tableName, String relativeTablePath, String absoluteTablePath, StructType tableSchema, ClickHouseTableV2 table, scala.collection.immutable.Map<String, String> clickhouseTableConfigs, Seq<Expression> filterExprs, Seq<Attribute> output, SparkSession sparkSession) {
        Seq seq;
        if (this.useDriverFilter(filterExprs, sparkSession)) {
            Tuple2 tuple2 = ((GenericTraversableTemplate)selectPartsFiles.map((Function1 & Serializable & scala.Serializable)part -> new Tuple2.mcJJ.sp(part.size(), part.marks()), Seq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq l1 = (Seq)tuple2._1();
            Seq l2 = (Seq)tuple2._2();
            long l = BoxesRunTime.unboxToLong((Object)l1.sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / BoxesRunTime.unboxToLong((Object)l2.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            long size_per_mark = l;
            ExtensionTableNode extensionTableNode = ExtensionTableBuilder.makeExtensionTable(database, tableName, snapshotId, relativeTablePath, absoluteTablePath, table.orderByKey(), table.lowCardKey(), table.minmaxIndexKey(), table.bfIndexKey(), table.setIndexKey(), table.primaryKey(), PartSerializer$.MODULE$.fromAddMergeTreeParts(selectPartsFiles), tableSchema, (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(clickhouseTableConfigs).asJava(), new ArrayList<String>());
            Option transformer = ((TraversableOnce)filterExprs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Expression expression = x0$1;
                if (!(expression instanceof AttributeReference)) return expression;
                AttributeReference attributeReference = (AttributeReference)expression;
                DataType dataType = attributeReference.dataType();
                BooleanType$ booleanType$ = BooleanType$.MODULE$;
                if (dataType != null) {
                    if (!dataType.equals(booleanType$)) return expression;
                    return new EqualNullSafe((Expression)attributeReference, (Expression)Literal$.MODULE$.TrueLiteral());
                }
                if (booleanType$ == null) return new EqualNullSafe((Expression)attributeReference, (Expression)Literal$.MODULE$.TrueLiteral());
                return expression;
            }, Seq$.MODULE$.canBuildFrom())).reduceLeftOption((Function2)And$.MODULE$).map((Function1 & Serializable & scala.Serializable)x$7 -> ExpressionConverter$.MODULE$.replaceWithExpressionTransformer(x$7, output));
            List typeNodes = ConverterUtils$.MODULE$.collectAttributeTypeNodes(output);
            List nameList = ConverterUtils$.MODULE$.collectAttributeNamesWithoutExprId(output);
            List columnTypeNodes = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)output.map((Function1 & Serializable & scala.Serializable)attr -> table.partitionColumns().exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.equals(attr.name()))) ? new ColumnTypeNode(NamedStruct.ColumnType.PARTITION_COL) : new ColumnTypeNode(NamedStruct.ColumnType.NORMAL_COL), Seq$.MODULE$.canBuildFrom())).asJava();
            SubstraitContext substraitContext = new SubstraitContext();
            Any enhancement = Any.pack((Message)StringValue.newBuilder().setValue(extensionTableNode.getExtensionTableStr()).build());
            AdvancedExtensionNode extensionNode = ExtensionBuilder.makeAdvancedExtension((Any)enhancement);
            RelNode readNode = RelBuilder.makeReadRel((List)typeNodes, (List)nameList, (List)columnTypeNodes, (ExpressionNode)((ExpressionNode)transformer.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.doTransform((Object)substraitContext.registeredFunction())).orNull(Predef$.MODULE$.$conforms())), (AdvancedExtensionNode)extensionNode, (SubstraitContext)substraitContext, (Long)substraitContext.nextOperatorId("readRel"));
            Plan.Builder planBuilder = Plan.newBuilder();
            substraitContext.registeredFunction().forEach((k, v) -> planBuilder.addExtensions(ExtensionBuilder.makeFunctionMapping((String)k, (Long)v).toProtobuf()));
            String filter_ranges = CHDatasourceJniWrapper.filterRangesOnDriver(planBuilder.build().toByteArray(), readNode.toProtobuf().toByteArray());
            ObjectMapper mapper = new ObjectMapper();
            ArrayList values = (ArrayList)mapper.readValue(filter_ranges, (TypeReference)new TypeReference<ArrayList<MergeTreePartFilterReturnedRange>>(){});
            scala.collection.immutable.Map partMap = ((TraversableOnce)selectPartsFiles.map((Function1 & Serializable & scala.Serializable)part -> new Tuple2((Object)part.name(), (Object)part), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            seq = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)values).asScala()).map((Function1 & Serializable & scala.Serializable)range -> {
                AddMergeTreeParts part = (AddMergeTreeParts)((Object)((Object)partMap.get((Object)range.getPartName()).orNull(Predef$.MODULE$.$conforms())));
                long marks = range.getEnd() - range.getBegin();
                return new MergeTreePartRange(part.name(), part.dirName(), part.targetNode(), part.bucketNum(), range.getBegin(), marks, marks * size_per_mark);
            }, Buffer$.MODULE$.canBuildFrom())).toSeq();
        } else {
            seq = ((SeqLike)selectPartsFiles.map((Function1 & Serializable & scala.Serializable)part -> new MergeTreePartRange(part.name(), part.dirName(), part.targetNode(), part.bucketNum(), 0L, part.marks(), part.size()), Seq$.MODULE$.canBuildFrom())).toSeq();
        }
        return seq;
    }

    private Tuple2<HashMap<String, String>, HashSet<String>> calculatedLocationForSoftAffinity(Seq<MergeTreePartSplit> splits, String relativeTablePath) {
        HashMap partNameWithLocation = new HashMap();
        HashSet locationDistinct = new HashSet();
        splits.foreach((Function1 & Serializable & scala.Serializable)part -> {
            Object object;
            if (!partNameWithLocation.containsKey(part.name())) {
                String[] locations = CHAffinity$.MODULE$.getNativeMergeTreePartLocations(part.name(), relativeTablePath);
                String localtionKey = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])locations)).sorted((Ordering)Ordering.String$.MODULE$))).mkString(",");
                locationDistinct.add(localtionKey);
                object = partNameWithLocation.put(part.name(), localtionKey);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        return new Tuple2(partNameWithLocation, locationDistinct);
    }

    public long getMaxSplitBytes(SparkSession sparkSession, Seq<MergeTreePartRange> selectedRanges) {
        long defaultMaxSplitBytes = sparkSession.sessionState().conf().filesMaxPartitionBytes();
        long openCostInBytes = sparkSession.sessionState().conf().filesOpenCostInBytes();
        int minPartitionNum = BoxesRunTime.unboxToInt((Object)sparkSession.sessionState().conf().filesMinPartitionNum().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> sparkSession.leafNodeDefaultParallelism()));
        long totalBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)selectedRanges.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)MergeTreePartsPartitionsUtil$.$anonfun$getMaxSplitBytes$2(openCostInBytes, x$10)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long bytesPerCore = totalBytes / (long)minPartitionNum;
        return Math.min(defaultMaxSplitBytes, Math.max(openCostInBytes, bytesPerCore));
    }

    public static final /* synthetic */ int $anonfun$genInputPartitionSeq$3(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$genInputPartitionSeq$1(BitSet bucketSet$1, String name) {
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])name.split("/"))).dropRight(1))).filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains("="))))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)MergeTreePartsPartitionsUtil$.$anonfun$genInputPartitionSeq$3(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)index -> bucketSet$1.get(index));
    }

    public static final /* synthetic */ boolean $anonfun$genInputPartitionSeq$5(String x$4) {
        return true;
    }

    public static final /* synthetic */ Seq $anonfun$genInputPartitionSeq$6(PartitionDirectory partition) {
        return (Seq)partition.files().map((Function1 & Serializable & scala.Serializable)fs -> {
            void var2_2;
            String path = fs.getPath().toUri().toString();
            AddMergeTreeParts ret = (AddMergeTreeParts)((Object)((Object)ClickhouseSnapshot$.MODULE$.pathToAddMTPCache().getIfPresent((Object)path)));
            if (ret == null) {
                Set keys = ClickhouseSnapshot$.MODULE$.pathToAddMTPCache().asMap().keySet();
                String keySample = keys.isEmpty() ? "<empty>" : (String)keys.iterator().next();
                throw new IllegalStateException(new StringBuilder(206).append("Can't find AddMergeTreeParts from cache pathToAddMTPCache for key: ").append(path).append(". This happens when too many new entries are added to ").append("pathToAddMTPCache during current query. ").append("Try rerun current query. Existing KeySample: ").append(keySample).toString());
            }
            return var2_2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$genInputPartitionSeq$8(Function1 shouldProcess$1, AddMergeTreeParts part) {
        return BoxesRunTime.unboxToBoolean((Object)shouldProcess$1.apply((Object)part.name()));
    }

    public static final /* synthetic */ boolean $anonfun$genInputPartitionSeq$9(long maxSplitBytes$1, MergeTreePartRange x$5) {
        return x$5.size() < maxSplitBytes$1;
    }

    public static final /* synthetic */ MergeTreePartSplit $anonfun$genInputPartitionSeq$10(MergeTreePartRange part) {
        return new MergeTreePartSplit(part.name(), part.dirName(), part.targetNode(), part.start(), part.marks(), part.size());
    }

    public static final /* synthetic */ String $anonfun$genInputPartitionSeq$13(long markCntPerPartition$1) {
        return new StringBuilder(42).append("Planning scan with bin packing, max mark: ").append(markCntPerPartition$1).toString();
    }

    public static final /* synthetic */ MergeTreePartSplit $anonfun$genInputPartitionSeq$15(long end$1, long markCntPerPartition$1, MergeTreePartRange part$1, long offset) {
        long remaining = end$1 - offset;
        long size = remaining > markCntPerPartition$1 ? markCntPerPartition$1 : remaining;
        return new MergeTreePartSplit(part$1.name(), part$1.dirName(), part$1.targetNode(), offset, size, size * part$1.size() / part$1.marks());
    }

    public static final /* synthetic */ IndexedSeq $anonfun$genInputPartitionSeq$14(long markCntPerPartition$1, MergeTreePartRange part) {
        long end = part.marks() + part.start();
        return (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(part.start())).until((Object)BoxesRunTime.boxToLong((long)end)).by((Object)BoxesRunTime.boxToLong((long)markCntPerPartition$1)).map((Function1 & Serializable & scala.Serializable)offset -> MergeTreePartsPartitionsUtil$.$anonfun$genInputPartitionSeq$15(end, markCntPerPartition$1, part, BoxesRunTime.unboxToLong((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private static final void closePartition$1(ArrayBuffer currentFiles$1, ArrayBuffer partitions$1, String engine$1, String database$1, String tableName$1, String snapshotId$1, String relativeTablePath$1, String absoluteTablePath$1, ClickHouseTableV2 table$1, StructType tableSchema$1, scala.collection.immutable.Map clickhouseTableConfigs$1, LongRef currentFileCnt$1) {
        BoxedUnit boxedUnit;
        if (currentFiles$1.nonEmpty()) {
            GlutenMergeTreePartition newPartition = new GlutenMergeTreePartition(partitions$1.size(), engine$1, database$1, tableName$1, snapshotId$1, relativeTablePath$1, absoluteTablePath$1, table$1.orderByKey(), table$1.lowCardKey(), table$1.minmaxIndexKey(), table$1.bfIndexKey(), table$1.setIndexKey(), table$1.primaryKey(), (MergeTreePartSplit[])currentFiles$1.toArray(ClassTag$.MODULE$.apply(MergeTreePartSplit.class)), tableSchema$1, (scala.collection.immutable.Map<String, String>)clickhouseTableConfigs$1);
            boxedUnit = partitions$1.$plus$eq((Object)newPartition);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        currentFiles$1.clear();
        currentFileCnt$1.elem = 0L;
    }

    private static final void closePartition$2(String location, HashMap currentFilesByLocation$1, ArrayBuffer partitions$2, String engine$2, String database$2, String tableName$2, String snapshotId$2, String relativeTablePath$2, String absoluteTablePath$2, ClickHouseTableV2 table$2, StructType tableSchema$2, scala.collection.immutable.Map clickhouseTableConfigs$2, HashMap currentSizeByLocation$1) {
        BoxedUnit boxedUnit;
        ArrayBuffer currentFiles = (ArrayBuffer)currentFilesByLocation$1.get(location);
        if (currentFiles.nonEmpty()) {
            GlutenMergeTreePartition newPartition = new GlutenMergeTreePartition(partitions$2.size(), engine$2, database$2, tableName$2, snapshotId$2, relativeTablePath$2, absoluteTablePath$2, table$2.orderByKey(), table$2.lowCardKey(), table$2.minmaxIndexKey(), table$2.bfIndexKey(), table$2.setIndexKey(), table$2.primaryKey(), (MergeTreePartSplit[])currentFiles.toArray(ClassTag$.MODULE$.apply(MergeTreePartSplit.class)), tableSchema$2, (scala.collection.immutable.Map<String, String>)clickhouseTableConfigs$2);
            boxedUnit = partitions$2.$plus$eq((Object)newPartition);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        currentFiles.clear();
        currentSizeByLocation$1.put(location, BoxesRunTime.boxToLong((long)0L));
    }

    public static final /* synthetic */ int $anonfun$genBucketedInputPartitionSeq$3(MergeTreePartRange p) {
        return Integer.parseInt(p.bucketNum());
    }

    public static final /* synthetic */ Object $anonfun$genBucketedInputPartitionSeq$5(scala.collection.immutable.Map prunedFilesGroupedToBuckets$1, ArrayBuffer partitions$3, String engine$3, String database$3, String tableName$3, String snapshotId$3, String relativeTablePath$3, String absoluteTablePath$3, ClickHouseTableV2 table$3, StructType tableSchema$3, scala.collection.immutable.Map clickhouseTableConfigs$3, int bucketId) {
        BoxedUnit boxedUnit;
        Seq currBucketParts = (Seq)prunedFilesGroupedToBuckets$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)bucketId), (Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        if (currBucketParts.nonEmpty()) {
            Seq currentFiles = (Seq)currBucketParts.map((Function1 & Serializable & scala.Serializable)part -> new MergeTreePartSplit(part.name(), part.dirName(), part.targetNode(), part.start(), part.marks(), part.size()), Seq$.MODULE$.canBuildFrom());
            GlutenMergeTreePartition newPartition = new GlutenMergeTreePartition(partitions$3.size(), engine$3, database$3, tableName$3, snapshotId$3, relativeTablePath$3, absoluteTablePath$3, table$3.orderByKey(), table$3.lowCardKey(), table$3.minmaxIndexKey(), table$3.bfIndexKey(), table$3.setIndexKey(), table$3.primaryKey(), (MergeTreePartSplit[])currentFiles.toArray(ClassTag$.MODULE$.apply(MergeTreePartSplit.class)), tableSchema$3, (scala.collection.immutable.Map<String, String>)clickhouseTableConfigs$3);
            boxedUnit = partitions$3.$plus$eq((Object)newPartition);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ long $anonfun$getMaxSplitBytes$2(long openCostInBytes$2, MergeTreePartRange x$10) {
        return x$10.size() + openCostInBytes$2;
    }

    private MergeTreePartsPartitionsUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }

    public static final /* synthetic */ Object $anonfun$genInputPartitionSeq$1$adapted(BitSet bucketSet$1, String name) {
        return BoxesRunTime.boxToBoolean((boolean)MergeTreePartsPartitionsUtil$.$anonfun$genInputPartitionSeq$1(bucketSet$1, name));
    }

    public static final /* synthetic */ Object $anonfun$genInputPartitionSeq$5$adapted(String x$4) {
        return BoxesRunTime.boxToBoolean((boolean)MergeTreePartsPartitionsUtil$.$anonfun$genInputPartitionSeq$5(x$4));
    }

    public static final /* synthetic */ Object $anonfun$genInputPartitionSeq$8$adapted(Function1 shouldProcess$1, AddMergeTreeParts part) {
        return BoxesRunTime.boxToBoolean((boolean)MergeTreePartsPartitionsUtil$.$anonfun$genInputPartitionSeq$8(shouldProcess$1, part));
    }

    public static final /* synthetic */ Object $anonfun$genInputPartitionSeq$9$adapted(long maxSplitBytes$1, MergeTreePartRange x$5) {
        return BoxesRunTime.boxToBoolean((boolean)MergeTreePartsPartitionsUtil$.$anonfun$genInputPartitionSeq$9(maxSplitBytes$1, x$5));
    }

    public static final /* synthetic */ Object $anonfun$genInputPartitionSeq$11$adapted(MergeTreePartRange p) {
        return BoxesRunTime.boxToLong((long)p.marks());
    }

    public static final /* synthetic */ Object $anonfun$genInputPartitionSeq$12$adapted(MergeTreePartRange p) {
        return BoxesRunTime.boxToLong((long)p.size());
    }
}

