/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.gluten.backendsapi.clickhouse.CHBackendSettings$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.AddFileAsKey;
import org.apache.spark.sql.delta.FilterExprsAsKey;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.stats.DeltaScan;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.metadata.AddFileTags$;
import org.apache.spark.sql.execution.datasources.v2.clickhouse.metadata.AddMergeTreeParts;
import scala.Function0;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.runtime.java8.JFunction0;

public final class ClickhouseSnapshot$ {
    public static ClickhouseSnapshot$ MODULE$;
    private final Cache<FilterExprsAsKey, DeltaScan> deltaScanCache;
    private final LoadingCache<AddFileAsKey, AddMergeTreeParts> addFileToAddMTPCache;
    private final Cache<String, AddMergeTreeParts> pathToAddMTPCache;

    static {
        new ClickhouseSnapshot$();
    }

    public Cache<FilterExprsAsKey, DeltaScan> deltaScanCache() {
        return this.deltaScanCache;
    }

    public LoadingCache<AddFileAsKey, AddMergeTreeParts> addFileToAddMTPCache() {
        return this.addFileToAddMTPCache;
    }

    public Cache<String, AddMergeTreeParts> pathToAddMTPCache() {
        return this.pathToAddMTPCache;
    }

    public void clearAllFileStatusCache() {
        this.addFileToAddMTPCache().invalidateAll();
        this.pathToAddMTPCache().invalidateAll();
        this.deltaScanCache().invalidateAll();
    }

    public String genSnapshotId(Snapshot snapshot) {
        return new StringBuilder(1).append(snapshot.metadata().createdTime().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> System.currentTimeMillis())).append("_").append(snapshot.version()).toString();
    }

    private ClickhouseSnapshot$() {
        MODULE$ = this;
        this.deltaScanCache = CacheBuilder.newBuilder().maximumSize(new StringOps(Predef$.MODULE$.augmentString(((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().get(CHBackendSettings$.MODULE$.GLUTEN_CLICKHOUSE_DELTA_SCAN_CACHE_SIZE(), "10000"))).toLong()).expireAfterAccess(7200L, TimeUnit.SECONDS).recordStats().build();
        this.addFileToAddMTPCache = CacheBuilder.newBuilder().maximumSize(new StringOps(Predef$.MODULE$.augmentString(((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().get(CHBackendSettings$.MODULE$.GLUTEN_CLICKHOUSE_ADDFILES_TO_MTPS_CACHE_SIZE(), "1000000"))).toLong()).expireAfterAccess(7200L, TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<AddFileAsKey, AddMergeTreeParts>(){

            public AddMergeTreeParts load(AddFileAsKey key) throws Exception {
                return AddFileTags$.MODULE$.addFileToAddMergeTreeParts(key.addFile());
            }
        });
        this.pathToAddMTPCache = CacheBuilder.newBuilder().maximumSize(new StringOps(Predef$.MODULE$.augmentString(((SparkSession)SparkSession$.MODULE$.getActiveSession().get()).conf().get(CHBackendSettings$.MODULE$.GLUTEN_CLICKHOUSE_TABLE_PATH_TO_MTPS_CACHE_SIZE(), "1000000"))).toLong()).expireAfterAccess(7200L, TimeUnit.SECONDS).recordStats().build();
    }
}

