/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.rest.controller.NAsyncQueryController;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AsyncQuerySQLRequest;
import org.apache.kylin.rest.request.AsyncQuerySQLRequestV2;
import org.apache.kylin.rest.response.AsyncQueryResponse;
import org.apache.kylin.rest.response.AsyncQueryResponseV2;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.AsyncQueryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"application/vnd.apache.kylin-v2+json"})
public class NAsyncQueryControllerV2
extends NBasicController {
    @Autowired
    @Qualifier(value="asyncQueryService")
    private AsyncQueryService asyncQueryService;
    @Autowired
    protected NAsyncQueryController asyncQueryController;

    @ApiOperation(value="query", tags={"QE"}, notes="Update Param: query_id, accept_partial, backdoor_toggles, cache_key; Update Response: query_id")
    @PostMapping(value={"/async_query"})
    @ResponseBody
    public EnvelopeResponse<AsyncQueryResponseV2> query(@Valid @RequestBody AsyncQuerySQLRequestV2 asyncQuerySQLRequest) throws InterruptedException, IOException {
        AsyncQuerySQLRequest sqlRequest = new AsyncQuerySQLRequest();
        sqlRequest.setProject(asyncQuerySQLRequest.getProject());
        sqlRequest.setSql(asyncQuerySQLRequest.getSql());
        sqlRequest.setSeparator(asyncQuerySQLRequest.getSeparator());
        sqlRequest.setIncludeHeader(asyncQuerySQLRequest.isIncludeHeader());
        sqlRequest.setFormat("csv");
        sqlRequest.setEncode("utf-8");
        sqlRequest.setFileName("result");
        sqlRequest.setLimit(asyncQuerySQLRequest.getLimit());
        sqlRequest.setOffset(asyncQuerySQLRequest.getOffset());
        AsyncQueryResponse resp = (AsyncQueryResponse)this.asyncQueryController.query(sqlRequest).getData();
        if (resp.getStatus() == AsyncQueryResponse.Status.RUNNING) {
            resp.setInfo("still running");
        }
        return new EnvelopeResponse("000", (Object)AsyncQueryResponseV2.from((AsyncQueryResponse)resp), "");
    }

    @ApiOperation(value="async query status", tags={"QE"})
    @GetMapping(value={"/async_query/{query_id:.+}/metadata"})
    @ResponseBody
    public EnvelopeResponse<List<List<String>>> metadata(@PathVariable(value="query_id") String queryId, @RequestParam(value="project", required=false) String project) throws IOException {
        return new EnvelopeResponse("000", (Object)this.asyncQueryService.getMetaData(this.searchProject(project, queryId), queryId), "");
    }

    @ApiOperation(value="fileStatus", tags={"QE"}, notes="Update URL: file_status")
    @GetMapping(value={"/async_query/{query_id:.+}/filestatus"})
    @ResponseBody
    public EnvelopeResponse<Long> fileStatus(@PathVariable(value="query_id") String queryId, @RequestParam(value="project", required=false) String project) throws IOException {
        return this.asyncQueryController.fileStatus(queryId, null, this.searchProject(project, queryId));
    }

    @ApiOperation(value="query", tags={"QE"}, notes="Update Response: query_id")
    @GetMapping(value={"/async_query/{query_id:.+}/status"})
    @ResponseBody
    public EnvelopeResponse<AsyncQueryResponseV2> inqueryStatus(@PathVariable(value="query_id") String queryId, @RequestParam(value="project", required=false) String project) throws IOException {
        AsyncQueryResponse resp = (AsyncQueryResponse)this.asyncQueryController.inqueryStatus(null, queryId, this.searchProject(project, queryId)).getData();
        return new EnvelopeResponse("000", (Object)AsyncQueryResponseV2.from((AsyncQueryResponse)resp), "");
    }

    @ApiOperation(value="downloadQueryResult", tags={"QE"}, notes="Update URL: result")
    @GetMapping(value={"/async_query/{query_id:.+}/result_download"})
    @ResponseBody
    public void downloadQueryResult(@PathVariable(value="query_id") String queryId, @RequestParam(value="includeHeader", required=false) Boolean includeHeader, HttpServletResponse response, @RequestParam(value="project", required=false) String project) throws IOException {
        this.asyncQueryController.downloadQueryResult(queryId, includeHeader, includeHeader, null, response, this.searchProject(project, queryId));
    }

    private String searchProject(String project, String queryId) throws IOException {
        if (project != null) {
            return project;
        }
        project = this.asyncQueryService.searchQueryResultProject(queryId);
        if (project == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ASYNC_QUERY_RESULT_NOT_FOUND, new Object[0]);
        }
        return project;
    }
}

