/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ApiListingBuilder;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.Model;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.service.ResourceGroup;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.ModelSpecificationRegistry;
import springfox.documentation.spi.service.contexts.Orderings;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.paths.PathMappingAdjuster;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.scanners.ApiDescriptionReader;
import springfox.documentation.spring.web.scanners.ApiListingScanningContext;
import springfox.documentation.spring.web.scanners.ApiModelReader;
import springfox.documentation.spring.web.scanners.ApiModelSpecificationReader;
import springfox.documentation.spring.web.scanners.ModelSpecificationRegistryBuilder;
import springfox.documentation.spring.web.scanners.ResourceGroups;
import springfox.documentation.spring.web.scanners.ResourcePathProvider;

@Component
public class ApiListingScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiListingScanner.class);
    private final ApiDescriptionReader apiDescriptionReader;
    private final ApiModelReader apiModelReader;
    private final ApiModelSpecificationReader modelSpecificationReader;
    private final DocumentationPluginsManager pluginsManager;

    @Autowired
    public ApiListingScanner(ApiDescriptionReader apiDescriptionReader, ApiModelReader apiModelReader, ApiModelSpecificationReader modelSpecificationReader, DocumentationPluginsManager pluginsManager) {
        this.apiDescriptionReader = apiDescriptionReader;
        this.apiModelReader = apiModelReader;
        this.modelSpecificationReader = modelSpecificationReader;
        this.pluginsManager = pluginsManager;
    }

    static Optional<String> longestCommonPath(List<ApiDescription> apiDescriptions) {
        ArrayList<String> commons = new ArrayList<String>();
        if (null == apiDescriptions || apiDescriptions.isEmpty()) {
            return Optional.empty();
        }
        List<String> firstWords = ApiListingScanner.urlParts(apiDescriptions.get(0));
        for (int position = 0; position < firstWords.size(); ++position) {
            String word = firstWords.get(position);
            boolean allContain = true;
            for (int i = 1; i < apiDescriptions.size(); ++i) {
                List<String> words = ApiListingScanner.urlParts(apiDescriptions.get(i));
                if (words.size() >= position + 1 && words.get(position).equals(word)) continue;
                allContain = false;
                break;
            }
            if (!allContain) continue;
            commons.add(word);
        }
        return Optional.of("/" + commons.stream().filter(Objects::nonNull).collect(Collectors.joining("/")));
    }

    private static List<String> urlParts(ApiDescription apiDescription) {
        return Stream.of(apiDescription.getPath().split("/")).filter(((Predicate<String>)String::isEmpty).negate()).map(String::trim).collect(Collectors.toList());
    }

    public Map<String, List<ApiListing>> scan(ApiListingScanningContext context) {
        HashMap<String, List<ApiListing>> apiListingMap = new HashMap<String, List<ApiListing>>();
        int position = 0;
        Map<ResourceGroup, List<RequestMappingContext>> requestMappingsByResourceGroup = context.getRequestMappingsByResourceGroup();
        Collection<ApiDescription> additionalListings = this.pluginsManager.additionalListings(context);
        Set<ResourceGroup> allResourceGroups = Stream.concat(StreamSupport.stream(ResourceGroups.collectResourceGroups(additionalListings).spliterator(), false), requestMappingsByResourceGroup.keySet().stream()).collect(Collectors.toSet());
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        HashMap<String, Set<Model>> globalModelMap = new HashMap<String, Set<Model>>();
        for (ResourceGroup resourceGroup : ResourceGroups.sortedByName(allResourceGroups)) {
            DocumentationContext documentationContext = context.getDocumentationContext();
            LinkedHashSet<String> produces = new LinkedHashSet<String>(documentationContext.getProduces());
            LinkedHashSet<String> consumes = new LinkedHashSet<String>(documentationContext.getConsumes());
            String host = documentationContext.getHost();
            LinkedHashSet<String> protocols = new LinkedHashSet<String>(documentationContext.getProtocols());
            HashSet<ApiDescription> apiDescriptions = new HashSet<ApiDescription>();
            ModelSpecificationRegistryBuilder modelRegistryBuilder = new ModelSpecificationRegistryBuilder();
            LinkedHashMap<String, Model> models = new LinkedHashMap<String, Model>();
            List<RequestMappingContext> requestMappings = BuilderDefaults.nullToEmptyList((Collection)requestMappingsByResourceGroup.get(resourceGroup));
            for (RequestMappingContext each : this.sortedByMethods(requestMappings)) {
                Map<String, Set<Model>> currentModelMap = this.apiModelReader.read(each.withKnownModels(globalModelMap));
                modelRegistryBuilder.addAll(this.modelSpecificationReader.read(each.withKnownModels(globalModelMap)).stream().filter(m -> m.key().isPresent()).collect(Collectors.toList()));
                currentModelMap.values().forEach(list -> {
                    for (Model model : list) {
                        models.put(model.getName(), model);
                    }
                });
                globalModelMap.putAll(currentModelMap);
                apiDescriptions.addAll(this.apiDescriptionReader.read(each.withKnownModels(currentModelMap)));
            }
            List additional = additionalListings.stream().filter(ResourceGroups.belongsTo(resourceGroup.getGroupName()).and(this.onlySelectedApis(documentationContext))).collect(Collectors.toList());
            apiDescriptions.addAll(additional);
            List<ApiDescription> sortedApis = apiDescriptions.stream().sorted(documentationContext.getApiDescriptionOrdering()).collect(Collectors.toList());
            String resourcePath = new ResourcePathProvider(resourceGroup).resourcePath().orElse(ApiListingScanner.longestCommonPath(sortedApis).orElse(null));
            PathMappingAdjuster adjuster = new PathMappingAdjuster(documentationContext);
            ModelSpecificationRegistry modelRegistry = modelRegistryBuilder.build();
            ModelNamesRegistry modelNamesRegistry = this.pluginsManager.modelNamesGeneratorFactory(documentationContext.getDocumentationType()).modelNamesRegistry(modelRegistry);
            LOGGER.trace("Models in the name registry {}", modelNamesRegistry.modelsByName().keySet());
            ApiListingBuilder apiListingBuilder = new ApiListingBuilder(context.apiDescriptionOrdering()).apiVersion(documentationContext.getApiInfo().getVersion()).basePath(adjuster.adjustedPath("/")).resourcePath(resourcePath).produces(produces).consumes(consumes).host(host).protocols(protocols).securityReferences(securityReferences).apis(sortedApis).models(models).modelSpecifications(modelNamesRegistry.modelsByName()).modelNamesRegistry(modelNamesRegistry).position(position++).availableTags(documentationContext.getTags());
            ApiListingContext apiListingContext = new ApiListingContext(context.getDocumentationType(), resourceGroup, apiListingBuilder);
            apiListingMap.putIfAbsent(resourceGroup.getGroupName(), new LinkedList());
            ((List)apiListingMap.get(resourceGroup.getGroupName())).add(this.pluginsManager.apiListing(apiListingContext));
        }
        return apiListingMap;
    }

    private Predicate<ApiDescription> onlySelectedApis(DocumentationContext context) {
        return input -> context.getApiSelector().getPathSelector().test(input.getPath());
    }

    private Iterable<RequestMappingContext> sortedByMethods(List<RequestMappingContext> contexts) {
        return contexts.stream().sorted(Orderings.methodComparator()).collect(Collectors.toList());
    }
}

