/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.OperationNameGenerator;
import springfox.documentation.builders.OperationBuilder;
import springfox.documentation.service.Operation;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.operation.OperationReader;

@Component
@Qualifier(value="default")
public class ApiOperationReader
implements OperationReader {
    private static final Set<RequestMethod> REQUEST_METHODS = new LinkedHashSet<RequestMethod>(Arrays.asList(RequestMethod.values()));
    private final DocumentationPluginsManager pluginsManager;
    private final OperationNameGenerator nameGenerator;

    @Autowired
    public ApiOperationReader(DocumentationPluginsManager pluginsManager, OperationNameGenerator nameGenerator) {
        this.pluginsManager = pluginsManager;
        this.nameGenerator = nameGenerator;
    }

    @Override
    public List<Operation> read(RequestMappingContext outerContext) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        Set<RequestMethod> requestMethods = outerContext.getMethodsCondition();
        Set<RequestMethod> supportedMethods = this.supportedMethods(requestMethods);
        int currentCount = 0;
        for (RequestMethod httpRequestMethod : supportedMethods) {
            OperationContext operationContext = new OperationContext(new OperationBuilder(this.nameGenerator), httpRequestMethod, outerContext, currentCount);
            Operation operation = this.pluginsManager.operation(operationContext);
            if (operation.isHidden()) continue;
            operations.add(operation);
            ++currentCount;
        }
        operations.sort(outerContext.operationOrdering());
        return operations;
    }

    private Set<RequestMethod> supportedMethods(Set<RequestMethod> requestMethods) {
        return requestMethods == null || requestMethods.isEmpty() ? REQUEST_METHODS : requestMethods;
    }
}

