/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Link;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.builders.PropertySpecificationBuilder;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Xml;
import springfox.documentation.schema.property.ModelSpecificationFactory;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.SyntheticModelProviderPlugin;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spring.data.rest.schema.EmbeddedCollection;

class ResourcesModelProvider
implements SyntheticModelProviderPlugin {
    private final TypeResolver resolver;
    private final TypeNameExtractor typeNameExtractor;
    private final EnumTypeDeterminer enumTypeDeterminer;
    private final ModelSpecificationFactory modelSpecifications;

    ResourcesModelProvider(TypeResolver resolver, TypeNameExtractor typeNameExtractor, EnumTypeDeterminer enumTypeDeterminer, ModelSpecificationFactory modelSpecifications) {
        this.resolver = resolver;
        this.typeNameExtractor = typeNameExtractor;
        this.enumTypeDeterminer = enumTypeDeterminer;
        this.modelSpecifications = modelSpecifications;
    }

    @Override
    public Model create(ModelContext context) {
        ResolvedType resourceType = this.resourceType((Type)context.getType());
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        String name = this.typeNameExtractor.typeName(context);
        return context.getBuilder().description(String.format("Resources of %s", type.getSimpleName())).name(name).qualifiedType(type.getName()).type((ResolvedType)typeParameters.get(0)).properties(this.properties(context).stream().collect(Collectors.toMap(ModelProperty::getName, Function.identity()))).xml(new Xml().name("entities").wrapped(false).attribute(false)).build();
    }

    @Override
    public List<ModelProperty> properties(ModelContext context) {
        ResolvedType resourceType = this.resourceType((Type)context.getType());
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        ResolvedType embedded = this.resolver.resolve(EmbeddedCollection.class, new Type[]{type});
        ResolvedType mapOfLinks = this.resolver.resolve(Map.class, new Type[]{String.class, Link.class});
        return Stream.of(new ModelPropertyBuilder().name("_embedded").type(embedded).qualifiedType(embedded.getSignature()).position(0).required(true).isHidden(false).build().updateModelRef(ResolvedTypes.modelRefFactory(context, this.enumTypeDeterminer, this.typeNameExtractor)), new ModelPropertyBuilder().name("_links").type(mapOfLinks).qualifiedType(mapOfLinks.getSignature()).position(1).required(true).isHidden(false).description("Link collection").build().updateModelRef(ResolvedTypes.modelRefFactory(context, this.enumTypeDeterminer, this.typeNameExtractor))).collect(Collectors.toList());
    }

    @Override
    public ModelSpecification createModelSpecification(ModelContext context) {
        ResolvedType resourceType = this.resourceType((Type)context.getType());
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        String name = this.typeNameExtractor.typeName(context);
        return context.getModelSpecificationBuilder().name(name).facets(f -> f.description(String.format("Resources of %s", type.getSimpleName())).xml(new Xml().name("entities").wrapped(false).attribute(false))).compoundModel(cm -> cm.properties(this.propertySpecifications(context)).modelKey(m -> m.isResponse(context.isReturnType()).qualifiedModelName(q -> q.namespace("org.springframework.hateoas").name(name)).build())).build();
    }

    @Override
    public List<PropertySpecification> propertySpecifications(ModelContext context) {
        ResolvedType resourceType = this.resourceType((Type)context.getType());
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        ResolvedType embedded = this.resolver.resolve(EmbeddedCollection.class, new Type[]{type});
        ResolvedType mapOfLinks = this.resolver.resolve(Map.class, new Type[]{String.class, Link.class});
        ModelSpecification embeddedProperty = this.modelSpecifications.create(context, embedded);
        ModelSpecification mapOfLinksProperty = this.modelSpecifications.create(context, mapOfLinks);
        return Stream.of(new PropertySpecificationBuilder("_embedded").type(embeddedProperty).position(0).required(true).isHidden(false).build(), new PropertySpecificationBuilder("_links").type(mapOfLinksProperty).position(1).required(true).isHidden(false).description("Link collection").build()).collect(Collectors.toList());
    }

    @Override
    public Set<ResolvedType> dependencies(ModelContext context) {
        ResolvedType resourceType = this.resourceType((Type)context.getType());
        List typeParameters = resourceType.getTypeParameters();
        Class type = ((ResolvedType)typeParameters.get(0)).getErasedType();
        return Stream.of(this.resolver.resolve(EmbeddedCollection.class, new Type[]{type}), this.resolver.resolve(Link.class, new Type[0])).collect(Collectors.toSet());
    }

    @Override
    public boolean supports(ModelContext delimiter) {
        return CollectionModel.class.equals((Object)this.resourceType((Type)delimiter.getType()).getErasedType()) && (delimiter.getDocumentationType() == DocumentationType.SWAGGER_2 || delimiter.getDocumentationType() == DocumentationType.OAS_30);
    }

    private ResolvedType resourceType(Type type) {
        return this.resolver.resolve(type, new Type[0]);
    }
}

