/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spi.service.contexts;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.http.HttpMethod;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.SecurityContext;

public class SecurityContextBuilder {
    private List<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
    private Predicate<String> pathSelector = each -> true;
    private Predicate<HttpMethod> methodSelector = each -> true;
    private Predicate<OperationContext> operationSelector;

    public SecurityContextBuilder securityReferences(List<SecurityReference> securityReferences) {
        this.securityReferences.addAll(BuilderDefaults.nullToEmptyList(securityReferences));
        return this;
    }

    @Deprecated
    public SecurityContextBuilder forPaths(Predicate<String> selector) {
        this.pathSelector = BuilderDefaults.defaultIfAbsent(selector, this.pathSelector);
        return this;
    }

    @Deprecated
    public SecurityContextBuilder forHttpMethods(Predicate<HttpMethod> methodSelector) {
        this.methodSelector = BuilderDefaults.defaultIfAbsent(methodSelector, this.methodSelector);
        return this;
    }

    public SecurityContextBuilder operationSelector(Predicate<OperationContext> selector) {
        this.operationSelector = selector;
        return this;
    }

    public SecurityContext build() {
        if (this.securityReferences == null) {
            this.securityReferences = new ArrayList<SecurityReference>();
        }
        return new SecurityContext(this.securityReferences, this.pathSelector, this.methodSelector, this.operationSelector);
    }
}

