/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Collections;
import springfox.documentation.schema.Maps;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelDependencyProvider;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ModelProvider;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.Types;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.spi.schema.EnumTypeDeterminer;
import springfox.documentation.spi.schema.contexts.ModelContext;

@Component
@Qualifier(value="default")
@Deprecated
public class DefaultModelProvider
implements ModelProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultModelProvider.class);
    private final ModelPropertiesProvider propertiesProvider;
    private final ModelDependencyProvider dependencyProvider;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;
    private final EnumTypeDeterminer enumTypeDeterminer;

    @Autowired
    public DefaultModelProvider(@Qualifier(value="cachedModelProperties") ModelPropertiesProvider propertiesProvider, @Qualifier(value="cachedModelDependencies") ModelDependencyProvider dependencyProvider, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor, EnumTypeDeterminer enumTypeDeterminer) {
        this.propertiesProvider = propertiesProvider;
        this.dependencyProvider = dependencyProvider;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
        this.enumTypeDeterminer = enumTypeDeterminer;
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        ResolvedType propertiesHost = modelContext.alternateEvaluatedType();
        if (Collections.isContainerType(propertiesHost) || Maps.isMapType(propertiesHost) || this.enumTypeDeterminer.isEnum(propertiesHost.getErasedType()) || Types.isBaseType(propertiesHost) || modelContext.hasSeenBefore(propertiesHost)) {
            LOG.debug("Skipping model of type {} as its either a container type, map, enum or base type, or its already been handled", (Object)ResolvedTypes.resolvedTypeSignature(propertiesHost).orElse("<null>"));
            return Optional.empty();
        }
        Optional<Model> syntheticModel = this.schemaPluginsManager.syntheticModel(modelContext);
        if (syntheticModel.isPresent()) {
            return Optional.of(this.schemaPluginsManager.model(modelContext));
        }
        return this.reflectionBasedModel(modelContext, propertiesHost);
    }

    private Optional<Model> reflectionBasedModel(ModelContext modelContext, ResolvedType propertiesHost) {
        Map propertiesIndex = this.properties(modelContext, propertiesHost).stream().collect(Collectors.toMap(ModelProperty::getName, Function.identity()));
        LOG.debug("Inferred {} properties. Properties found {}", (Object)propertiesIndex.size(), (Object)String.join((CharSequence)", ", propertiesIndex.keySet()));
        return Optional.of(this.modelBuilder(propertiesHost, new TreeMap<String, ModelProperty>(propertiesIndex), modelContext));
    }

    private Model modelBuilder(ResolvedType propertiesHost, Map<String, ModelProperty> properties, ModelContext modelContext) {
        String typeName = this.typeNameExtractor.typeName(ModelContext.fromParent(modelContext, propertiesHost));
        modelContext.getBuilder().type(propertiesHost).name(typeName).qualifiedType(ResolvedTypes.simpleQualifiedTypeName(propertiesHost)).properties(properties).description("").baseModel("").discriminator("").subTypes(new ArrayList<ModelReference>());
        return this.schemaPluginsManager.model(modelContext);
    }

    @Override
    public Map<ResolvedType, Model> dependencies(ModelContext modelContext) {
        HashMap<ResolvedType, Model> models = new HashMap<ResolvedType, Model>();
        for (ResolvedType resolvedType : this.dependencyProvider.dependentModels(modelContext)) {
            ModelContext parentContext = ModelContext.fromParent(modelContext, resolvedType);
            Optional<Model> model = this.modelFor(parentContext);
            if (model.isPresent()) {
                models.put(resolvedType, model.get());
                continue;
            }
            model = this.mapModel(parentContext, resolvedType);
            model.ifPresent(m -> models.put(resolvedType, (Model)m));
        }
        return models;
    }

    private Optional<Model> mapModel(ModelContext parentContext, ResolvedType resolvedType) {
        if (Maps.isMapType(resolvedType) && !parentContext.hasSeenBefore(resolvedType)) {
            String typeName = this.typeNameExtractor.typeName(parentContext);
            return Optional.of(parentContext.getBuilder().type(resolvedType).name(typeName).qualifiedType(ResolvedTypes.simpleQualifiedTypeName(resolvedType)).properties(new HashMap<String, ModelProperty>()).description("").baseModel("").discriminator("").subTypes(new ArrayList<ModelReference>()).build());
        }
        return Optional.empty();
    }

    private List<ModelProperty> properties(ModelContext context, ResolvedType propertiesHost) {
        return this.propertiesProvider.propertiesFor(propertiesHost, context);
    }
}

