/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.oas.mappers;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.servers.ServerVariables;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mapstruct.AfterMapping;
import org.mapstruct.Context;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.oas.mappers.ExamplesMapper;
import springfox.documentation.oas.mappers.LicenseMapper;
import springfox.documentation.oas.mappers.SchemaMapper;
import springfox.documentation.oas.mappers.SecurityMapper;
import springfox.documentation.oas.mappers.SecuritySchemeMapper;
import springfox.documentation.oas.mappers.StyleEnumMapper;
import springfox.documentation.oas.mappers.VendorExtensionsMapper;
import springfox.documentation.schema.CollectionElementFacet;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.EnumerationFacet;
import springfox.documentation.schema.Example;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.schema.StringElementFacet;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.service.ParameterStyle;
import springfox.documentation.service.Representation;
import springfox.documentation.service.RequestParameter;
import springfox.documentation.service.Response;
import springfox.documentation.service.Server;
import springfox.documentation.service.ServerVariable;
import springfox.documentation.service.SimpleParameterSpecification;

@Mapper(componentModel="spring", uses={VendorExtensionsMapper.class, LicenseMapper.class, ExamplesMapper.class, SecurityMapper.class, SchemaMapper.class, StyleEnumMapper.class, SecuritySchemeMapper.class})
public abstract class ServiceModelToOpenApiMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceModelToOpenApiMapper.class);

    @Mappings(value={@Mapping(target="openapi", constant="3.0.3"), @Mapping(target="info", source="resourceListing.info"), @Mapping(target="externalDocs", source="externalDocumentation"), @Mapping(target="security", ignore=true), @Mapping(target="paths", source="apiListings", qualifiedByName={"PathsMapping"}), @Mapping(target="components.schemas", source="apiListings", qualifiedByName={"ModelsMapping"}), @Mapping(target="components.securitySchemes", source="resourceListing.securitySchemes"), @Mapping(target="extensions", source="vendorExtensions")})
    public abstract OpenAPI mapDocumentation(Documentation var1);

    @Mappings(value={@Mapping(target="operationId", source="uniqueId"), @Mapping(target="security", source="securityReferences"), @Mapping(target="extensions", source="vendorExtensions"), @Mapping(target="parameters", source="queryParameters"), @Mapping(target="requestBody", source="body"), @Mapping(target="description", source="notes"), @Mapping(target="callbacks", ignore=true), @Mapping(target="servers", ignore=true), @Mapping(target="externalDocs", ignore=true)})
    abstract Operation mapOperation(springfox.documentation.service.Operation var1, @Context ModelNamesRegistry var2);

    @Mappings(value={@Mapping(target="schema", source="parameterSpecification.query"), @Mapping(target="content", ignore=true), @Mapping(target="example", ignore=true), @Mapping(target="in", source="in.in"), @Mapping(target="allowEmptyValue", expression="java(from.getParameterSpecification().getQuery().map(q -> q.getAllowEmptyValue()).orElse(null))"), @Mapping(target="style", expression="java(from.getParameterSpecification().getQuery().map(q -> parameterStyle(q.getStyle())).orElse(null))"), @Mapping(target="explode", expression="java(from.getParameterSpecification().getQuery().map(q -> q.getExplode()).orElse(null))"), @Mapping(target="allowReserved", expression="java(from.getParameterSpecification().getQuery().map(q -> q.getAllowReserved()).orElse(null))"), @Mapping(target="$ref", ignore=true)})
    abstract Parameter mapParameter(RequestParameter var1, @Context ModelNamesRegistry var2);

    @AfterMapping
    public void afterMappingParameter(RequestParameter from, @MappingTarget Parameter target) {
        from.getParameterSpecification().getQuery().ifPresent(query -> {
            for (ElementFacet facet : query.getFacets()) {
                if (facet instanceof NumericElementFacet) {
                    target.getSchema().maximum(((NumericElementFacet)facet).getMaximum());
                    target.getSchema().minimum(((NumericElementFacet)facet).getMinimum());
                    target.getSchema().exclusiveMaximum(((NumericElementFacet)facet).getExclusiveMaximum());
                    target.getSchema().exclusiveMinimum(((NumericElementFacet)facet).getExclusiveMinimum());
                    continue;
                }
                if (facet instanceof EnumerationFacet) {
                    target.getSchema().setEnum(((EnumerationFacet)facet).getAllowedValues());
                    continue;
                }
                if (facet instanceof StringElementFacet) {
                    target.getSchema().setPattern(((StringElementFacet)facet).getPattern());
                    target.getSchema().setMaxLength(((StringElementFacet)facet).getMaxLength());
                    target.getSchema().setMinLength(((StringElementFacet)facet).getMinLength());
                    continue;
                }
                if (!(facet instanceof CollectionElementFacet)) continue;
                target.getSchema().minItems(((CollectionElementFacet)facet).getMinItems());
                target.getSchema().maxItems(((CollectionElementFacet)facet).getMaxItems());
                target.getSchema().uniqueItems(((CollectionElementFacet)facet).getUniqueItems());
            }
        });
    }

    protected Parameter.StyleEnum parameterStyle(ParameterStyle from) {
        if (from != null) {
            return Parameter.StyleEnum.valueOf(from.name());
        }
        return null;
    }

    protected Schema fromSimpleParameter(Optional<SimpleParameterSpecification> value, @Context ModelNamesRegistry modelNamesRegistry) {
        return value.map((? super T s) -> Mappers.getMapper(SchemaMapper.class).mapModel(s.getModel(), modelNamesRegistry)).orElse(null);
    }

    protected ApiResponses map(Set<Response> from, @Context ModelNamesRegistry modelNamesRegistry) {
        ApiResponses responses = new ApiResponses();
        for (Response each : from) {
            ApiResponse response = new ApiResponse().description(each.getDescription());
            Content content = new Content();
            ExamplesMapper exampleMapper = Mappers.getMapper(ExamplesMapper.class);
            LinkedMultiValueMap examplesByMediaType = new LinkedMultiValueMap();
            for (Example example : each.getExamples()) {
                examplesByMediaType.add((Object)example.getMediaType().orElse("*/*"), (Object)example);
            }
            Map representations = each.getRepresentations().stream().collect(Collectors.toMap(e -> e.getMediaType().toString(), Function.identity(), (o1, o2) -> o1, TreeMap::new));
            HashSet mediaTypes = new HashSet(representations.keySet());
            mediaTypes.addAll(examplesByMediaType.keySet());
            for (String eachMediaType : mediaTypes) {
                MediaType mediaType = this.fromRepresentation(representations.getOrDefault(eachMediaType, null), modelNamesRegistry);
                if (mediaType == null) {
                    mediaType = new MediaType();
                }
                mediaType.examples(exampleMapper.mapExamples(BuilderDefaults.nullToEmptyList((Collection)examplesByMediaType.get((Object)eachMediaType))));
                content.addMediaType(eachMediaType, mediaType);
            }
            response.setContent(content);
            response.setHeaders(this.fromHeaders(each.getHeaders(), modelNamesRegistry));
            new VendorExtensionsMapper().mapExtensions(each.getVendorExtensions()).forEach(response::addExtension);
            responses.put(String.valueOf(each.getCode()), response);
        }
        return responses;
    }

    protected RequestBody map(springfox.documentation.service.RequestBody from, @Context ModelNamesRegistry modelNamesRegistry) {
        if (from == null) {
            return null;
        }
        RequestBody mapped = new RequestBody();
        Content content = new Content();
        for (Representation representation : from.getRepresentations()) {
            content.addMediaType(representation.getMediaType().toString(), this.fromRepresentation(representation, modelNamesRegistry));
        }
        mapped.content(content);
        return mapped;
    }

    @Named(value="PathsMapping")
    Paths mapPaths(Map<String, List<ApiListing>> apiListings) {
        Paths paths = new Paths();
        apiListings.values().stream().flatMap(Collection::stream).forEachOrdered(each -> {
            for (ApiDescription api : each.getApis()) {
                paths.addPathItem(api.getPath(), this.mapOperations(api, (PathItem)paths.get(api.getPath()), each.getModelNamesRegistry()));
            }
        });
        return paths;
    }

    private PathItem mapOperations(ApiDescription api, PathItem existingPath, ModelNamesRegistry modelNamesRegistry) {
        PathItem path = existingPath;
        if (existingPath == null) {
            path = new PathItem();
        }
        for (springfox.documentation.service.Operation each : BuilderDefaults.nullToEmptyList(api.getOperations())) {
            LOGGER.debug("Mapping operation {}", (Object)api.getPath());
            Operation operation = this.mapOperation(each, modelNamesRegistry);
            path.operation(this.mapHttpMethod(each.getMethod()), operation);
        }
        return path;
    }

    abstract PathItem.HttpMethod mapHttpMethod(HttpMethod var1);

    private Content map(SortedSet<Representation> value, ModelNamesRegistry modelNamesRegistry) {
        Content content = new Content();
        for (Representation each : value) {
            content.addMediaType(each.getMediaType().toString(), this.fromRepresentation(each, modelNamesRegistry));
        }
        return content;
    }

    @Mappings(value={@Mapping(target="schema", source="model", qualifiedByName={"ModelsMapping"}), @Mapping(target="encoding", source="encodings"), @Mapping(target="examples", ignore=true), @Mapping(target="example", ignore=true), @Mapping(target="extensions", source="model.facetExtensions")})
    protected abstract MediaType fromRepresentation(Representation var1, @Context ModelNamesRegistry var2);

    protected Map<String, Encoding> fromEncodings(Collection<springfox.documentation.service.Encoding> encodings, @Context ModelNamesRegistry namesRegistry) {
        return encodings.stream().collect(Collectors.toMap(springfox.documentation.service.Encoding::getPropertyRef, e -> this.mapEncoding((springfox.documentation.service.Encoding)e, namesRegistry)));
    }

    @Mappings(value={@Mapping(target="style", source="style", qualifiedByName={"StyleEnumSelector", "EncodingStyleEnum"})})
    protected abstract Encoding mapEncoding(springfox.documentation.service.Encoding var1, @Context ModelNamesRegistry var2);

    protected Map<String, Header> fromHeaders(Collection<springfox.documentation.service.Header> headers, @Context ModelNamesRegistry modelNamesRegistry) {
        return headers.stream().collect(Collectors.toMap(springfox.documentation.service.Header::getName, h -> this.mapHeader((springfox.documentation.service.Header)h, modelNamesRegistry)));
    }

    @Mappings(value={@Mapping(target="style", ignore=true), @Mapping(target="deprecated", ignore=true), @Mapping(target="explode", ignore=true), @Mapping(target="schema", source="modelSpecification"), @Mapping(target="required", source="required"), @Mapping(target="examples", ignore=true), @Mapping(target="example", ignore=true), @Mapping(target="content", ignore=true), @Mapping(target="extensions", ignore=true), @Mapping(target="$ref", ignore=true)})
    protected abstract Header mapHeader(springfox.documentation.service.Header var1, @Context ModelNamesRegistry var2);

    @Mappings(value={@Mapping(target="license", source="from", qualifiedBy={LicenseMapper.LicenseTranslator.class, LicenseMapper.License.class}), @Mapping(target="contact", source="from.contact"), @Mapping(target="termsOfService", source="termsOfServiceUrl"), @Mapping(target="extensions", source="vendorExtensions")})
    protected abstract Info mapApiInfo(ApiInfo var1);

    @Mappings(value={@Mapping(target="extensions", ignore=true)})
    protected abstract io.swagger.v3.oas.models.info.Contact map(Contact var1);

    @Mappings(value={@Mapping(target="externalDocs", ignore=true), @Mapping(target="extensions", source="vendorExtensions")})
    protected abstract Tag mapTag(springfox.documentation.service.Tag var1);

    @Mappings(value={@Mapping(target="extensions", source="extensions")})
    protected abstract io.swagger.v3.oas.models.servers.Server mapServer(Server var1);

    protected ServerVariables serverVariableMap(Collection<ServerVariable> serverVariables) {
        ServerVariables variables = new ServerVariables();
        variables.putAll(serverVariables.stream().collect(Collectors.toMap(ServerVariable::getName, this::mapServerVariable)));
        return variables;
    }

    @Mappings(value={@Mapping(target="enum", source="allowedValues"), @Mapping(target="default", source="defaultValue"), @Mapping(target="_enum", ignore=true), @Mapping(target="_default", ignore=true)})
    protected abstract io.swagger.v3.oas.models.servers.ServerVariable mapServerVariable(ServerVariable var1);

    protected abstract ExternalDocumentation mapExternalDocs(springfox.documentation.common.ExternalDocumentation var1);
}

