/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.shaded.parquet.it.unimi.dsi.fastutil.floats;

import java.util.Comparator;
import java.util.List;
import shadedelta.shaded.parquet.it.unimi.dsi.fastutil.floats.FloatArrays;
import shadedelta.shaded.parquet.it.unimi.dsi.fastutil.floats.FloatCollection;
import shadedelta.shaded.parquet.it.unimi.dsi.fastutil.floats.FloatComparator;
import shadedelta.shaded.parquet.it.unimi.dsi.fastutil.floats.FloatComparators;
import shadedelta.shaded.parquet.it.unimi.dsi.fastutil.floats.FloatListIterator;

public interface FloatList
extends List<Float>,
Comparable<List<? extends Float>>,
FloatCollection {
    @Override
    public FloatListIterator iterator();

    public FloatListIterator listIterator();

    public FloatListIterator listIterator(int var1);

    public FloatList subList(int var1, int var2);

    public void size(int var1);

    public void getElements(int var1, float[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    public void addElements(int var1, float[] var2);

    public void addElements(int var1, float[] var2, int var3, int var4);

    default public void setElements(float[] a) {
        this.setElements(0, a);
    }

    default public void setElements(int index, float[] a) {
        this.setElements(index, a, 0, a.length);
    }

    default public void setElements(int index, float[] a, int offset, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        FloatArrays.ensureOffsetLength(a, offset, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        FloatListIterator iter = this.listIterator(index);
        int i = 0;
        while (i < length) {
            iter.nextFloat();
            iter.set(a[offset + i++]);
        }
    }

    @Override
    public boolean add(float var1);

    @Override
    public void add(int var1, float var2);

    @Override
    @Deprecated
    default public void add(int index, Float key) {
        this.add(index, key.floatValue());
    }

    public boolean addAll(int var1, FloatCollection var2);

    public boolean addAll(int var1, FloatList var2);

    public boolean addAll(FloatList var1);

    @Override
    public float set(int var1, float var2);

    public float getFloat(int var1);

    public int indexOf(float var1);

    public int lastIndexOf(float var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return FloatCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Float get(int index) {
        return Float.valueOf(this.getFloat(index));
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf(((Float)o).floatValue());
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf(((Float)o).floatValue());
    }

    @Override
    @Deprecated
    default public boolean add(Float k) {
        return this.add(k.floatValue());
    }

    public float removeFloat(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return FloatCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Float remove(int index) {
        return Float.valueOf(this.removeFloat(index));
    }

    @Override
    @Deprecated
    default public Float set(int index, Float k) {
        return Float.valueOf(this.set(index, k.floatValue()));
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Float> comparator) {
        this.sort(FloatComparators.asFloatComparator(comparator));
    }

    default public void sort(FloatComparator comparator) {
        float[] elements = this.toFloatArray();
        if (comparator == null) {
            FloatArrays.stableSort(elements);
        } else {
            FloatArrays.stableSort(elements, comparator);
        }
        this.setElements(elements);
    }

    @Deprecated
    default public void unstableSort(Comparator<? super Float> comparator) {
        this.unstableSort(FloatComparators.asFloatComparator(comparator));
    }

    default public void unstableSort(FloatComparator comparator) {
        float[] elements = this.toFloatArray();
        if (comparator == null) {
            FloatArrays.unstableSort(elements);
        } else {
            FloatArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

