/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.column.impl;

import java.io.IOException;
import shadedelta.org.apache.parquet.bytes.BytesInput;
import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.column.ParquetProperties;
import shadedelta.org.apache.parquet.column.impl.ColumnWriterBase;
import shadedelta.org.apache.parquet.column.page.PageWriter;
import shadedelta.org.apache.parquet.column.statistics.Statistics;
import shadedelta.org.apache.parquet.column.values.ValuesWriter;
import shadedelta.org.apache.parquet.column.values.bloomfilter.BloomFilterWriter;

final class ColumnWriterV1
extends ColumnWriterBase {
    ColumnWriterV1(ColumnDescriptor path, PageWriter pageWriter, ParquetProperties props) {
        super(path, pageWriter, props);
    }

    public ColumnWriterV1(ColumnDescriptor path, PageWriter pageWriter, BloomFilterWriter bloomFilterWriter, ParquetProperties props) {
        super(path, pageWriter, bloomFilterWriter, props);
    }

    @Override
    ValuesWriter createRLWriter(ParquetProperties props, ColumnDescriptor path) {
        return props.newRepetitionLevelWriter(path);
    }

    @Override
    ValuesWriter createDLWriter(ParquetProperties props, ColumnDescriptor path) {
        return props.newDefinitionLevelWriter(path);
    }

    @Override
    void writePage(int rowCount, int valueCount, Statistics<?> statistics, ValuesWriter repetitionLevels, ValuesWriter definitionLevels, ValuesWriter values) throws IOException {
        this.pageWriter.writePage(BytesInput.concat(repetitionLevels.getBytes(), definitionLevels.getBytes(), values.getBytes()), valueCount, rowCount, statistics, repetitionLevels.getEncoding(), definitionLevels.getEncoding(), values.getEncoding());
    }
}

