/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.types;

import io.delta.standalone.internal.util.DataTypeParser;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.StructType;
import java.util.Locale;
import java.util.Objects;

public abstract class DataType {
    public static DataType fromJson(String string) {
        return DataTypeParser.fromJson(string);
    }

    public String getTypeName() {
        String string = this.getClass().getSimpleName();
        string = this.stripSuffix(string, "$");
        string = this.stripSuffix(string, "Type");
        string = this.stripSuffix(string, "UDT");
        return string.toLowerCase(Locale.ROOT);
    }

    public String getSimpleString() {
        return this.getTypeName();
    }

    public String getCatalogString() {
        return this.getSimpleString();
    }

    public String toJson() {
        return DataTypeParser.toJson(this);
    }

    public String toPrettyJson() {
        return DataTypeParser.toPrettyJson(this);
    }

    protected static void buildFormattedString(DataType dataType, String string, StringBuilder stringBuilder) {
        if (dataType instanceof ArrayType) {
            ((ArrayType)dataType).buildFormattedString(string, stringBuilder);
        }
        if (dataType instanceof StructType) {
            ((StructType)dataType).buildFormattedString(string, stringBuilder);
        }
        if (dataType instanceof MapType) {
            ((MapType)dataType).buildFormattedString(string, stringBuilder);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DataType dataType = (DataType)object;
        return this.getTypeName().equals(dataType.getTypeName());
    }

    public boolean equivalent(DataType dataType) {
        return this.equals(dataType);
    }

    public int hashCode() {
        return Objects.hash(this.getTypeName());
    }

    private String stripSuffix(String string, String string2) {
        if (null != string && string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }
}

