/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.CommitResult;
import io.delta.standalone.DeltaScan;
import io.delta.standalone.Operation;
import io.delta.standalone.OptimisticTransaction;
import io.delta.standalone.exceptions.DeltaStandaloneException;
import io.delta.standalone.expressions.Expression;
import io.delta.standalone.expressions.Literal;
import io.delta.standalone.internal.ConflictChecker;
import io.delta.standalone.internal.CurrentTransactionInfo;
import io.delta.standalone.internal.DeltaConfigs$;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.IsolationLevel;
import io.delta.standalone.internal.Serializable$;
import io.delta.standalone.internal.SnapshotImpl;
import io.delta.standalone.internal.SnapshotIsolation$;
import io.delta.standalone.internal.actions.Action;
import io.delta.standalone.internal.actions.AddFile;
import io.delta.standalone.internal.actions.CommitInfo;
import io.delta.standalone.internal.actions.CommitInfo$;
import io.delta.standalone.internal.actions.FileAction;
import io.delta.standalone.internal.actions.Format;
import io.delta.standalone.internal.actions.Metadata;
import io.delta.standalone.internal.actions.Protocol;
import io.delta.standalone.internal.actions.Protocol$;
import io.delta.standalone.internal.actions.RemoveFile;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.scan.DeltaScanImpl;
import io.delta.standalone.internal.util.ConversionUtils$;
import io.delta.standalone.internal.util.DeltaFileOperations$;
import io.delta.standalone.internal.util.FileNames$;
import io.delta.standalone.internal.util.SchemaMergingUtils$;
import io.delta.standalone.internal.util.SchemaUtils$;
import io.delta.standalone.package$;
import io.delta.standalone.types.StructType;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashSet;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rh!\u0002\u001e<\u0001m\u001a\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011q\u0003!\u0011!Q\u0001\nuCQ\u0001\u0019\u0001\u0005\u0002\u0005Dq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004n\u0001\u0001\u0006Ia\u001a\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0011\u0019\u0019\b\u0001)A\u0005a\"9A\u000f\u0001b\u0001\n\u0013)\bbBA\t\u0001\u0001\u0006IA\u001e\u0005\n\u0003'\u0001!\u0019!C\u0005\u0003+A\u0001\"!\n\u0001A\u0003%\u0011q\u0003\u0005\n\u0003O\u0001!\u0019!C\u0005\u0003SA\u0001\"!\u0010\u0001A\u0003%\u00111\u0006\u0005\n\u0003\u007f\u0001\u0001\u0019!C\u0005\u0003\u0003B\u0011\"!\u0013\u0001\u0001\u0004%I!a\u0013\t\u0011\u0005]\u0003\u0001)Q\u0005\u0003\u0007B\u0011\"!\u0017\u0001\u0001\u0004%I!!\u0011\t\u0013\u0005m\u0003\u00011A\u0005\n\u0005u\u0003\u0002CA1\u0001\u0001\u0006K!a\u0011\t\u0013\u0005\r\u0004\u00011A\u0005\n\u0005\u0015\u0004\"CA:\u0001\u0001\u0007I\u0011BA;\u0011!\tI\b\u0001Q!\n\u0005\u001d\u0004\"CA>\u0001\u0001\u0007I\u0011BA?\u0011%\t9\t\u0001a\u0001\n\u0013\tI\t\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0015BA@\u0011%\ty\t\u0001a\u0001\n\u0013\t\t\u0005C\u0005\u0002\u0012\u0002\u0001\r\u0011\"\u0003\u0002\u0014\"A\u0011q\u0013\u0001!B\u0013\t\u0019\u0005C\u0006\u0002\u001a\u0002\u0001\r\u00111A\u0005\n\u0005m\u0005bCAR\u0001\u0001\u0007\t\u0019!C\u0005\u0003KC1\"!+\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u001e\"9\u00111\u0016\u0001\u0005\u0002\u00055\u0006bBAX\u0001\u0011\u0005\u0011\u0011\u0017\u0005\b\u0003g\u0003A\u0011IA[\u0011\u001d\ty\f\u0001C!\u0003\u0003Dq!!?\u0001\t\u0003\nY\u0010C\u0004\u0003\b\u0001!\tE!\u0003\t\u000f\t=\u0001\u0001\"\u0011\u0003\u0012!9!1\u0003\u0001\u0005B\tU\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011\u001d\u0011Y\u0004\u0001C\t\u0005{AqAa\u0014\u0001\t\u0013\u0011\t\u0006C\u0004\u0003Z\u0001!IAa\u0017\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!1\u000f\u0001\u0005\n\tU\u0004b\u0002B=\u0001\u0011%!1\u0010\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u0011\t\u000b\u0001C\u0005\u0005GCqA!+\u0001\t\u0013\tY\nC\u0004\u0003,\u0002!IA!,\t\u0015\tE\u0006\u0001#b\u0001\n#\u0011\u0019\fC\u0004\u00036\u0002!\tEa.\t\u000f\t\r\u0007\u0001\"\u0011\u0003F\"9!1\u0019\u0001\u0005B\t%\u0007b\u0002Bl\u0001\u0011\u0005#\u0011\u001c\u0005\b\u0005/\u0004A\u0011\tBo\u0005ey\u0005\u000f^5nSN$\u0018n\u0019+sC:\u001c\u0018m\u0019;j_:LU\u000e\u001d7\u000b\u0005qj\u0014\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005yz\u0014AC:uC:$\u0017\r\\8oK*\u0011\u0001)Q\u0001\u0006I\u0016dG/\u0019\u0006\u0002\u0005\u0006\u0011\u0011n\\\n\u0005\u0001\u0011c\u0005\u000b\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!A.\u00198h\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\r=\u0013'.Z2u!\tie*D\u0001>\u0013\tyUHA\u000bPaRLW.[:uS\u000e$&/\u00198tC\u000e$\u0018n\u001c8\u0011\u0005E#V\"\u0001*\u000b\u0005M[\u0014a\u00027pO\u001eLgnZ\u0005\u0003+J\u0013q\u0001T8hO&tw-\u0001\u0005eK2$\u0018\rT8h\u0007\u0001\u0001\"!\u0017.\u000e\u0003mJ!aW\u001e\u0003\u0019\u0011+G\u000e^1M_\u001eLU\u000e\u001d7\u0002\u0011Mt\u0017\r]:i_R\u0004\"!\u00170\n\u0005}[$\u0001D*oCB\u001c\bn\u001c;J[Bd\u0017A\u0002\u001fj]&$h\bF\u0002cG\u0012\u0004\"!\u0017\u0001\t\u000bY\u001b\u0001\u0019\u0001-\t\u000bq\u001b\u0001\u0019A/\u0002?\u0011+E\nV!`\u001b\u0006CvLU#U%f{6iT'N\u0013R{\u0016\t\u0016+F\u001bB#6+F\u0001h!\tA7.D\u0001j\u0015\u0005Q\u0017!B:dC2\f\u0017B\u00017j\u0005\rIe\u000e^\u0001!\t\u0016cE+Q0N\u0003b{&+\u0012+S3~\u001bu*T'J)~\u000bE\u000bV#N!R\u001b\u0006%A\u0003uq:LE-F\u0001q!\t)\u0015/\u0003\u0002s\r\n11\u000b\u001e:j]\u001e\fa\u0001\u001e=o\u0013\u0012\u0004\u0013a\u0002:fC\u0012$\u0006P\\\u000b\u0002mB\u0019q\u000f @\u000e\u0003aT!!\u001f>\u0002\u000f5,H/\u00192mK*\u001110[\u0001\u000bG>dG.Z2uS>t\u0017BA?y\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007}\fiA\u0004\u0003\u0002\u0002\u0005%\u0001cAA\u0002S6\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f9\u0016A\u0002\u001fs_>$h(C\u0002\u0002\f%\fa\u0001\u0015:fI\u00164\u0017b\u0001:\u0002\u0010)\u0019\u00111B5\u0002\u0011I,\u0017\r\u001a+y]\u0002\naB]3bIB\u0013X\rZ5dCR,7/\u0006\u0002\u0002\u0018A!q\u000f`A\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010{\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\t\u0019#!\b\u0003\u0015\u0015C\bO]3tg&|g.A\bsK\u0006$\u0007K]3eS\u000e\fG/Z:!\u0003%\u0011X-\u00193GS2,7/\u0006\u0002\u0002,A)q/!\f\u00022%\u0019\u0011q\u0006=\u0003\u000f!\u000b7\u000f[*fiB!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028m\nq!Y2uS>t7/\u0003\u0003\u0002<\u0005U\"aB!eI\u001aKG.Z\u0001\u000be\u0016\fGMR5mKN\u0004\u0013!\u0005:fC\u0012$\u0006.Z,i_2,G+\u00192mKV\u0011\u00111\t\t\u0004Q\u0006\u0015\u0013bAA$S\n9!i\\8mK\u0006t\u0017!\u0006:fC\u0012$\u0006.Z,i_2,G+\u00192mK~#S-\u001d\u000b\u0005\u0003\u001b\n\u0019\u0006E\u0002i\u0003\u001fJ1!!\u0015j\u0005\u0011)f.\u001b;\t\u0013\u0005Us\"!AA\u0002\u0005\r\u0013a\u0001=%c\u0005\u0011\"/Z1e)\",w\u000b[8mKR\u000b'\r\\3!\u0003%\u0019w.\\7jiR,G-A\u0007d_6l\u0017\u000e\u001e;fI~#S-\u001d\u000b\u0005\u0003\u001b\ny\u0006C\u0005\u0002VI\t\t\u00111\u0001\u0002D\u0005Q1m\\7nSR$X\r\u001a\u0011\u0002\u00179,w/T3uC\u0012\fG/Y\u000b\u0003\u0003O\u0002R\u0001[A5\u0003[J1!a\u001bj\u0005\u0019y\u0005\u000f^5p]B!\u00111GA8\u0013\u0011\t\t(!\u000e\u0003\u00115+G/\u00193bi\u0006\fqB\\3x\u001b\u0016$\u0018\rZ1uC~#S-\u001d\u000b\u0005\u0003\u001b\n9\bC\u0005\u0002VU\t\t\u00111\u0001\u0002h\u0005aa.Z<NKR\fG-\u0019;bA\u0005Ya.Z<Qe>$xnY8m+\t\ty\bE\u0003i\u0003S\n\t\t\u0005\u0003\u00024\u0005\r\u0015\u0002BAC\u0003k\u0011\u0001\u0002\u0015:pi>\u001cw\u000e\\\u0001\u0010]\u0016<\bK]8u_\u000e|Gn\u0018\u0013fcR!\u0011QJAF\u0011%\t)\u0006GA\u0001\u0002\u0004\ty(\u0001\u0007oK^\u0004&o\u001c;pG>d\u0007%\u0001\njg\u000e\u0013X-\u0019;j]\u001etUm\u001e+bE2,\u0017AF5t\u0007J,\u0017\r^5oO:+w\u000fV1cY\u0016|F%Z9\u0015\t\u00055\u0013Q\u0013\u0005\n\u0003+Z\u0012\u0011!a\u0001\u0003\u0007\n1#[:De\u0016\fG/\u001b8h\u001d\u0016<H+\u00192mK\u0002\nacY8n[&$\u0018\t\u001e;f[B$8\u000b^1siRKW.Z\u000b\u0003\u0003;\u00032\u0001[AP\u0013\r\t\t+\u001b\u0002\u0005\u0019>tw-\u0001\u000ed_6l\u0017\u000e^!ui\u0016l\u0007\u000f^*uCJ$H+[7f?\u0012*\u0017\u000f\u0006\u0003\u0002N\u0005\u001d\u0006\"CA+=\u0005\u0005\t\u0019AAO\u0003]\u0019w.\\7ji\u0006#H/Z7qiN#\u0018M\u001d;US6,\u0007%\u0001\u0005qe>$xnY8m+\t\t\t)A\u0007nKR\fG-\u0019;b'\u000e\fG.Y\u000b\u0003\u0003[\n\u0001\"\\3uC\u0012\fG/\u0019\u000b\u0003\u0003o\u0003B!!/\u0002>6\u0011\u00111\u0018\u0006\u0004\u0003oi\u0014\u0002BA9\u0003w\u000baaY8n[&$X\u0003BAb\u00033$\u0002\"!2\u0002L\u0006-\u0018Q\u001f\t\u0004\u001b\u0006\u001d\u0017bAAe{\ta1i\\7nSR\u0014Vm];mi\"9\u0011QZ\u0012A\u0002\u0005=\u0017\u0001C1di&|gn\u001d&\u0011\u000b\u0015\u000b\t.!6\n\u0007\u0005MgI\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\t9.!7\r\u0001\u00119\u00111\\\u0012C\u0002\u0005u'!\u0001+\u0012\t\u0005}\u0017Q\u001d\t\u0004Q\u0006\u0005\u0018bAArS\n9aj\u001c;iS:<\u0007\u0003BA]\u0003OLA!!;\u0002<\n1\u0011i\u0019;j_:Dq!!<$\u0001\u0004\ty/\u0001\u0002paB\u0019Q*!=\n\u0007\u0005MXHA\u0005Pa\u0016\u0014\u0018\r^5p]\"1\u0011q_\u0012A\u0002y\f!\"\u001a8hS:,\u0017J\u001c4p\u0003=i\u0017M]6GS2,7/Q:SK\u0006$G\u0003BA\u007f\u0005\u0007\u00012!TA\u0000\u0013\r\u0011\t!\u0010\u0002\n\t\u0016dG/Y*dC:DqA!\u0002%\u0001\u0004\tI\"A\u0007sK\u0006$\u0007K]3eS\u000e\fG/Z\u0001\u000fkB$\u0017\r^3NKR\fG-\u0019;b)\u0011\tiEa\u0003\t\u000f\t5Q\u00051\u0001\u00028\u0006IQ.\u001a;bI\u0006$\u0018MS\u0001\u000fe\u0016\fGm\u00165pY\u0016$\u0016M\u00197f)\t\ti%\u0001\u0006uq:4VM]:j_:$B!!(\u0003\u0018!1!\u0011D\u0014A\u0002y\f!!\u001b3\u0002\u0017I,\u0017\r\u001a,feNLwN\u001c\u000b\u0003\u0003;\u000bQ\u0002\u001d:fa\u0006\u0014XmQ8n[&$H\u0003\u0002B\u0012\u0005s\u0001bA!\n\u00030\tUb\u0002\u0002B\u0014\u0005WqA!a\u0001\u0003*%\t!.C\u0002\u0003.%\fq\u0001]1dW\u0006<W-\u0003\u0003\u00032\tM\"aA*fc*\u0019!QF5\u0011\t\u0005M\"qG\u0005\u0005\u0003S\f)\u0004C\u0004\u00028%\u0002\rAa\t\u00021\u0011|7i\\7nSR\u0014V\r\u001e:z\u0013R,'/\u0019;jm\u0016d\u0017\u0010\u0006\u0005\u0002\u001e\n}\"1\tB#\u0011\u001d\u0011\tE\u000ba\u0001\u0003;\u000ba\"\u0019;uK6\u0004HOV3sg&|g\u000eC\u0004\u00028)\u0002\rAa\t\t\u000f\t\u001d#\u00061\u0001\u0003J\u0005q\u0011n]8mCRLwN\u001c'fm\u0016d\u0007cA-\u0003L%\u0019!QJ\u001e\u0003\u001d%\u001bx\u000e\\1uS>tG*\u001a<fY\u0006AAm\\\"p[6LG\u000f\u0006\u0005\u0002\u001e\nM#Q\u000bB,\u0011\u001d\u0011\te\u000ba\u0001\u0003;Cq!a\u000e,\u0001\u0004\u0011\u0019\u0003C\u0004\u0003H-\u0002\rA!\u0013\u0002\u0015A|7\u000f^\"p[6LG\u000f\u0006\u0003\u0002N\tu\u0003b\u0002B0Y\u0001\u0007\u0011QT\u0001\u000eG>lW.\u001b;WKJ\u001c\u0018n\u001c8\u0002#\rDWmY6G_J\u001cuN\u001c4mS\u000e$8\u000f\u0006\u0006\u0002\u001e\n\u0015$\u0011\u000eB6\u0005_BqAa\u001a.\u0001\u0004\ti*\u0001\u0007dQ\u0016\u001c7NV3sg&|g\u000eC\u0004\u000285\u0002\rAa\t\t\r\t5T\u00061\u0001h\u00035\tG\u000f^3naRtU/\u001c2fe\"9!\u0011O\u0017A\u0002\t%\u0013\u0001F2p[6LG/S:pY\u0006$\u0018n\u001c8MKZ,G.A\twKJLg-\u001f(fo6+G/\u00193bi\u0006$B!!\u0014\u0003x!9\u00111\u0017\u0018A\u0002\u00055\u0014!F2iK\u000e\\\u0007+\u0019:uSRLwN\\\"pYVlgn\u001d\u000b\u0007\u0003\u001b\u0012iHa!\t\u000f\t}t\u00061\u0001\u0003\u0002\u0006i\u0001/\u0019:uSRLwN\\\"pYN\u0004RA!\n\u00030yDqA!\"0\u0001\u0004\u00119)\u0001\u0004tG\",W.\u0019\t\u0005\u0005\u0013\u0013y)\u0004\u0002\u0003\f*\u0019!QR\u001f\u0002\u000bQL\b/Z:\n\t\tE%1\u0012\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017!\u0007<fe&4\u0017pU2iK6\f7i\\7qCRL'-\u001b7jif$\u0002\"!\u0014\u0003\u0018\nm%q\u0014\u0005\b\u00053\u0003\u0004\u0019\u0001BD\u00039)\u00070[:uS:<7k\u00195f[\u0006DqA!(1\u0001\u0004\u00119)A\u0005oK^\u001c6\r[3nC\"9\u0011q\u0007\u0019A\u0002\t\r\u0012\u0001E:i_VdGm\u00115fG.\u0004x.\u001b8u)\u0011\t\u0019E!*\t\u000f\t\u001d\u0016\u00071\u0001\u0002\u001e\u0006\u00012m\\7nSR$X\r\u001a,feNLwN\\\u0001\u0016O\u0016$h*\u001a=u\u0003R$X-\u001c9u-\u0016\u00148/[8o\u0003a9\u0018\u000e\u001e5HY>\u0014\u0017\r\\\"p]\u001aLw\rR3gCVdGo\u001d\u000b\u0005\u0003[\u0012y\u000bC\u0004\u00024N\u0002\r!!\u001c\u0002\u00131|w\r\u0015:fM&DX#\u0001@\u0002\u000f1|w-\u00138g_R!\u0011Q\nB]\u0011!\u0011Y,\u000eCA\u0002\tu\u0016aA7tOB!\u0001Na0\u007f\u0013\r\u0011\t-\u001b\u0002\ty\tLh.Y7f}\u0005QAn\\4XCJt\u0017N\\4\u0015\t\u00055#q\u0019\u0005\t\u0005w3D\u00111\u0001\u0003>R1\u0011Q\nBf\u0005\u001bD\u0001Ba/8\t\u0003\u0007!Q\u0018\u0005\b\u0005\u001f<\u0004\u0019\u0001Bi\u0003%!\bN]8xC\ndW\r\u0005\u0003\u0003&\tM\u0017\u0002\u0002Bk\u0005g\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0002\u00111|w-\u0012:s_J$B!!\u0014\u0003\\\"A!1\u0018\u001d\u0005\u0002\u0004\u0011i\f\u0006\u0004\u0002N\t}'\u0011\u001d\u0005\t\u0005wKD\u00111\u0001\u0003>\"9!qZ\u001dA\u0002\tE\u0007")
public class OptimisticTransactionImpl
implements OptimisticTransaction,
Logging {
    private String logPrefix;
    private final DeltaLogImpl deltaLog;
    private final SnapshotImpl snapshot;
    private final int DELTA_MAX_RETRY_COMMIT_ATTEMPTS;
    private final String txnId;
    private final ArrayBuffer<String> readTxn;
    private final ArrayBuffer<Expression> readPredicates;
    private final HashSet<AddFile> readFiles;
    private boolean readTheWholeTable;
    private boolean committed;
    private Option<Metadata> newMetadata;
    private Option<Protocol> newProtocol;
    private boolean isCreatingNewTable;
    private long commitAttemptStartTime;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    public int DELTA_MAX_RETRY_COMMIT_ATTEMPTS() {
        return this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS;
    }

    private String txnId() {
        return this.txnId;
    }

    private ArrayBuffer<String> readTxn() {
        return this.readTxn;
    }

    private ArrayBuffer<Expression> readPredicates() {
        return this.readPredicates;
    }

    private HashSet<AddFile> readFiles() {
        return this.readFiles;
    }

    private boolean readTheWholeTable() {
        return this.readTheWholeTable;
    }

    private void readTheWholeTable_$eq(boolean x$1) {
        this.readTheWholeTable = x$1;
    }

    private boolean committed() {
        return this.committed;
    }

    private void committed_$eq(boolean x$1) {
        this.committed = x$1;
    }

    private Option<Metadata> newMetadata() {
        return this.newMetadata;
    }

    private void newMetadata_$eq(Option<Metadata> x$1) {
        this.newMetadata = x$1;
    }

    private Option<Protocol> newProtocol() {
        return this.newProtocol;
    }

    private void newProtocol_$eq(Option<Protocol> x$1) {
        this.newProtocol = x$1;
    }

    private boolean isCreatingNewTable() {
        return this.isCreatingNewTable;
    }

    private void isCreatingNewTable_$eq(boolean x$1) {
        this.isCreatingNewTable = x$1;
    }

    private long commitAttemptStartTime() {
        return this.commitAttemptStartTime;
    }

    private void commitAttemptStartTime_$eq(long x$1) {
        this.commitAttemptStartTime = x$1;
    }

    public Protocol protocol() {
        return (Protocol)this.newProtocol().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.snapshot.protocolScala());
    }

    public Metadata metadataScala() {
        return (Metadata)this.newMetadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.snapshot.metadataScala());
    }

    @Override
    public io.delta.standalone.actions.Metadata metadata() {
        return ConversionUtils$.MODULE$.convertMetadata(this.metadataScala());
    }

    @Override
    public <T extends io.delta.standalone.actions.Action> CommitResult commit(Iterable<T> actionsJ, Operation op, String engineInfo) {
        CommitInfo commitInfo;
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(actionsJ).asScala()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends T, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof io.delta.standalone.actions.Metadata) {
                    io.delta.standalone.actions.Metadata metadata = (io.delta.standalone.actions.Metadata)A1;
                    object = metadata;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(T x1) {
                T t = x1;
                boolean bl = t instanceof io.delta.standalone.actions.Metadata;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)m -> {
            this.updateMetadata(m);
            return BoxedUnit.UNIT;
        });
        Seq actions = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(actionsJ).asScala()).map((Function1 & Serializable & scala.Serializable)external -> ConversionUtils$.MODULE$.convertActionJ((io.delta.standalone.actions.Action)external), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$4(x$1)))).toSeq();
        Seq preparedActions = this.prepareCommit((Seq<Action>)actions);
        boolean noDataChanged = ((IterableLike)actions.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof FileAction) {
                    FileAction fileAction = (FileAction)A1;
                    object = BoxesRunTime.boxToBoolean((boolean)fileAction.dataChange());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x2) {
                Action action = x2;
                boolean bl = action instanceof FileAction;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$5(BoxesRunTime.unboxToBoolean((Object)x$2))));
        IsolationLevel isolationLevelToUse = noDataChanged ? SnapshotIsolation$.MODULE$ : Serializable$.MODULE$;
        boolean dependsOnFiles = this.readPredicates().nonEmpty() || this.readFiles().nonEmpty();
        boolean onlyAddFiles = ((IterableLike)preparedActions.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof FileAction) {
                    FileAction fileAction = (FileAction)A1;
                    object = fileAction;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x3) {
                Action action = x3;
                boolean bl = action instanceof FileAction;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$commit$6(x$3)));
        boolean isBlindAppend = onlyAddFiles && !dependsOnFiles;
        CommitInfo commitInfo2 = commitInfo = CommitInfo$.MODULE$.apply(this.deltaLog.clock().getTimeMillis(), op.getName().toString(), (Map<String, String>)(op.getParameters() == null ? null : ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(op.getParameters()).asScala()).toMap(Predef$.MODULE$.$conforms())), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.readVersion())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 >= 0L), (Option<String>)Option$.MODULE$.apply((Object)((IsolationLevel)isolationLevelToUse).toString()), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)isBlindAppend)), (Option<Map<String, String>>)new Some((Object)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(op.getMetrics()).asScala()).toMap(Predef$.MODULE$.$conforms())), (Option<String>)(op.getUserMetadata().isPresent() ? new Some((Object)op.getUserMetadata().get()) : None$.MODULE$), (Option<String>)new Some((Object)new StringBuilder(2).append(engineInfo.replaceAll("\\s", "-")).append(" ").append(package$.MODULE$.NAME().replaceAll("\\s", "-")).append("/").append(package$.MODULE$.VERSION()).toString()));
        preparedActions = (Seq)preparedActions.$plus$colon((Object)commitInfo2, Seq$.MODULE$.canBuildFrom());
        this.commitAttemptStartTime_$eq(this.deltaLog.clock().getTimeMillis());
        long commitVersion = this.doCommitRetryIteratively(this.snapshot.version() + 1L, (Seq<Action>)preparedActions, isolationLevelToUse);
        this.postCommit(commitVersion);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Committed delta #").append(commitVersion).append(" to ").append($this.deltaLog.logPath()).toString());
        return new CommitResult(commitVersion);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DeltaScan markFilesAsRead(Expression readPredicate) {
        void var2_2;
        DeltaScanImpl scan = this.snapshot.scanScala(readPredicate);
        AddFile[] matchedFiles = scan.getFilesScala();
        Object object = scan.getPushedPredicate().isPresent() ? this.readPredicates().$plus$eq((Object)scan.getPushedPredicate().get()) : BoxedUnit.UNIT;
        this.readFiles().$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchedFiles)));
        return var2_2;
    }

    @Override
    public void updateMetadata(io.delta.standalone.actions.Metadata metadataJ) {
        ObjectRef latestMetadata = ObjectRef.create((Object)ConversionUtils$.MODULE$.convertMetadataJ(metadataJ));
        if (this.newMetadata().contains((Object)((Metadata)latestMetadata.elem))) {
            return;
        }
        Predef$.MODULE$.assert(this.newMetadata().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Cannot change the metadata more than once in a transaction.");
        if (this.readVersion() == -1L || this.isCreatingNewTable()) {
            latestMetadata.elem = this.withGlobalConfigDefaults((Metadata)latestMetadata.elem);
            this.isCreatingNewTable_$eq(true);
        }
        String string = this.snapshot.metadataScala().schemaString();
        String string2 = ((Metadata)latestMetadata.elem).schemaString();
        if (string == null ? string2 != null : !string.equals(string2)) {
            SchemaUtils$.MODULE$.checkUnenforceableNotNullConstraints(((Metadata)latestMetadata.elem).schema());
        }
        this.verifyNewMetadata((Metadata)latestMetadata.elem);
        this.checkPartitionColumns(((Metadata)latestMetadata.elem).partitionColumns(), ((Metadata)latestMetadata.elem).schema());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Updated metadata from ").append(this.newMetadata().getOrElse((Function0 & Serializable & scala.Serializable)() -> "-")).append(" to ").append((Metadata)latestMetadata$1.elem).toString());
        this.newMetadata_$eq((Option<Metadata>)new Some((Object)((Metadata)latestMetadata.elem)));
    }

    @Override
    public void readWholeTable() {
        this.readPredicates().$plus$eq((Object)Literal.True);
        this.readTheWholeTable_$eq(true);
    }

    @Override
    public long txnVersion(String id) {
        this.readTxn().$plus$eq((Object)id);
        return BoxesRunTime.unboxToLong((Object)this.snapshot.transactions().getOrElse((Object)id, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L));
    }

    @Override
    public long readVersion() {
        return this.snapshot.version();
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Action> prepareCommit(Seq<Action> actions) {
        void var3_3;
        block4: {
            Option protocolOpt;
            Predef$.MODULE$.assert(!this.committed(), (Function0 & Serializable & scala.Serializable)() -> "Transaction already committed.");
            boolean customCommitInfo = actions.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$2(x$6)));
            Predef$.MODULE$.assert(!customCommitInfo, (Function0 & Serializable & scala.Serializable)() -> "Cannot commit a custom CommitInfo in a transaction.");
            Seq finalActions = (Seq)actions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Action action;
                Action action2 = x0$1;
                if (action2 instanceof AddFile) {
                    AddFile addFile = (AddFile)action2;
                    action = addFile.copy(DeltaFileOperations$.MODULE$.tryRelativizePath($this.deltaLog.fs(), $this.deltaLog.getPath(), new Path(addFile.path()), DeltaFileOperations$.MODULE$.tryRelativizePath$default$4()).toString(), addFile.copy$default$2(), addFile.copy$default$3(), addFile.copy$default$4(), addFile.copy$default$5(), addFile.copy$default$6(), addFile.copy$default$7());
                } else if (action2 != null) {
                    Action action3;
                    action = action3 = action2;
                } else {
                    throw new MatchError((Object)action2);
                }
                return action;
            }, Seq$.MODULE$.canBuildFrom());
            this.newMetadata().foreach((Function1 & Serializable & scala.Serializable)m -> {
                this.verifySchemaCompatibility(this.snapshot.metadataScala().schema(), m.schema(), (Seq<Action>)actions);
                return BoxedUnit.UNIT;
            });
            finalActions = (Seq)Option$.MODULE$.option2Iterable(this.newMetadata()).toSeq().$plus$plus((GenTraversableOnce)finalActions, Seq$.MODULE$.canBuildFrom());
            if (this.snapshot.version() == -1L) {
                this.deltaLog.ensureLogDirectoryExist();
                if (!finalActions.exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$6(x$7)))) {
                    Protocol protocol = this.protocol();
                    finalActions = (Seq)finalActions.$plus$colon((Object)protocol, Seq$.MODULE$.canBuildFrom());
                }
                if (!finalActions.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)OptimisticTransactionImpl.$anonfun$prepareCommit$7(x$9)))) {
                    throw DeltaErrors$.MODULE$.metadataAbsentException();
                }
            }
            if ((protocolOpt = finalActions.collectFirst((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof Protocol) {
                        Protocol protocol = (Protocol)A1;
                        object = protocol;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Action x1) {
                    Action action = x1;
                    boolean bl = action instanceof Protocol;
                    return bl;
                }
            })).isDefined()) {
                Object object = protocolOpt.get();
                Protocol protocol = new Protocol(Protocol$.MODULE$.apply$default$1(), Protocol$.MODULE$.apply$default$2());
                Predef$.MODULE$.assert(!(object != null ? !object.equals(protocol) : protocol != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Invalid Protocol ").append(((Protocol)protocolOpt.get()).simpleString()).append(". ").append("Currently only Protocol readerVersion 1 and writerVersion 2 is supported.").toString());
            }
            Set partitionColumns = this.metadataScala().partitionColumns().toSet();
            finalActions.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                OptimisticTransactionImpl.$anonfun$prepareCommit$9(partitionColumns, x0$2);
                return BoxedUnit.UNIT;
            });
            this.deltaLog.assertProtocolWrite(this.snapshot.protocolScala());
            Seq removes = (Seq)actions.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Action, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof RemoveFile) {
                        RemoveFile removeFile = (RemoveFile)A1;
                        object = removeFile;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Action x2) {
                    Action action = x2;
                    boolean bl = action instanceof RemoveFile;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            if (!removes.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.dataChange()))) break block4;
            this.deltaLog.assertRemovable();
        }
        return var3_3;
    }

    public long doCommitRetryIteratively(long attemptVersion, Seq<Action> actions, IsolationLevel isolationLevel) {
        return BoxesRunTime.unboxToLong(this.deltaLog.lockInterruptibly((JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            boolean tryCommit = true;
            long commitVersion = attemptVersion;
            int attemptNumber = 0;
            while (tryCommit) {
                try {
                    long l;
                    if (attemptNumber == 0) {
                        l = this.doCommit(commitVersion, actions, isolationLevel);
                    } else {
                        if (attemptNumber > this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS()) {
                            long totalCommitAttemptTime = $this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime();
                            throw DeltaErrors$.MODULE$.maxCommitRetriesExceededException(attemptNumber, commitVersion, attemptVersion, actions.length(), totalCommitAttemptTime);
                        }
                        commitVersion = this.checkForConflicts(commitVersion, actions, attemptNumber, isolationLevel);
                        l = this.doCommit(commitVersion, actions, isolationLevel);
                    }
                    tryCommit = false;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    ++attemptNumber;
                }
            }
            return commitVersion;
        }));
    }

    private long doCommit(long attemptVersion, Seq<Action> actions, IsolationLevel isolationLevel) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Attempting to commit version ").append(attemptVersion).append(" with ").append(actions.size()).append(" actions with ").append(new StringBuilder(16).append(isolationLevel).append(" isolation level").toString()).toString());
        if (this.readVersion() > -1L) {
            String string = this.metadata().getId();
            String string2 = this.snapshot.getMetadata().getId();
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Change in the table id detected in txn. Table id for txn on table at ").append(new StringBuilder(35).append($this.deltaLog.dataPath()).append(" was ").append($this.snapshot.getMetadata().getId()).append(" when the txn was created and ").toString()).append(new StringBuilder(19).append("is now changed to ").append(this.metadata().getId()).append(".").toString()).toString());
            }
        }
        this.deltaLog.store().write(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), attemptVersion), (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(((IterableLike)actions.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.json(), Seq$.MODULE$.canBuildFrom())).toIterator()).asJava(), Predef$.MODULE$.boolean2Boolean(false), this.deltaLog.hadoopConf());
        SnapshotImpl postCommitSnapshot = this.deltaLog.update();
        if (postCommitSnapshot.version() < attemptVersion) {
            throw new IllegalStateException(new StringBuilder(26).append("The committed version is ").append(attemptVersion).append(" ").append(new StringBuilder(28).append("but the current version is ").append(postCommitSnapshot.version()).append(".").toString()).toString());
        }
        return attemptVersion;
    }

    private void postCommit(long commitVersion) {
        block2: {
            this.committed_$eq(true);
            if (!this.shouldCheckpoint(commitVersion)) break block2;
            try {
                this.deltaLog.checkpoint(this.deltaLog.getSnapshotForVersionAsOf(commitVersion));
            }
            catch (IllegalStateException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to checkpoint table state.", e);
            }
        }
    }

    private long checkForConflicts(long checkVersion, Seq<Action> actions, int attemptNumber, IsolationLevel commitIsolationLevel) {
        long nextAttemptVersion = this.getNextAttemptVersion();
        CurrentTransactionInfo currentTransactionInfo = new CurrentTransactionInfo((Seq<Expression>)this.readPredicates().toSeq(), (Set<AddFile>)this.readFiles().toSet(), this.readTheWholeTable(), (Set<String>)this.readTxn().toSet(), this.metadataScala(), actions, this.deltaLog);
        String logPrefixStr = new StringBuilder(10).append("[attempt ").append(attemptNumber).append("]").toString();
        LongRef adds = LongRef.create((long)0L);
        LongRef removes = LongRef.create((long)0L);
        currentTransactionInfo.actions().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            OptimisticTransactionImpl.$anonfun$checkForConflicts$1(adds, removes, x0$1);
            return BoxedUnit.UNIT;
        });
        String txnDetailsLogStr = new StringBuilder(35).append(adds.elem).append(" adds, ").append(removes.elem).append(" removes, ").append(this.readPredicates().size()).append(" read predicates, ").append(new StringBuilder(11).append(this.readFiles().size()).append(" read files").toString()).toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append(logPrefixStr).append(" Checking for conflicts with versions ").append(new StringBuilder(29).append("[").append(checkVersion).append(", ").append(nextAttemptVersion).append(") with current txn having ").append(txnDetailsLogStr).toString()).toString());
        new RichLong(Predef$.MODULE$.longWrapper(checkVersion)).until((Object)BoxesRunTime.boxToLong((long)nextAttemptVersion)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)otherCommitVersion -> {
            ConflictChecker conflictChecker = new ConflictChecker(currentTransactionInfo, otherCommitVersion, commitIsolationLevel, logPrefixStr);
            conflictChecker.checkConflicts();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append(logPrefixStr).append(" No conflicts in version ").append(otherCommitVersion).append(", ").append(new StringBuilder(15).append($this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime()).append(" ms since start").toString()).toString());
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append(logPrefixStr).append(" No conflicts with versions [").append(checkVersion).append(", ").append(nextAttemptVersion).append(") ").append(new StringBuilder(26).append("with current txn having ").append(txnDetailsLogStr).append(", ").toString()).append(new StringBuilder(15).append($this.deltaLog.clock().getTimeMillis() - this.commitAttemptStartTime()).append(" ms since start").toString()).toString());
        return nextAttemptVersion;
    }

    private void verifyNewMetadata(Metadata metadata) {
        SchemaMergingUtils$.MODULE$.checkColumnNameDuplication(metadata.schema(), "in the metadata update");
        SchemaUtils$.MODULE$.checkFieldNames(SchemaMergingUtils$.MODULE$.explodeNestedFieldNames(metadata.dataSchema()));
        try {
            SchemaUtils$.MODULE$.checkFieldNames(metadata.partitionColumns());
        }
        catch (DeltaStandaloneException e) {
            throw DeltaErrors$.MODULE$.invalidPartitionColumn(e);
        }
        Protocol$.MODULE$.checkMetadataProtocolProperties(metadata, this.protocol());
    }

    private void checkPartitionColumns(Seq<String> partitionCols, StructType schema) {
        Set schemaCols = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.getFieldNames())).toSet();
        Seq partitionsColsNotInSchema = partitionCols.toSet().diff((GenSet)schemaCols).toSeq();
        if (partitionsColsNotInSchema.nonEmpty()) {
            throw DeltaErrors$.MODULE$.partitionColumnsNotFoundException((Seq<String>)partitionsColsNotInSchema, schema);
        }
        if (partitionCols.length() == schemaCols.size()) {
            throw DeltaErrors$.MODULE$.nonPartitionColumnAbsentException();
        }
    }

    private void verifySchemaCompatibility(StructType existingSchema, StructType newSchema, Seq<Action> actions) {
        boolean tableEmpty;
        LazyBoolean allCurrentFilesRemoved$lzy = new LazyBoolean();
        boolean bl = tableEmpty = this.snapshot.numOfFiles() == 0L;
        if (tableEmpty || this.allCurrentFilesRemoved$1(allCurrentFilesRemoved$lzy, actions)) {
            return;
        }
        if (!existingSchema.isWriteCompatible(newSchema)) {
            throw DeltaErrors$.MODULE$.schemaChangedException(existingSchema, newSchema);
        }
    }

    private boolean shouldCheckpoint(long committedVersion) {
        return committedVersion != 0L && committedVersion % (long)this.deltaLog.checkpointInterval() == 0L;
    }

    private long getNextAttemptVersion() {
        this.deltaLog.update();
        return this.deltaLog.snapshot().version() + 1L;
    }

    private Metadata withGlobalConfigDefaults(Metadata metadata) {
        Map<String, String> x$1 = DeltaConfigs$.MODULE$.mergeGlobalConfigs(this.deltaLog.hadoopConf(), metadata.configuration());
        String x$2 = metadata.copy$default$1();
        String x$3 = metadata.copy$default$2();
        String x$4 = metadata.copy$default$3();
        Format x$5 = metadata.copy$default$4();
        String x$6 = metadata.copy$default$5();
        Seq<String> x$7 = metadata.copy$default$6();
        Option<Object> x$8 = metadata.copy$default$8();
        return metadata.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1, x$8);
    }

    private String logPrefix$lzycompute() {
        OptimisticTransactionImpl optimisticTransactionImpl = this;
        synchronized (optimisticTransactionImpl) {
            if (!this.bitmap$0) {
                this.logPrefix = new StringBuilder(18).append("[tableId=").append(OptimisticTransactionImpl.truncate$1(this.snapshot.metadataScala().id())).append(",txnId=").append(OptimisticTransactionImpl.truncate$1(this.txnId())).append("] ").toString();
                this.bitmap$0 = true;
            }
        }
        this.txnId = null;
        return this.logPrefix;
    }

    public String logPrefix() {
        return !this.bitmap$0 ? this.logPrefix$lzycompute() : this.logPrefix;
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString(), throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString());
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(0).append(this.logPrefix()).append(msg.apply()).toString(), throwable);
    }

    public static final /* synthetic */ boolean $anonfun$commit$4(Action x$1) {
        return !(x$1 instanceof Metadata);
    }

    public static final /* synthetic */ boolean $anonfun$commit$5(boolean x$2) {
        return !x$2;
    }

    public static final /* synthetic */ boolean $anonfun$commit$6(FileAction x$3) {
        return x$3 instanceof AddFile;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$2(Action x$6) {
        return x$6 instanceof CommitInfo;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$6(Action x$7) {
        return x$7 instanceof Protocol;
    }

    public static final /* synthetic */ boolean $anonfun$prepareCommit$7(Action x$9) {
        return x$9 instanceof Metadata;
    }

    public static final /* synthetic */ void $anonfun$prepareCommit$9(Set partitionColumns$1, Action x0$2) {
        Action action = x0$2;
        if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            Set set = partitionColumns$1;
            Set set2 = addFile.partitionValues().keySet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                throw DeltaErrors$.MODULE$.addFilePartitioningMismatchException((Seq<String>)addFile.partitionValues().keySet().toSeq(), (Seq<String>)partitionColumns$1.toSeq());
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$checkForConflicts$1(LongRef adds$1, LongRef removes$1, Action x0$1) {
        Action action = x0$1;
        if (action instanceof AddFile) {
            ++adds$1.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (action instanceof RemoveFile) {
            ++removes$1.elem;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final /* synthetic */ boolean allCurrentFilesRemoved$lzycompute$1(LazyBoolean allCurrentFilesRemoved$lzy$1, Seq actions$4) {
        boolean bl;
        LazyBoolean lazyBoolean = allCurrentFilesRemoved$lzy$1;
        synchronized (lazyBoolean) {
            boolean bl2;
            if (allCurrentFilesRemoved$lzy$1.initialized()) {
                bl2 = allCurrentFilesRemoved$lzy$1.value();
            } else {
                Seq removeFiles = (Seq)actions$4.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 instanceof RemoveFile) {
                            RemoveFile removeFile = (RemoveFile)A1;
                            object = removeFile;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Action x1) {
                        Action action = x1;
                        boolean bl = action instanceof RemoveFile;
                        return bl;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Set set = ((TraversableOnce)removeFiles.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.path(), Seq$.MODULE$.canBuildFrom())).toSet();
                Set set2 = ((TraversableOnce)this.snapshot.allFilesScala().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.path(), Seq$.MODULE$.canBuildFrom())).toSet();
                bl2 = allCurrentFilesRemoved$lzy$1.initialize(!(set != null ? !set.equals(set2) : set2 != null));
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean allCurrentFilesRemoved$1(LazyBoolean allCurrentFilesRemoved$lzy$1, Seq actions$4) {
        return allCurrentFilesRemoved$lzy$1.initialized() ? allCurrentFilesRemoved$lzy$1.value() : this.allCurrentFilesRemoved$lzycompute$1(allCurrentFilesRemoved$lzy$1, actions$4);
    }

    private static final String truncate$1(String uuid) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])uuid.split("-"))).head();
    }

    public OptimisticTransactionImpl(DeltaLogImpl deltaLog, SnapshotImpl snapshot) {
        this.deltaLog = deltaLog;
        this.snapshot = snapshot;
        Logging.$init$(this);
        this.DELTA_MAX_RETRY_COMMIT_ATTEMPTS = 10000000;
        this.txnId = UUID.randomUUID().toString();
        this.readTxn = new ArrayBuffer();
        this.readPredicates = new ArrayBuffer();
        this.readFiles = new HashSet();
        this.readTheWholeTable = false;
        this.committed = false;
        this.newMetadata = None$.MODULE$;
        this.newProtocol = None$.MODULE$;
        this.isCreatingNewTable = false;
    }
}

