/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasource;

import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.engine.spark.utils.StorageUtils$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3qAB\u0004\u0011\u0002\u0007\u0005A\u0003C\u0003\"\u0001\u0011\u0005!\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u00036\u0001\u0011\u0005a\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003P\u0001\u0011\u0005\u0001KA\u000bSKN,Go\u00155vM\u001adW\rU1si&$\u0018n\u001c8\u000b\u0005!I\u0011A\u00033bi\u0006\u001cx.\u001e:dK*\u0011!bC\u0001\nKb,7-\u001e;j_:T!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001c!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011AdH\u0007\u0002;)\u0011a$D\u0001\tS:$XM\u001d8bY&\u0011\u0001%\b\u0002\b\u0019><w-\u001b8h\u0003\u0019!\u0013N\\5uIQ\t1\u0005\u0005\u0002\u0017I%\u0011Qe\u0006\u0002\u0005+:LG/\u0001\u000btKR\u001c\u0006.\u001e4gY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005G!js\u0006C\u0003*\u0005\u0001\u0007!&A\u0003csR,7\u000f\u0005\u0002\u0017W%\u0011Af\u0006\u0002\u0005\u0019>tw\rC\u0003/\u0005\u0001\u0007!&\u0001\u0006t_V\u00148-\u001a*poNDQ\u0001\r\u0002A\u0002E\nAb\u001d9be.\u001cVm]:j_:\u0004\"AM\u001a\u000e\u0003-I!\u0001N\u0006\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u001b\u001d,G\u000fU1si&$\u0018n\u001c8t)\r9$h\u000f\t\u0003-aJ!!O\f\u0003\u0007%sG\u000fC\u00031\u0007\u0001\u0007\u0011\u0007C\u0003*\u0007\u0001\u0007!&A\u000foK\u0016$7+\u001a;GS2,7/T1y!\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010^3t)\u0011q\u0014iQ#\u0011\u0005Yy\u0014B\u0001!\u0018\u0005\u001d\u0011un\u001c7fC:DQA\u0011\u0003A\u0002)\nQ\u0002^8uC2\u0014vn^\"pk:$\b\"\u0002#\u0005\u0001\u0004Q\u0013aC:pkJ\u001cWMQ=uKNDQA\u0012\u0003A\u0002\u001d\u000b\u0011b[1q\u0007>tg-[4\u0011\u0005!kU\"A%\u000b\u0005)[\u0015AB2p[6|gN\u0003\u0002M\u001f\u0005)1.\u001f7j]&\u0011a*\u0013\u0002\n\u0017\u0006\u00048i\u001c8gS\u001e\f\u0011d]3u\r&dWm]'bqB\u000b'\u000f^5uS>t')\u001f;fgR!1%\u0015*T\u0011\u0015!U\u00011\u0001+\u0011\u0015qS\u00011\u0001+\u0011\u0015\u0001T\u00011\u00012\u0001")
public interface ResetShufflePartition
extends Logging {
    public static /* synthetic */ void setShufflePartitions$(ResetShufflePartition $this, long bytes, long sourceRows, SparkSession sparkSession) {
        $this.setShufflePartitions(bytes, sourceRows, sparkSession);
    }

    default public void setShufflePartitions(long bytes, long sourceRows, SparkSession sparkSession) {
        QueryContext.current().getMetrics().setSourceScanBytes(bytes);
        QueryContext.current().getMetrics().setSourceScanRows(sourceRows);
        int partitions = this.getPartitions(sparkSession, bytes);
        int originPartitions = QueryContext.current().getShufflePartitionsReset();
        if (partitions > originPartitions) {
            sparkSession.sessionState().conf().setLocalProperty(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key(), Integer.toString(partitions));
            QueryContext.current().setShufflePartitionsReset(partitions);
            this.logInfo((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("Set partition from ").append(originPartitions).append(" to ").append(partitions).append(", ").append("total bytes ").append(QueryContext.current().getMetrics().getSourceScanBytes()).toString());
        } else {
            this.logInfo((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(74).append("Origin partition is ").append(originPartitions).append(", new partition is ").append(partitions).append(", total bytes ").append(QueryContext.current().getMetrics().getSourceScanBytes()).append(", will not reset the ").append(SQLConf$.MODULE$.SHUFFLE_PARTITIONS().key()).toString());
        }
    }

    public static /* synthetic */ int getPartitions$(ResetShufflePartition $this, SparkSession sparkSession, long bytes) {
        return $this.getPartitions(sparkSession, bytes);
    }

    default public int getPartitions(SparkSession sparkSession, long bytes) {
        int n;
        int defaultParallelism = sparkSession.leafNodeDefaultParallelism();
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        if (kapConfig.getSparkSqlShufflePartitions() != -1) {
            n = kapConfig.getSparkSqlShufflePartitions();
        } else {
            int partitions = (int)Math.min(QueryContext.current().getMetrics().getSourceScanBytes() / (long)(KylinConfig.getInstanceFromEnv().getQueryPartitionSplitSizeMB() * 1024 * 1024) + 1L, (long)defaultParallelism);
            if (sparkSession.sessionState().conf().splitSourcePartitionEnabled()) {
                int maxExpandNum = sparkSession.sessionState().conf().splitSourcePartitionMaxExpandNum();
                long profitableSize = sparkSession.sessionState().conf().splitSourcePartitionThreshold();
                int expandPartNum = Math.min(maxExpandNum, defaultParallelism);
                if (expandPartNum >= partitions << 1 && bytes >= profitableSize) {
                    partitions = expandPartNum;
                }
            }
            n = partitions;
        }
        int partitionsNum = n;
        return partitionsNum;
    }

    public static /* synthetic */ boolean needSetFilesMaxPartitionBytes$(ResetShufflePartition $this, long totalRowCount, long sourceBytes, KapConfig kapConfig) {
        return $this.needSetFilesMaxPartitionBytes(totalRowCount, sourceBytes, kapConfig);
    }

    default public boolean needSetFilesMaxPartitionBytes(long totalRowCount, long sourceBytes, KapConfig kapConfig) {
        if (kapConfig.isResetMaxPartitionBytes()) {
            long parquetRowCountThresholdSize = kapConfig.getQueryParquetRowCountThresholdSize();
            long filesThresholdBytes = kapConfig.getQueryParquetFilesThresholdBytes();
            long parquetRowCountPerMb = kapConfig.getQueryParquetRowCountPerMb();
            return sourceBytes < filesThresholdBytes && totalRowCount < parquetRowCountThresholdSize && (double)totalRowCount / ((double)sourceBytes * 1.0 / (double)StorageUtils$.MODULE$.MB()) > (double)parquetRowCountPerMb;
        }
        return false;
    }

    public static /* synthetic */ void setFilesMaxPartitionBytes$(ResetShufflePartition $this, long sourceBytes, long sourceRows, SparkSession sparkSession) {
        $this.setFilesMaxPartitionBytes(sourceBytes, sourceRows, sparkSession);
    }

    default public void setFilesMaxPartitionBytes(long sourceBytes, long sourceRows, SparkSession sparkSession) {
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        boolean needSet = this.needSetFilesMaxPartitionBytes(sourceRows, sourceBytes, kapConfig);
        if (needSet) {
            long filesMaxPartitionBytes = kapConfig.getQueryFilesMaxPartitionBytes();
            sparkSession.sessionState().conf().setLocalProperty(SQLConf$.MODULE$.FILES_MAX_PARTITION_BYTES().key(), Long.toString(filesMaxPartitionBytes));
            this.logInfo((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(45).append("Set the ").append(SQLConf$.MODULE$.FILES_MAX_PARTITION_BYTES().key()).append(" to ").append(filesMaxPartitionBytes).append(", ").append("total bytes ").append(sourceBytes).append(" , total row count ").append(sourceRows).toString());
        } else {
            this.logInfo((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(52).append("Not need reset the ").append(SQLConf$.MODULE$.FILES_MAX_PARTITION_BYTES().key()).append(", ").append("total bytes ").append(sourceBytes).append(" , total row count ").append(sourceRows).toString());
        }
    }

    public static void $init$(ResetShufflePartition $this) {
    }
}

