/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.profiler;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.guava30.shaded.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.kylin.profiler.AsyncProfilerTool$;
import org.apache.kylin.profiler.AsyncProfilerUtils;
import org.apache.kylin.profiler.Message$;
import org.apache.kylin.profiler.ProfilerStatus$;
import org.apache.spark.SparkContext;
import org.apache.spark.api.plugin.DriverPlugin;
import org.apache.spark.api.plugin.PluginContext;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\u001c9\u0001\u0005CQA\u0017\u0001\u0005\u0002mCqA\u0018\u0001C\u0002\u0013%q\f\u0003\u0004g\u0001\u0001\u0006I\u0001\u0019\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019y\u0007\u0001)A\u0005S\"9\u0001\u000f\u0001b\u0001\n\u0013y\u0006BB9\u0001A\u0003%\u0001\rC\u0004s\u0001\t\u0007I\u0011B0\t\rM\u0004\u0001\u0015!\u0003a\u0011\u001d!\bA1A\u0005\nUDa!\u001f\u0001!\u0002\u00131\bb\u0002>\u0001\u0005\u0004%Ia\u001f\u0005\u0007\u007f\u0002\u0001\u000b\u0011\u0002?\t\u0013\u0005\u0005\u0001A1A\u0005\n\u0005\r\u0001\u0002CA\u0006\u0001\u0001\u0006I!!\u0002\t\u0013\u00055\u0001A1A\u0005\n\u0005=\u0001\u0002CA\u0011\u0001\u0001\u0006I!!\u0005\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013\u0005\u0011Q\u0005\u0005\f\u0003o\u0001\u0001\u0019!a\u0001\n\u0003\tI\u0004C\u0006\u0002F\u0001\u0001\r\u0011!Q!\n\u0005\u001d\u0002bCA$\u0001\u0001\u0007\t\u0019!C\u0001\u0003KA1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002L!Y\u0011q\n\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0014\u0011-\t\t\u0006\u0001a\u0001\u0002\u0004%\t!!\n\t\u0017\u0005M\u0003\u00011AA\u0002\u0013\u0005\u0011Q\u000b\u0005\f\u00033\u0002\u0001\u0019!A!B\u0013\t9\u0003C\u0005\u0002\\\u0001\u0001\r\u0011\"\u0001\u0002^!I\u0011Q\r\u0001A\u0002\u0013\u0005\u0011q\r\u0005\t\u0003W\u0002\u0001\u0015)\u0003\u0002`!Y\u0011Q\u000e\u0001A\u0002\u0003\u0007I\u0011BA8\u0011-\t9\b\u0001a\u0001\u0002\u0004%I!!\u001f\t\u0017\u0005u\u0004\u00011A\u0001B\u0003&\u0011\u0011\u000f\u0005\n\u0003\u007f\u0002\u0001\u0019!C\u0005\u0003\u0003C\u0011\"a&\u0001\u0001\u0004%I!!'\t\u0011\u0005u\u0005\u0001)Q\u0005\u0003\u0007C\u0011\"a(\u0001\u0001\u0004%I!!\u0018\t\u0013\u0005\u0005\u0006\u00011A\u0005\n\u0005\r\u0006\u0002CAT\u0001\u0001\u0006K!a\u0018\t\u0013\u0005%\u0006\u00011A\u0005\n\u0005u\u0003\"CAV\u0001\u0001\u0007I\u0011BAW\u0011!\t\t\f\u0001Q!\n\u0005}\u0003bCAZ\u0001\u0001\u0007\t\u0019!C\u0005\u0003kC1\"!0\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002@\"Y\u00111\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BA\\\u0011-\t)\r\u0001a\u0001\u0002\u0004%I!a2\t\u0017\u0005E\u0007\u00011AA\u0002\u0013%\u00111\u001b\u0005\f\u0003/\u0004\u0001\u0019!A!B\u0013\tI\rC\u0004\u0002Z\u0002!\t%a7\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011Y\u0001\u0001C!\u0005\u001bAqAa\b\u0001\t\u0003\nYP\u0001\u0010Ck&dG-Q:z]\u000e\u0004&o\u001c4jY\u0016\u0014HI]5wKJ\u0004F.^4j]*\u0011\u0011HO\u0001\taJ|g-\u001b7fe*\u00111\bP\u0001\u0006Wfd\u0017N\u001c\u0006\u0003{y\na!\u00199bG\",'\"A \u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011%\n\u0016\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001\\1oO*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u0019y%M[3diB\u00111JU\u0007\u0002\u0019*\u0011QJT\u0001\u0007a2,x-\u001b8\u000b\u0005=\u0003\u0016aA1qS*\u0011\u0011\u000bP\u0001\u0006gB\f'o[\u0005\u0003'2\u0013A\u0002\u0012:jm\u0016\u0014\b\u000b\\;hS:\u0004\"!\u0016-\u000e\u0003YS!a\u0016)\u0002\u0011%tG/\u001a:oC2L!!\u0017,\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u0018\t\u0003;\u0002i\u0011\u0001O\u0001\u0011G\",7m[5oO&sG/\u001a:wC2,\u0012\u0001\u0019\t\u0003C\u0012l\u0011A\u0019\u0006\u0002G\u0006)1oY1mC&\u0011QM\u0019\u0002\u0005\u0019>tw-A\tdQ\u0016\u001c7.\u001b8h\u0013:$XM\u001d<bY\u0002\nQ\u0002\\8dC2\u001c\u0015m\u00195f\t&\u0014X#A5\u0011\u0005)lW\"A6\u000b\u000514\u0015AA5p\u0013\tq7N\u0001\u0003GS2,\u0017A\u00047pG\u0006d7)Y2iK\u0012K'\u000fI\u0001\u0018e\u0016\u001cX\u000f\u001c;D_2dWm\u0019;j_:$\u0016.\\3pkR\f\u0001D]3tk2$8i\u001c7mK\u000e$\u0018n\u001c8US6,w.\u001e;!\u0003A\u0001(o\u001c4jY&tw\rV5nK>,H/A\tqe>4\u0017\u000e\\5oORKW.Z8vi\u0002\nQB\u0012'B\u000f~3\u0015\nT#`\t&\u0013V#\u0001<\u0011\u0005\r;\u0018B\u0001=E\u0005\u0019\u0019FO]5oO\u0006qa\tT!H?\u001aKE*R0E\u0013J\u0003\u0013a\u00034mC\u001e4\u0015\u000e\\3ESJ,\u0012\u0001 \t\u0004Cv4\u0018B\u0001@c\u0005\u0019y\u0005\u000f^5p]\u0006aa\r\\1h\r&dW\rR5sA\u0005\u0011\u0012m]=oGB\u0013xNZ5mKJ,F/\u001b7t+\t\t)\u0001E\u0002^\u0003\u000fI1!!\u00039\u0005I\t5/\u001f8d!J|g-\u001b7feV#\u0018\u000e\\:\u0002'\u0005\u001c\u0018P\\2Qe>4\u0017\u000e\\3s+RLGn\u001d\u0011\u00021M\u001c\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cW-\u0006\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011AC2p]\u000e,(O]3oi*\u0019\u00111\u0004$\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003?\t)B\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0011d]2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2fA\u0005q\u0011m\u0019;j_:4\u0015\u000e\\3QCRDWCAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\t!AZ:\u000b\u0007\u0005EB(\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003k\tYC\u0001\u0003QCRD\u0017AE1di&|gNR5mKB\u000bG\u000f[0%KF$B!a\u000f\u0002BA\u0019\u0011-!\u0010\n\u0007\u0005}\"M\u0001\u0003V]&$\b\"CA\"'\u0005\u0005\t\u0019AA\u0014\u0003\rAH%M\u0001\u0010C\u000e$\u0018n\u001c8GS2,\u0007+\u0019;iA\u0005q1\u000f^1ukN4\u0015\u000e\\3OC6,\u0017AE:uCR,8OR5mK:\u000bW.Z0%KF$B!a\u000f\u0002N!I\u00111\t\f\u0002\u0002\u0003\u0007\u0011qE\u0001\u0010gR\fG/^:GS2,g*Y7fA\u0005aA-^7q\r&dWMT1nK\u0006\u0001B-^7q\r&dWMT1nK~#S-\u001d\u000b\u0005\u0003w\t9\u0006C\u0005\u0002De\t\t\u00111\u0001\u0002(\u0005iA-^7q\r&dWMT1nK\u0002\nqa^8sW&tw-\u0006\u0002\u0002`A\u0019\u0011-!\u0019\n\u0007\u0005\r$MA\u0004C_>dW-\u00198\u0002\u0017]|'o[5oO~#S-\u001d\u000b\u0005\u0003w\tI\u0007C\u0005\u0002Dq\t\t\u00111\u0001\u0002`\u0005Aqo\u001c:lS:<\u0007%\u0001\fuS6,w.\u001e;Fq\u0016\u001cW\u000f^5p]RC'/Z1e+\t\t\t\bE\u0002D\u0003gJ1!!\u001eE\u0005\u0019!\u0006N]3bI\u0006QB/[7f_V$X\t_3dkRLwN\u001c+ie\u0016\fGm\u0018\u0013fcR!\u00111HA>\u0011%\t\u0019eHA\u0001\u0002\u0004\t\t(A\fuS6,w.\u001e;Fq\u0016\u001cW\u000f^5p]RC'/Z1eA\u0005Ya.\u001a=u\u0007>lW.\u00198e+\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006Me\u0002BAD\u0003\u001f\u00032!!#c\u001b\t\tYIC\u0002\u0002\u000e\u0002\u000ba\u0001\u0010:p_Rt\u0014bAAIE\u00061\u0001K]3eK\u001aL1\u0001_AK\u0015\r\t\tJY\u0001\u0010]\u0016DHoQ8n[\u0006tGm\u0018\u0013fcR!\u00111HAN\u0011%\t\u0019EIA\u0001\u0002\u0004\t\u0019)\u0001\u0007oKb$8i\\7nC:$\u0007%A\u0004sk:t\u0017N\\4\u0002\u0017I,hN\\5oO~#S-\u001d\u000b\u0005\u0003w\t)\u000bC\u0005\u0002D\u0015\n\t\u00111\u0001\u0002`\u0005A!/\u001e8oS:<\u0007%\u0001\u0004ek6\u0004X\rZ\u0001\u000bIVl\u0007/\u001a3`I\u0015\fH\u0003BA\u001e\u0003_C\u0011\"a\u0011)\u0003\u0003\u0005\r!a\u0018\u0002\u000f\u0011,X\u000e]3eA\u0005a1-Y2iK\u0012\u0014Vm];miV\u0011\u0011q\u0017\t\u0005\u0003'\tI,\u0003\u0003\u0002<\u0006U!AD\"pk:$Hi\\<o\u0019\u0006$8\r[\u0001\u0011G\u0006\u001c\u0007.\u001a3SKN,H\u000e^0%KF$B!a\u000f\u0002B\"I\u00111I\u0016\u0002\u0002\u0003\u0007\u0011qW\u0001\u000eG\u0006\u001c\u0007.\u001a3SKN,H\u000e\u001e\u0011\u0002\u0019M\u0004\u0018M]6D_:$X\r\u001f;\u0016\u0005\u0005%\u0007\u0003BAf\u0003\u001bl\u0011\u0001U\u0005\u0004\u0003\u001f\u0004&\u0001D*qCJ\\7i\u001c8uKb$\u0018\u0001E:qCJ\\7i\u001c8uKb$x\fJ3r)\u0011\tY$!6\t\u0013\u0005\rc&!AA\u0002\u0005%\u0017!D:qCJ\\7i\u001c8uKb$\b%\u0001\u0003j]&$HCBAo\u0003K\fI\u000f\u0005\u0005\u0002`\u0006\u0005\u00181QAB\u001b\t\tI\"\u0003\u0003\u0002d\u0006e!aA'ba\"9\u0011q\u001d\u0019A\u0002\u0005%\u0017AA:d\u0011\u001d\tY\u000f\ra\u0001\u0003[\fQ\u0002\u001d7vO&t7i\u001c8uKb$\bcA&\u0002p&\u0019\u0011\u0011\u001f'\u0003\u001bAcWoZ5o\u0007>tG/\u001a=u\u00035Ig.\u001b;ESJ,7\r^8ssR!\u00111HA|\u0011\u0019Q\u0018\u00071\u0001\u0002\u0004\u0006Y1\r[3dW\u0006\u001bG/[8o)\t\tY$A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002<\t\u0005\u0001b\u0002B\u0002g\u0001\u0007\u00111Q\u0001\u0007a\u0006\u0014\u0018-\\:\u0002\t\u0011,X\u000e\u001d\u000b\u0005\u0003w\u0011I\u0001C\u0004\u0003\u0004Q\u0002\r!a!\u0002\u000fI,7-Z5wKR!!q\u0002B\u000b!\r\t'\u0011C\u0005\u0004\u0005'\u0011'AB!osJ+g\rC\u0004\u0003\u0018U\u0002\rA!\u0007\u0002\u000f5,7o]1hKB\u0019\u0011Ma\u0007\n\u0007\tu!MA\u0002B]f\f\u0001b\u001d5vi\u0012|wO\u001c")
public class BuildAsyncProfilerDriverPlugin
implements DriverPlugin,
Logging {
    private final long checkingInterval;
    private final File localCacheDir;
    private final long resultCollectionTimeout;
    private final long profilingTimeout;
    private final String FLAG_FILE_DIR;
    private final Option<String> flagFileDir;
    private final AsyncProfilerUtils asyncProfilerUtils;
    private final ScheduledExecutorService scheduledExecutorService;
    private Path actionFilePath;
    private Path statusFileName;
    private Path dumpFileName;
    private boolean working;
    private Thread timeoutExecutionThread;
    private String nextCommand;
    private boolean running;
    private boolean dumped;
    private CountDownLatch cachedResult;
    private SparkContext sparkContext;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void registerMetrics(String x$1, PluginContext x$2) {
        super.registerMetrics(x$1, x$2);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private long checkingInterval() {
        return this.checkingInterval;
    }

    private File localCacheDir() {
        return this.localCacheDir;
    }

    private long resultCollectionTimeout() {
        return this.resultCollectionTimeout;
    }

    private long profilingTimeout() {
        return this.profilingTimeout;
    }

    private String FLAG_FILE_DIR() {
        return this.FLAG_FILE_DIR;
    }

    private Option<String> flagFileDir() {
        return this.flagFileDir;
    }

    private AsyncProfilerUtils asyncProfilerUtils() {
        return this.asyncProfilerUtils;
    }

    private ScheduledExecutorService scheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public Path actionFilePath() {
        return this.actionFilePath;
    }

    public void actionFilePath_$eq(Path x$1) {
        this.actionFilePath = x$1;
    }

    public Path statusFileName() {
        return this.statusFileName;
    }

    public void statusFileName_$eq(Path x$1) {
        this.statusFileName = x$1;
    }

    public Path dumpFileName() {
        return this.dumpFileName;
    }

    public void dumpFileName_$eq(Path x$1) {
        this.dumpFileName = x$1;
    }

    public boolean working() {
        return this.working;
    }

    public void working_$eq(boolean x$1) {
        this.working = x$1;
    }

    private Thread timeoutExecutionThread() {
        return this.timeoutExecutionThread;
    }

    private void timeoutExecutionThread_$eq(Thread x$1) {
        this.timeoutExecutionThread = x$1;
    }

    private String nextCommand() {
        return this.nextCommand;
    }

    private void nextCommand_$eq(String x$1) {
        this.nextCommand = x$1;
    }

    private boolean running() {
        return this.running;
    }

    private void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    private boolean dumped() {
        return this.dumped;
    }

    private void dumped_$eq(boolean x$1) {
        this.dumped = x$1;
    }

    private CountDownLatch cachedResult() {
        return this.cachedResult;
    }

    private void cachedResult_$eq(CountDownLatch x$1) {
        this.cachedResult = x$1;
    }

    private SparkContext sparkContext() {
        return this.sparkContext;
    }

    private void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public Map<String, String> init(SparkContext sc, PluginContext pluginContext) {
        Object object;
        this.sparkContext_$eq(sc);
        if (this.flagFileDir().isEmpty()) {
            this.working_$eq(false);
            this.log().error("Missing system parameter spark.profiler.flags.dir");
            object = BoxedUnit.UNIT;
        } else {
            this.actionFilePath_$eq(new Path(new StringBuilder(7).append((String)this.flagFileDir().get()).append("/action").toString()));
            this.statusFileName_$eq(new Path(new StringBuilder(7).append((String)this.flagFileDir().get()).append("/status").toString()));
            this.dumpFileName_$eq(new Path(new StringBuilder(12).append((String)this.flagFileDir().get()).append("/dump.tar.gz").toString()));
            this.initDirectory((String)this.flagFileDir().get());
            Runnable profile = new Runnable(this){
                private final /* synthetic */ BuildAsyncProfilerDriverPlugin $outer;

                public void run() {
                    this.$outer.checkAction();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            String deployMode = sc.getConf().get("spark.submit.deployMode", "");
            this.log().info("Current spark.submit.deployMode: {}", new Object[]{deployMode});
            AsyncProfilerTool$.MODULE$.loadAsyncProfilerLib(deployMode.equals("client"));
            this.log().info(new StringBuilder(22).append("AsyncProfiler status: ").append(AsyncProfilerTool$.MODULE$.status()).toString());
            object = this.scheduledExecutorService().scheduleWithFixedDelay(profile, 0L, this.checkingInterval(), TimeUnit.MILLISECONDS);
        }
        return super.init(sc, pluginContext);
    }

    public void initDirectory(String flagFileDir) {
        Path flagFileDirPath;
        FileSystem fs = HadoopUtil.getFileSystem((String)flagFileDir);
        Object object = !fs.exists(flagFileDirPath = new Path(flagFileDir)) ? BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(flagFileDirPath)) : BoxedUnit.UNIT;
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(flagFileDirPath))).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)fs.delete(file.getPath(), true)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
        HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)Message$.MODULE$.createDriverMessage(Message$.MODULE$.NOP(), Message$.MODULE$.createDriverMessage$default$2()), (Path)this.actionFilePath());
        HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.IDLE(), (Path)this.statusFileName());
    }

    public void checkAction() {
        block6: {
            try {
                FileSystem fs = HadoopUtil.getFileSystem((String)((String)this.flagFileDir().get()));
                String reply = HadoopUtil.readStringFromHdfs((FileSystem)fs, (Path)this.actionFilePath());
                Tuple3<String, String, String> tuple3 = Message$.MODULE$.processMessage(reply);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                String command = (String)tuple3._1();
                String param = (String)tuple3._3();
                Tuple2 tuple2 = new Tuple2((Object)command, (Object)param);
                Tuple2 tuple22 = tuple2;
                String command2 = (String)tuple22._1();
                String param2 = (String)tuple22._2();
                String string = command2;
                String string2 = Message$.MODULE$.START();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null) && !this.running()) {
                    this.start(param2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                String string4 = Message$.MODULE$.STOP();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null) && this.running()) {
                    this.dump(param2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                String string6 = Message$.MODULE$.DUMP();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null) && !this.dumped()) {
                    this.dump(param2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "error while communication/profiling", e);
            }
        }
    }

    public void start(String params) {
        String startParam = (String)Option$.MODULE$.apply((Object)params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "start,event=cpu");
        AsyncProfilerTool$ asyncProfilerTool$ = AsyncProfilerTool$.MODULE$;
        synchronized (asyncProfilerTool$) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler start");
            this.running_$eq(true);
            this.dumped_$eq(false);
            this.nextCommand_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.START(), startParam));
            AsyncProfilerTool$.MODULE$.start(startParam);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler started");
            FileSystem fs = HadoopUtil.getFileSystem((Path)this.statusFileName());
            fs.delete(this.dumpFileName(), true);
            HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.RUNNING(), (Path)this.statusFileName());
            this.timeoutExecutionThread_$eq(new Thread(() -> {
                try {
                    Thread.sleep(this.profilingTimeout());
                }
                catch (InterruptedException interruptedException) {
                    this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler stopped normally, timeout thread interrupted and exit");
                    Thread.currentThread().interrupt();
                }
                if (!Thread.interrupted()) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("profiling timeout after ").append(this.profilingTimeout()).append("ms, stopping profiling").toString());
                    AsyncProfilerTool$ asyncProfilerTool$ = AsyncProfilerTool$.MODULE$;
                    synchronized (asyncProfilerTool$) {
                        if (this.running()) {
                            this.running_$eq(false);
                            this.nextCommand_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.STOP(), Message$.MODULE$.createDriverMessage$default$2()));
                            AsyncProfilerTool$.MODULE$.stop();
                            HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.STOPPED(), (Path)this.statusFileName());
                            HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)Message$.MODULE$.createDriverMessage(Message$.MODULE$.NOP(), Message$.MODULE$.createDriverMessage$default$2()), (Path)this.actionFilePath());
                        }
                    }
                }
            }));
            this.timeoutExecutionThread().start();
        }
    }

    public void dump(String params) {
        block11: {
            String dumpParam = (String)Option$.MODULE$.apply((Object)params).getOrElse((Function0 & Serializable & scala.Serializable)() -> "flamegraph");
            AsyncProfilerTool$ asyncProfilerTool$ = AsyncProfilerTool$.MODULE$;
            synchronized (asyncProfilerTool$) {
                block9: {
                    if (this.dumped()) break block9;
                    if (this.running()) {
                        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiler stop");
                        this.running_$eq(false);
                        this.timeoutExecutionThread().interrupt();
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "profiling is not started");
                    }
                    this.dumped_$eq(true);
                    this.asyncProfilerUtils().cleanLocalCache();
                    this.cachedResult_$eq(new CountDownLatch(this.sparkContext().getExecutorMemoryStatus().size()));
                    this.asyncProfilerUtils().build(this.cachedResult());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("expecting ").append(this.cachedResult().getCount()).append(" to be collected").toString());
                    this.nextCommand_$eq(Message$.MODULE$.createDriverMessage(Message$.MODULE$.DUMP(), dumpParam));
                    this.asyncProfilerUtils().cacheDriverResult(AsyncProfilerTool$.MODULE$.dump(dumpParam));
                    FileSystem fs = HadoopUtil.getFileSystem((Path)this.statusFileName());
                    try (FSDataOutputStream outStream = null;){
                        outStream = fs.create(this.dumpFileName());
                        this.asyncProfilerUtils().waitForResult((OutputStream)outStream);
                    }
                    HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.DUMPED(), (Path)this.statusFileName());
                    break block11;
                }
                return;
            }
        }
    }

    public Object receive(Object message) {
        String string;
        Tuple3<String, String, String> tuple3 = Message$.MODULE$.processMessage(message.toString());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String command = (String)tuple3._1();
        String executorId = (String)tuple3._2();
        String param = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)command, (Object)executorId, (Object)param);
        Tuple3 tuple33 = tuple32;
        String command2 = (String)tuple33._1();
        String executorId2 = (String)tuple33._2();
        String param2 = (String)tuple33._3();
        String string2 = command2;
        String string3 = Message$.MODULE$.NEXT_COMMAND();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = this.nextCommand();
        } else {
            String string5 = Message$.MODULE$.RESULT();
            String string6 = string2;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                this.asyncProfilerUtils().cacheExecutorResult(param2, executorId2);
                string = "";
            } else {
                string = "";
            }
        }
        return string;
    }

    public void shutdown() {
        FileSystem fs = HadoopUtil.getFileSystem((Path)this.statusFileName());
        HadoopUtil.writeStringToHdfs((FileSystem)fs, (String)ProfilerStatus$.MODULE$.CLOSED(), (Path)this.statusFileName());
        ExecutorServiceUtil.shutdownGracefully((ExecutorService)this.scheduledExecutorService(), (int)3);
        super.shutdown();
    }

    public BuildAsyncProfilerDriverPlugin() {
        Logging.$init$((Logging)this);
        this.checkingInterval = 1000L;
        this.localCacheDir = Files.createTempDirectory("ke-build-async-profiler-result-", new FileAttribute[0]).toFile();
        this.localCacheDir().deleteOnExit();
        this.resultCollectionTimeout = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.props().get("spark.profiler.collection.timeout").getOrElse((Function0 & Serializable & scala.Serializable)() -> "60000"))).toLong();
        this.profilingTimeout = new StringOps(Predef$.MODULE$.augmentString((String)package$.MODULE$.props().get("spark.profiler.profiling.timeout").getOrElse((Function0 & Serializable & scala.Serializable)() -> "300000"))).toLong();
        this.FLAG_FILE_DIR = "spark.profiler.flagsDir";
        this.flagFileDir = package$.MODULE$.props().get(this.FLAG_FILE_DIR());
        this.asyncProfilerUtils = AsyncProfilerUtils.getInstance();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("profiler-action-check-%d").build());
        this.working = true;
        this.nextCommand = Message$.MODULE$.createDriverMessage(Message$.MODULE$.NOP(), Message$.MODULE$.createDriverMessage$default$2());
        this.running = false;
        this.dumped = false;
        this.asyncProfilerUtils().build(this.resultCollectionTimeout(), this.localCacheDir());
    }
}

