/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.metrics.MetricsCategory;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.metrics.MetricsName;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.common.util.SetThreadName;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.apache.kylin.metadata.favorite.AsyncAccelerationTask;
import org.apache.kylin.metadata.favorite.AsyncTaskManager;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.rest.service.ProjectSmartSupporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;

@Component(value="topRecsUpdateScheduler")
public class TopRecsUpdateScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopRecsUpdateScheduler.class);
    @Autowired(required=false)
    private ProjectSmartSupporter rawRecService;
    private final ScheduledThreadPoolExecutor taskScheduler;
    private final Map<String, Future> needUpdateProjects = Maps.newConcurrentMap();

    public TopRecsUpdateScheduler() {
        this.taskScheduler = new ScheduledThreadPoolExecutor(10, (ThreadFactory)new NamedThreadFactory("recommendation-update-topn"));
        this.taskScheduler.setKeepAliveTime(1L, TimeUnit.MINUTES);
        this.taskScheduler.allowCoreThreadTimeOut(true);
    }

    public void checkProject() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        this.taskScheduler.schedule(this::checkProject, 60L, TimeUnit.MINUTES);
        List allProjects = NProjectManager.getInstance((KylinConfig)config).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        log.info("Start to check projects for RecommendationTopNUpdateScheduler.");
        for (String project : allProjects) {
            if (this.needUpdateProjects.containsKey(project)) continue;
            this.addProject(project);
            log.info("Add project {} to needUpdateProjects.", (Object)project);
        }
        for (String project : this.needUpdateProjects.keySet()) {
            if (allProjects.contains(project)) continue;
            this.removeProject(project);
            log.info("Remove project {} from needUpdateProjects.", (Object)project);
        }
    }

    public synchronized void reScheduleProject(String project) {
        this.removeProject(project);
        this.addProject(project);
    }

    public synchronized void addProject(String project) {
        if (!this.needUpdateProjects.containsKey(project)) {
            this.scheduleNextTask(project, true);
        }
    }

    public synchronized void removeProject(String project) {
        Future task = this.needUpdateProjects.get(project);
        if (task != null) {
            log.debug("cancel {} future task", (Object)project);
            task.cancel(false);
        }
        this.needUpdateProjects.remove(project);
    }

    private synchronized boolean scheduleNextTask(String project, boolean isFirstSchedule) {
        if (!isFirstSchedule && !this.needUpdateProjects.containsKey(project)) {
            return false;
        }
        boolean needToSkip = false;
        try {
            if (!isFirstSchedule) {
                needToSkip = !this.saveTaskTime(project);
            }
        }
        catch (Exception e) {
            needToSkip = true;
            log.warn("{} task cancel, due to exception ", (Object)project, (Object)e);
        }
        long nextMilliSeconds = needToSkip ? this.computeNextTaskTimeGap(System.currentTimeMillis(), project) : this.computeNextTaskTimeGap(project);
        this.needUpdateProjects.put(project, this.taskScheduler.schedule(() -> this.work(project), nextMilliSeconds, TimeUnit.MILLISECONDS));
        return !needToSkip;
    }

    private void work(String project) {
        if (!this.scheduleNextTask(project, false)) {
            log.debug("{} task can't run, skip this time", (Object)project);
            return;
        }
        MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_OPS_CRON, (MetricsCategory)MetricsCategory.GLOBAL, (String)"_global");
        try (SetThreadName ignored = new SetThreadName("UpdateTopNRecommendationsWorker", new Object[0]);){
            log.info("Routine task to update {} cost and topN recommendations", (Object)project);
            this.rawRecService.updateCostsAndTopNCandidates(project);
            log.info("Updating {} cost and topN recommendations finished.", (Object)project);
        }
        MetricsGroup.hostTagCounterInc((MetricsName)MetricsName.METADATA_OPS_CRON_SUCCESS, (MetricsCategory)MetricsCategory.GLOBAL, (String)"_global");
    }

    private long computeNextTaskTimeGap(long lastTaskTime, String project) {
        long nextTaskTime = this.computeNextTaskTime(lastTaskTime, project);
        log.debug("project {} next task time is {}", (Object)project, (Object)nextTaskTime);
        return nextTaskTime - System.currentTimeMillis();
    }

    @VisibleForTesting
    protected long computeNextTaskTimeGap(String project) {
        long lastTaskTime = this.getLastTaskTime(project);
        return this.computeNextTaskTimeGap(lastTaskTime, project);
    }

    private long getLastTaskTime(String project) {
        AsyncAccelerationTask task = (AsyncAccelerationTask)AsyncTaskManager.getInstance((String)project).get("async_acceleration_task");
        return task.getLastUpdateTonNTime() == 0L ? System.currentTimeMillis() : task.getLastUpdateTonNTime();
    }

    protected boolean saveTaskTime(String project) {
        long currentTime = System.currentTimeMillis();
        AsyncTaskManager manager = AsyncTaskManager.getInstance((String)project);
        return (Boolean)JdbcUtil.withTxAndRetry((DataSourceTransactionManager)manager.getTransactionManager(), () -> {
            AsyncAccelerationTask asyncAcceleration = (AsyncAccelerationTask)manager.get("async_acceleration_task");
            AsyncAccelerationTask copied = (AsyncAccelerationTask)manager.copyForWrite((AbstractAsyncTask)asyncAcceleration);
            long lastUpdateTime = copied.getLastUpdateTonNTime();
            if (this.computeNextTaskTime(lastUpdateTime, project) > currentTime) {
                return false;
            }
            copied.setLastUpdateTonNTime(currentTime);
            manager.save((AbstractAsyncTask)copied);
            return true;
        });
    }

    private long computeNextTaskTime(long lastTaskTime, String project) {
        KylinConfigExt config = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).getConfig();
        if (!config.getUsingUpdateFrequencyRule()) {
            return lastTaskTime + config.getUpdateTopNTimeGap();
        }
        long lastTaskDayStart = this.getDateInMillis(lastTaskTime);
        int days = Integer.parseInt(FavoriteRuleManager.getInstance((String)project).getValue("update_frequency"));
        long taskStartInDay = (long)LocalTime.parse(config.getUpdateTopNTime()).toSecondOfDay() * 1000L;
        return lastTaskDayStart + 86400000L * (long)days + taskStartInDay;
    }

    private long getDateInMillis(long queryTime) {
        return TimeUtil.getDayStart((long)queryTime);
    }

    public int getTaskCount() {
        return this.needUpdateProjects.size();
    }

    public void close() {
        ExecutorServiceUtil.forceShutdown((ExecutorService)this.taskScheduler);
    }
}

