/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec.query.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rec.query.AbstractQueryRunner;
import org.apache.kylin.rec.query.SQLResult;
import org.apache.kylin.rec.query.advisor.ISqlAdvisor;
import org.apache.kylin.rec.query.advisor.SQLAdvice;
import org.apache.kylin.rec.query.validator.SQLValidateResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSQLValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSQLValidator.class);
    protected final String project;
    protected KylinConfig kylinConfig;
    ISqlAdvisor sqlAdvisor;

    AbstractSQLValidator(String project, KylinConfig kylinConfig) {
        this.project = project;
        this.kylinConfig = kylinConfig;
    }

    abstract AbstractQueryRunner createQueryRunner(String[] var1);

    public Map<String, SQLValidateResult> batchValidate(String[] sqls) {
        Map<String, SQLValidateResult> resultMap;
        if (ArrayUtils.isEmpty((Object[])sqls)) {
            return Maps.newHashMap();
        }
        try (AbstractQueryRunner queryRunner = this.createQueryRunner(sqls);){
            try {
                queryRunner.execute();
            }
            catch (InterruptedException e) {
                log.warn("Interrupted!!", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                log.error("batch validate sql error" + Arrays.toString(sqls), (Throwable)e);
            }
            resultMap = this.advice(queryRunner.getQueryResults());
        }
        return resultMap;
    }

    private Map<String, SQLValidateResult> advice(Map<String, SQLResult> queryResultMap) {
        HashMap validateStatsMap = Maps.newHashMap();
        queryResultMap.forEach((sql, sqlResult) -> {
            SQLAdvice advice = this.sqlAdvisor.propose((SQLResult)sqlResult);
            SQLValidateResult result = Objects.isNull(advice) ? SQLValidateResult.successStats(sqlResult) : SQLValidateResult.failedStats(Lists.newArrayList((Object[])new SQLAdvice[]{advice}), sqlResult);
            validateStatsMap.put(sql, result);
        });
        return validateStatsMap;
    }

    @Generated
    public String getProject() {
        return this.project;
    }
}

