/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;

public class ModelInfoAdjustProposer
extends AbstractProposer {
    public ModelInfoAdjustProposer(AbstractContext proposeContext) {
        super(proposeContext);
    }

    @Override
    public void execute() {
        for (AbstractContext.ModelContext modelCtx : this.proposeContext.getModelContexts()) {
            if (modelCtx.isTargetModelMissing()) continue;
            NDataModel model = modelCtx.getTargetModel();
            modelCtx.getProposeContext().changeModelMainType(model);
            this.setJoinTableType(model);
            model.setModelType(model.getModelTypeFromTable());
        }
    }

    private void setJoinTableType(NDataModel model) {
        for (JoinTableDesc joinTableDesc : model.getJoinTables()) {
            if (joinTableDesc.getTableRef().equals((Object)model.getRootFactTableRef())) continue;
            joinTableDesc.setKind(NDataModel.TableKind.LOOKUP);
        }
    }

    @Override
    public String getIdentifierName() {
        return "ModelInfoAdjustProposer";
    }
}

