/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core.mapping;

import org.springframework.data.keyvalue.core.mapping.AnnotationBasedKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.ClassNameKeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class BasicKeyValuePersistentEntity<T, P extends KeyValuePersistentProperty<P>>
extends BasicPersistentEntity<T, P>
implements KeyValuePersistentEntity<T, P> {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final KeySpaceResolver DEFAULT_FALLBACK_RESOLVER = ClassNameKeySpaceResolver.INSTANCE;
    @Nullable
    private final Expression keyspaceExpression;
    @Nullable
    private final String keyspace;

    public BasicKeyValuePersistentEntity(TypeInformation<T> information, @Nullable KeySpaceResolver fallbackKeySpaceResolver) {
        super(information);
        Class type = information.getType();
        String keySpace = AnnotationBasedKeySpaceResolver.INSTANCE.resolveKeySpace(type);
        if (StringUtils.hasText((String)keySpace)) {
            this.keyspace = keySpace;
            this.keyspaceExpression = BasicKeyValuePersistentEntity.detectExpression(keySpace);
        } else {
            this.keyspace = BasicKeyValuePersistentEntity.resolveKeyspace(fallbackKeySpaceResolver, type);
            this.keyspaceExpression = null;
        }
    }

    @Nullable
    private static Expression detectExpression(String potentialExpression) {
        Expression expression = PARSER.parseExpression(potentialExpression, ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    @Nullable
    private static String resolveKeyspace(@Nullable KeySpaceResolver fallbackKeySpaceResolver, Class<?> type) {
        return (fallbackKeySpaceResolver == null ? DEFAULT_FALLBACK_RESOLVER : fallbackKeySpaceResolver).resolveKeySpace(type);
    }

    @Override
    public String getKeySpace() {
        return this.keyspaceExpression == null ? this.keyspace : (String)this.keyspaceExpression.getValue(this.getEvaluationContext(null), String.class);
    }
}

