/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

public final class SparkResourceUtil$
implements Logging {
    public static SparkResourceUtil$ MODULE$;
    private final String MEMORY_OVERHEAD_FACTOR;
    private final String MIN_MEMORY_OVERHEAD;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkResourceUtil$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String MEMORY_OVERHEAD_FACTOR() {
        return this.MEMORY_OVERHEAD_FACTOR;
    }

    private String MIN_MEMORY_OVERHEAD() {
        return this.MIN_MEMORY_OVERHEAD;
    }

    public int getTotalCores(SQLConf sqlConf) {
        int n;
        String string = sqlConf.getConfString("spark.master");
        if (string.startsWith("local")) {
            n = new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.default.parallelism", "1"))).toInt();
        } else if (string.matches("(yarn|k8s:).*")) {
            int instances = this.getExecutorNum(sqlConf);
            int cores = new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.executor.cores", "1"))).toInt();
            n = Math.max(instances * cores, new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.default.parallelism", "1"))).toInt());
        } else if (string.startsWith("spark:")) {
            n = Math.max(new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.cores.max", "1"))).toInt(), new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.default.parallelism", "1"))).toInt());
        } else {
            throw new MatchError((Object)string);
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public int getExecutorNum(SQLConf sqlConf) {
        int n;
        if (new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.dynamicAllocation.enabled", "false"))).toBoolean()) {
            void var2_2;
            int maxExecutors = new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.dynamicAllocation.maxExecutors", sqlConf.getConfString("spark.default.parallelism", "1")))).toInt();
            n = var2_2;
        } else {
            n = new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString("spark.executor.instances", "1"))).toInt();
        }
        return n;
    }

    public int getExecutorCores(SparkConf conf) {
        int n;
        String master = conf.get("spark.master");
        String string = master;
        if ("local".equals(string)) {
            n = 1;
        } else {
            Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                n = SparkResourceUtil$.convertToInt$1(threads);
            } else {
                Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    n = SparkResourceUtil$.convertToInt$1(threads);
                } else {
                    n = conf.getInt("spark.executor.cores", 1);
                }
            }
        }
        int cores = n;
        return cores;
    }

    public int getTaskSlots(SparkConf conf) {
        int executorCores = this.getExecutorCores(conf);
        int taskCores = conf.getInt("spark.task.cpus", 1);
        return executorCores / taskCores;
    }

    public boolean isLocalMaster(SparkConf conf) {
        return Utils$.MODULE$.isLocalMaster(conf);
    }

    public boolean isMemoryOverheadSet(SparkConf conf) {
        return ((IterableLike)new .colon.colon((Object)package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD().key(), (List)new .colon.colon((Object)this.MEMORY_OVERHEAD_FACTOR(), (List)new .colon.colon((Object)this.MIN_MEMORY_OVERHEAD(), (List)Nil$.MODULE$)))).exists((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)conf.contains(key)));
    }

    public long getMemoryOverheadSize(SparkConf conf) {
        long overheadMib = BoxesRunTime.unboxToLong((Object)((Option)conf.get((ConfigEntry)package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> {
            long executorMemMib = BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.EXECUTOR_MEMORY()));
            double factor = conf.getDouble(MODULE$.MEMORY_OVERHEAD_FACTOR(), 0.1);
            long minMib = conf.getLong(MODULE$.MIN_MEMORY_OVERHEAD(), 384L);
            return RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper((long)((double)executorMemMib * factor)), minMib);
        }));
        return ByteUnit.MiB.toBytes(overheadMib);
    }

    private static final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null) ? Runtime.getRuntime().availableProcessors() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
    }

    private SparkResourceUtil$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.MEMORY_OVERHEAD_FACTOR = "spark.executor.memoryOverheadFactor";
        this.MIN_MEMORY_OVERHEAD = "spark.executor.minMemoryOverhead";
    }
}

