/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import java.util.Map;
import java.util.PriorityQueue;
import org.apache.gluten.memory.MemoryUsageStatsBuilder;
import org.apache.gluten.memory.memtarget.Spiller;
import org.apache.gluten.memory.memtarget.TreeMemoryTarget;

public class TreeMemoryTargets {
    private TreeMemoryTargets() {
    }

    static TreeMemoryTarget newChild(TreeMemoryTarget parent, String name, Spiller spiller, Map<String, MemoryUsageStatsBuilder> virtualChildren) {
        return parent.newChild(name, Long.MAX_VALUE, spiller, virtualChildren);
    }

    public static long spillTree(TreeMemoryTarget node, long bytes) {
        long remainingBytes = bytes;
        for (Spiller.Phase phase : Spiller.Phase.values()) {
            if (remainingBytes <= 0L) break;
            remainingBytes -= TreeMemoryTargets.spillTree(node, phase, remainingBytes);
        }
        return bytes - remainingBytes;
    }

    private static long spillTree(TreeMemoryTarget node, Spiller.Phase phase, long bytes) {
        long remainingBytes;
        long spilled;
        PriorityQueue<TreeMemoryTarget> q = new PriorityQueue<TreeMemoryTarget>((o1, o2) -> {
            long diff = o1.usedBytes() - o2.usedBytes();
            return -(diff > 0L ? 1 : (diff < 0L ? -1 : 0));
        });
        q.addAll(node.children().values());
        for (remainingBytes = bytes; q.peek() != null && remainingBytes > 0L; remainingBytes -= spilled) {
            TreeMemoryTarget head = (TreeMemoryTarget)q.remove();
            spilled = TreeMemoryTargets.spillTree(head, phase, remainingBytes);
        }
        if (remainingBytes > 0L) {
            Spiller spiller = node.getNodeSpiller();
            spilled = spiller.spill(node, phase, remainingBytes);
            remainingBytes -= spilled;
        }
        return bytes - remainingBytes;
    }
}

