/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.gluten.memory.memtarget.MemoryTarget;
import org.apache.gluten.memory.memtarget.Spiller;

public final class Spillers {
    public static final Spiller NOOP = new Spiller(){

        @Override
        public long spill(MemoryTarget self, Spiller.Phase phase, long size) {
            return 0L;
        }
    };
    public static final Set<Spiller.Phase> PHASE_SET_ALL = Collections.unmodifiableSet(new HashSet<Spiller.Phase>(Arrays.asList(Spiller.Phase.SHRINK, Spiller.Phase.SPILL)));
    public static final Set<Spiller.Phase> PHASE_SET_SHRINK_ONLY = Collections.singleton(Spiller.Phase.SHRINK);
    public static final Set<Spiller.Phase> PHASE_SET_SPILL_ONLY = Collections.singleton(Spiller.Phase.SPILL);

    private Spillers() {
    }

    public static Spiller withMinSpillSize(Spiller spiller, long minSize) {
        return new WithMinSpillSize(spiller, minSize);
    }

    public static AppendableSpillerList appendable() {
        return new AppendableSpillerList();
    }

    public static class AppendableSpillerList
    implements Spiller {
        private final List<Spiller> spillers = new LinkedList<Spiller>();

        private AppendableSpillerList() {
        }

        public void append(Spiller spiller) {
            this.spillers.add(spiller);
        }

        @Override
        public long spill(MemoryTarget self, Spiller.Phase phase, long size) {
            long remainingBytes = size;
            for (Spiller spiller : this.spillers) {
                if (remainingBytes <= 0L) break;
                remainingBytes -= spiller.spill(self, phase, remainingBytes);
            }
            return size - remainingBytes;
        }
    }

    private static class WithMinSpillSize
    implements Spiller {
        private final Spiller delegated;
        private final long minSize;

        private WithMinSpillSize(Spiller delegated, long minSize) {
            this.delegated = delegated;
            this.minSize = minSize;
        }

        @Override
        public long spill(MemoryTarget self, Spiller.Phase phase, long size) {
            return this.delegated.spill(self, phase, Math.max(size, this.minSize));
        }
    }
}

