/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.metadata;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.BuildLayoutWithUpdate;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegDetails;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.streaming.request.LayoutUpdateRequest;
import org.apache.kylin.streaming.rest.RestSupport;
import org.apache.kylin.streaming.util.JobExecutionIdHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildLayoutWithRestUpdate
extends BuildLayoutWithUpdate {
    protected static final Logger logger = LoggerFactory.getLogger(BuildLayoutWithRestUpdate.class);
    private JobTypeEnum jobType;

    public BuildLayoutWithRestUpdate(JobTypeEnum jobType) {
        this.jobType = jobType;
    }

    protected void updateLayouts(KylinConfig config, String project, String dataflowId, List<NDataLayout> layouts) {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        if (conf.isUTEnv()) {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                NDataflowUpdate update = new NDataflowUpdate(dataflowId);
                update.setToAddOrUpdateLayouts(layouts.toArray(new NDataLayout[0]));
                NDataflowManager.getInstance((KylinConfig)conf, (String)project).updateDataflow(update);
                return 0;
            }, (String)project);
        } else {
            this.callUpdateLayouts(conf, project, dataflowId, layouts);
        }
    }

    public void callUpdateLayouts(KylinConfig conf, String project, String dataflowId, List<NDataLayout> layouts) {
        String url = "/streaming_jobs/dataflow/layout";
        List<NDataSegDetails> segDetails = layouts.stream().map(item -> item.getSegDetails()).collect(Collectors.toList());
        LayoutUpdateRequest req = new LayoutUpdateRequest(project, dataflowId, layouts, segDetails);
        Preconditions.checkNotNull((Object)this.jobType);
        req.setJobType(this.jobType.name());
        String jobId = StreamingUtils.getJobId((String)dataflowId, (String)req.getJobType());
        req.setJobExecutionId(JobExecutionIdHolder.getJobExecutionId(jobId));
        try (RestSupport rest = new RestSupport(conf);){
            rest.execute((HttpRequestBase)rest.createHttpPut(url), req);
        }
        StreamingUtils.replayAuditlog();
    }
}

