/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.app;

import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.streaming.app.StreamingApplication;

public abstract class StreamingBuildApplication
extends StreamingApplication {
    protected int durationSec;
    protected String watermark;
    protected String baseCheckpointLocation;

    protected StreamingBuildApplication() {
        this.jobType = JobTypeEnum.STREAMING_BUILD;
        this.baseCheckpointLocation = this.kylinConfig.getStreamingBaseCheckpointLocation();
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.baseCheckpointLocation), (String)"base checkpoint location must be configured, %s", (Object)this.baseCheckpointLocation);
    }

    @Override
    public void parseParams(String[] args) {
        this.project = args[0];
        this.dataflowId = args[1];
        this.durationSec = Integer.parseInt(args[2]);
        this.watermark = args[3];
        this.distMetaUrl = args[4];
        this.jobId = StreamingUtils.getJobId((String)this.dataflowId, (String)this.jobType.name());
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.distMetaUrl), (Object)"distMetaUrl should not be empty!");
    }
}

