/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.kylin.parser.AbstractDataParser;

public class TimedJsonStreamParser
extends AbstractDataParser<ByteBuffer> {
    private final ObjectMapper mapper = new ObjectMapper();

    protected Map<String, Object> parse(ByteBuffer input) {
        TreeMap<String, Object> flatMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.traverseJsonNode("", this.mapper.readTree(input.array()), flatMap);
        return flatMap;
    }

    private void traverseJsonNode(String currentPath, JsonNode jsonNode, Map<String, Object> flatmap) {
        if (jsonNode.isObject()) {
            String pathPrefix;
            ObjectNode objectNode = (ObjectNode)jsonNode;
            Iterator iter = objectNode.fields();
            String string = pathPrefix = currentPath.isEmpty() ? "" : currentPath + "_";
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                this.traverseJsonNode(pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue(), flatmap);
            }
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            if (arrayNode.size() == 0) {
                flatmap.put(currentPath, "");
            }
            for (int i = 0; i < arrayNode.size(); ++i) {
                this.traverseJsonNode(currentPath + "_" + i, arrayNode.get(i), flatmap);
            }
        } else if (jsonNode.isValueNode()) {
            ValueNode valueNode = (ValueNode)jsonNode;
            this.getJsonValueByType(currentPath, flatmap, valueNode);
        }
    }

    private void getJsonValueByType(String currentPath, Map<String, Object> flatmap, ValueNode valueNode) {
        if (valueNode.isShort()) {
            this.addValueToFlatMap(flatmap, currentPath, valueNode.shortValue());
        } else if (valueNode.isInt()) {
            this.addValueToFlatMap(flatmap, currentPath, valueNode.intValue());
        } else if (valueNode.isLong()) {
            this.addValueToFlatMap(flatmap, currentPath, valueNode.longValue());
        } else if (valueNode.isBigDecimal()) {
            this.addValueToFlatMap(flatmap, currentPath, valueNode.decimalValue());
        } else if (valueNode.isFloat()) {
            this.addValueToFlatMap(flatmap, currentPath, Float.valueOf(valueNode.floatValue()));
        } else if (valueNode.isDouble()) {
            this.addValueToFlatMap(flatmap, currentPath, valueNode.doubleValue());
        } else if (valueNode.isBoolean()) {
            this.addValueToFlatMap(flatmap, currentPath, valueNode.booleanValue());
        } else {
            this.addValueToFlatMap(flatmap, currentPath, valueNode.asText());
        }
    }

    private void addValueToFlatMap(Map<String, Object> flatmap, String key, Object val) {
        this.addValueToFlatMap(flatmap, key, val, 0);
    }

    private void addValueToFlatMap(Map<String, Object> flatmap, String key, Object val, int iteTime) {
        if (flatmap.containsKey(key)) {
            key = key + "_" + ++iteTime;
            this.addValueToFlatMap(flatmap, key, val, iteTime);
        } else {
            flatmap.put(key, val);
        }
    }
}

