/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.exception.InternalErrorException;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.service.UserAclService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.CreateAdminUserUtils;
import org.apache.kylin.rest.util.InitUserGroupUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.CollectionUtils;

public class KylinUserService
implements UserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KylinUserService.class);
    public static final String DIR_PREFIX = "/user/";
    public static final Serializer<ManagedUser> SERIALIZER = new JsonSerializer(ManagedUser.class);
    @Autowired
    @Qualifier(value="userAclService")
    protected UserAclService userAclService;
    @Autowired
    Environment env;

    @PostConstruct
    private void initDefaultUserAndGroups() {
        InitUserGroupUtils.initUserGroups(this.env);
        try {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                CreateAdminUserUtils.createAllAdmins(this, this.env, this.userAclService);
                return null;
            }, (String)"_global");
        }
        catch (Exception e) {
            throw new KylinRuntimeException((Throwable)e);
        }
    }

    @Transaction
    public void createUser(UserDetails user) {
        if (this.getKylinUserManager().exists(user.getUsername())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATE_USER_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getUserExists(), user.getUsername()));
        }
        this.updateUser(user);
    }

    @Transaction
    public void updateUser(UserDetails user) {
        Preconditions.checkState((boolean)(user instanceof ManagedUser), (String)"User {} is not ManagedUser", (Object)user);
        ManagedUser managedUser = (ManagedUser)user;
        if (!managedUser.getAuthorities().contains(new SimpleGrantedAuthority("ALL_USERS"))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, MsgPicker.getMsg().getInvalidRemoveUserFromAllUser());
        }
        this.getKylinUserManager().update(managedUser);
        this.userAclService.updateUserAclPermission(user, AclPermission.DATA_QUERY);
        log.trace("update user : {}", (Object)user.getUsername());
    }

    @Transaction
    public void deleteUser(String userName) {
        List<String> superAdminUsers = this.listSuperAdminUsers();
        if (!CollectionUtils.isEmpty(superAdminUsers) && !superAdminUsers.stream().filter(u -> u.equalsIgnoreCase(userName)).collect(Collectors.toList()).isEmpty()) {
            throw new InternalErrorException("User " + userName + " is not allowed to be deleted.");
        }
        this.userAclService.deleteUserAcl(userName);
        this.getKylinUserManager().delete(userName);
        log.trace("delete user : {}", (Object)userName);
    }

    public void changePassword(String oldPassword, String newPassword) {
        throw new UnsupportedOperationException();
    }

    public boolean userExists(String userName) {
        log.trace("judge user exist: {}", (Object)userName);
        return this.getKylinUserManager().exists(userName);
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        ManagedUser managedUser;
        Message msg = MsgPicker.getMsg();
        NKylinUserManager manager = this.getKylinUserManager();
        try {
            managedUser = manager.get(userName);
        }
        catch (IllegalArgumentException e) {
            log.error("exception: ", (Throwable)e);
            throw new UsernameNotFoundException(ErrorCodeServer.USER_LOGIN_FAILED.getMsg(new Object[0]));
        }
        if (managedUser == null) {
            throw new UsernameNotFoundException(String.format(Locale.ROOT, msg.getUserNotFound(), userName));
        }
        log.trace("load user : {}", (Object)userName);
        return manager.copy(managedUser);
    }

    @Override
    public List<ManagedUser> listUsers() {
        return this.getKylinUserManager().list();
    }

    @Override
    public List<ManagedUser> listUsers(boolean needSort) {
        return this.getKylinUserManager().list(needSort);
    }

    @Override
    public List<String> listAdminUsers() {
        SimpleGrantedAuthority adminAuthority = new SimpleGrantedAuthority("ROLE_ADMIN");
        return this.listUsers().stream().filter(user -> user.getAuthorities().contains(adminAuthority)).map(ManagedUser::getUsername).collect(Collectors.toList());
    }

    @Override
    public boolean isGlobalAdmin(String username) {
        try {
            UserDetails userDetails = this.loadUserByUsername(username);
            return this.isGlobalAdmin(userDetails);
        }
        catch (Exception e) {
            logger.debug("Cat not load user by username {}", (Object)username, (Object)e);
            return false;
        }
    }

    @Override
    public boolean isGlobalAdmin(UserDetails userDetails) {
        if (Objects.isNull(userDetails)) {
            return false;
        }
        return userDetails.getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals("ROLE_ADMIN"));
    }

    @Override
    public boolean containsGlobalAdmin(Set<String> usernames) {
        return usernames.stream().anyMatch(this::isGlobalAdmin);
    }

    @Override
    public Set<String> retainsNormalUser(Set<String> usernames) {
        return usernames.stream().filter(username -> !this.isGlobalAdmin((String)username)).collect(Collectors.toSet());
    }

    @Override
    public List<String> listNormalUsers() {
        SimpleGrantedAuthority adminAuthority = new SimpleGrantedAuthority("ROLE_ADMIN");
        return this.listUsers().stream().filter(user -> !user.getAuthorities().contains(adminAuthority)).map(ManagedUser::getUsername).collect(Collectors.toList());
    }

    @Override
    public List<String> listSuperAdminUsers() {
        return Collections.singletonList("ADMIN");
    }

    @Override
    public void completeUserInfo(ManagedUser user) {
    }

    public static String getId(String userName) {
        return DIR_PREFIX + userName;
    }

    protected NKylinUserManager getKylinUserManager() {
        return NKylinUserManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
    }
}

